/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import java.util.Set;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.SecurityMetadataPlan;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.security.RoleInstance;
import oracle.kv.impl.security.metadata.SecurityMetadata;

public class GrantRolesToRole
extends UpdateMetadata<SecurityMetadata> {
    private static final long serialVersionUID = 1L;
    private final String grantee;
    private final Set<String> roles;

    public GrantRolesToRole(SecurityMetadataPlan.RolePlan plan, String grantee, Set<String> roles) {
        super(plan);
        SecurityMetadata secMd = (SecurityMetadata)plan.getMetadata();
        if (secMd == null || secMd.getRole(grantee) == null) {
            throw new IllegalCommandException("Role with name " + grantee + " does not exist in store");
        }
        this.grantee = grantee;
        this.roles = roles;
        for (String roleName : roles) {
            this.checkCircularGrants(roleName, secMd);
        }
    }

    private void checkCircularGrants(String roleName, SecurityMetadata secMd) {
        if (roleName.equalsIgnoreCase(this.grantee)) {
            throw new IllegalCommandException("Could not complete grant, circular role grant detected");
        }
        RoleInstance role = secMd.getRole(roleName);
        if (role == null) {
            return;
        }
        for (String subRole : role.getGrantedRoles()) {
            this.checkCircularGrants(subRole, secMd);
        }
    }

    @Override
    protected SecurityMetadata updateMetadata() {
        SecurityMetadata secMd = (SecurityMetadata)this.plan.getMetadata();
        if (secMd == null || secMd.getRole(this.grantee) == null) {
            return null;
        }
        RoleInstance newCopy = secMd.getRole(this.grantee).clone();
        secMd.updateRole(newCopy.getElementId(), newCopy.grantRoles(this.roles));
        this.plan.getAdmin().saveMetadata(secMd, this.plan);
        return secMd;
    }

    @Override
    public boolean logicalCompare(Task t) {
        if (this == t) {
            return true;
        }
        if (t == null) {
            return false;
        }
        if (this.getClass() != t.getClass()) {
            return false;
        }
        GrantRolesToRole other = (GrantRolesToRole)t;
        if (!this.grantee.equalsIgnoreCase(other.grantee)) {
            return false;
        }
        return this.roles.equals(other.roles);
    }
}

