/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.rmi.NotBoundException;
import java.util.List;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.DeploySNPlan;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.sna.StorageNodeAgent;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent(version=1)
public class DeploySN
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private DeploySNPlan plan;
    private boolean isFirst;

    public DeploySN(DeploySNPlan plan, boolean isFirst) {
        this.plan = plan;
        this.isFirst = isFirst;
    }

    private DeploySN() {
    }

    @Override
    public Task.State doWork() throws Exception {
        StorageNodeAgentAPI sna;
        StorageNodeId snId = this.plan.getStorageNodeId();
        RegistryUtils trialRegistry = new RegistryUtils(this.plan.getTopology(), this.plan.getAdmin().getLoginManager());
        try {
            sna = trialRegistry.getStorageNodeAgent(snId);
            ConfigurableService.ServiceStatus serviceStatus = sna.ping().getServiceStatus();
            if (serviceStatus.isAlive() && serviceStatus != ConfigurableService.ServiceStatus.WAITING_FOR_DEPLOY) {
                this.plan.getLogger().info(this + ": SNA already deployed, " + "had status of " + (Object)((Object)serviceStatus));
                return Task.State.SUCCEEDED;
            }
        }
        catch (NotBoundException notbound) {
            // empty catch block
        }
        StorageNodeParams inputSNP = this.plan.getInputStorageNodeParams();
        try {
            sna = RegistryUtils.getStorageNodeAgent(inputSNP.getHostname(), inputSNP.getRegistryPort(), "snaService", this.plan.getLoginManager());
        }
        catch (NotBoundException e) {
            NotBoundException wrapped = new NotBoundException("The bootstrap storage node service was not found, which may mean the storage node is part of another store; nested exception is:\n\t" + e);
            wrapped.initCause(e);
            throw wrapped;
        }
        Admin admin = this.plan.getAdmin();
        StorageNodeParams registrationParams = this.plan.getRegistrationParams();
        GlobalParams gp = admin.getParams().getGlobalParams();
        List<ParameterMap> snMaps = sna.register(gp.getMap(), registrationParams.getMap(), this.isFirst);
        StorageNodeAgent.RegisterReturnInfo rri = new StorageNodeAgent.RegisterReturnInfo(snMaps);
        registrationParams.setInstallationInfo(rri.getBootMap(), rri.getMountMap(), this.isFirst);
        if (this.plan.isFirstExecutionAttempt()) {
            if (this.isFirst) {
                gp.setIsLoopback(rri.getIsLoopback());
                admin.saveTopoAndParams(this.plan.getTopology(), this.plan.getDeployedInfo(), registrationParams, gp, (Plan)this.plan);
            } else {
                admin.saveTopoAndParams(this.plan.getTopology(), this.plan.getDeployedInfo(), registrationParams, null, (Plan)this.plan);
            }
        }
        admin.getMonitor().registerAgent(registrationParams.getHostname(), registrationParams.getRegistryPort(), this.plan.getStorageNodeId());
        return Task.State.SUCCEEDED;
    }

    @Override
    public String toString() {
        StorageNodeParams snp = this.plan.getInputStorageNodeParams();
        return super.toString() + " " + this.plan.getStorageNodeId() + "(" + snp.getHostname() + ":" + snp.getRegistryPort() + ")";
    }

    @Override
    public boolean continuePastError() {
        return false;
    }
}

