/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.rep.MasterStateException;
import com.sleepycat.je.rep.MemberActiveException;
import com.sleepycat.je.rep.MemberNotFoundException;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.StartAdmin;
import oracle.kv.impl.admin.plan.task.StopAdmin;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.registry.RegistryUtils;

public class ChangeAdminType
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private final AbstractPlan plan;
    private final AdminId adminId;

    public ChangeAdminType(AbstractPlan plan, AdminId adminId) {
        this.plan = plan;
        this.adminId = adminId;
    }

    @Override
    public Task.State doWork() throws Exception {
        return ChangeAdminType.change(this.plan, this.adminId);
    }

    public static Task.State change(AbstractPlan plan, AdminId targetId) throws RemoteException, NotBoundException {
        Admin admin = plan.getAdmin();
        AdminId masterAdmin = admin.getParams().getAdminParams().getAdminId();
        if (targetId.equals(masterAdmin)) {
            ChangeAdminType.log(plan, targetId, "it is currently the master");
            return Task.State.ERROR;
        }
        Topology topo = admin.getCurrentTopology();
        Parameters parameters = admin.getCurrentParameters();
        AdminParams ap = parameters.get(targetId);
        StorageNode sn = (StorageNode)topo.getStorageNodeMap().get(ap.getStorageNodeId());
        if (sn == null) {
            ChangeAdminType.log(plan, targetId, ap.getStorageNodeId() + " was not found");
            return Task.State.ERROR;
        }
        Datacenter dc = topo.get(sn.getDatacenterId());
        StorageNodeId snId = sn.getStorageNodeId();
        Task.State state = StopAdmin.stop(plan, targetId, snId);
        if (!state.equals((Object)Task.State.SUCCEEDED)) {
            ChangeAdminType.log(plan, targetId, "stop failed with " + (Object)((Object)state));
            return state;
        }
        Task.State ret = Task.State.SUCCEEDED;
        if (dc.getDatacenterType().isSecondary()) {
            ReplicationGroupAdmin jeAdmin = admin.getReplicationGroupAdmin(masterAdmin);
            String targetNodeName = Admin.getAdminRepNodeName(targetId);
            try {
                jeAdmin.deleteMember(targetNodeName);
            }
            catch (IllegalArgumentException iae) {
            }
            catch (UnknownMasterException ume) {
                ChangeAdminType.log(plan, targetId, "the master was not found");
                ret = Task.State.ERROR;
            }
            catch (MemberActiveException mae) {
                ChangeAdminType.log(plan, targetId, "it is active");
                ret = Task.State.ERROR;
            }
            catch (MemberNotFoundException mnfe) {
                ChangeAdminType.log(plan, targetId, "it was not found");
                ret = Task.State.ERROR;
            }
            catch (MasterStateException mse) {
                ChangeAdminType.log(plan, targetId, "it is currently the master");
                ret = Task.State.ERROR;
            }
            catch (OperationFailureException ofe) {
                ChangeAdminType.log(plan, targetId, "unexpected exception: " + (Object)((Object)ofe));
                ret = Task.State.ERROR;
            }
        }
        if (ret.equals((Object)Task.State.SUCCEEDED)) {
            ap.setType(Utils.getAdminType(dc.getDatacenterType()));
            ap.getMap().setParameter("configProperties", "je.rep.ignoreSecondaryNodeId=true");
            admin.updateParams(ap);
            StorageNodeAgentAPI sna = RegistryUtils.getStorageNodeAgent(parameters, snId, plan.getLoginManager());
            sna.newAdminParameters(ap.getMap());
        }
        StartAdmin.start(plan, targetId, snId);
        return ret;
    }

    private static void log(AbstractPlan plan, AdminId targetId, String cause) {
        plan.getLogger().log(Level.INFO, "Couldn''t change {0} because {1}", new Object[]{targetId, cause});
    }

    @Override
    public boolean continuePastError() {
        return false;
    }
}

