/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.admin.plan.PlanRun;
import oracle.kv.impl.admin.plan.PlanStateChange;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.util.server.LoggerUtils;

@Persistent
public class ExecutionState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Plan.State preRunState;
    private List<PlanRun> history;
    private String planName;

    public ExecutionState(String planName) {
        this.planName = planName;
        this.history = new ArrayList<PlanRun>();
        this.preRunState = Plan.State.PENDING;
    }

    private ExecutionState() {
    }

    public Plan.State getLatestState() {
        if (this.history.size() == 0) {
            return this.preRunState;
        }
        return this.history.get(this.history.size() - 1).getState();
    }

    public Date getLatestStartTime() {
        if (this.history.size() == 0) {
            return null;
        }
        return new Date(this.history.get(this.history.size() - 1).getStartTime());
    }

    public Date getLatestEndTime() {
        if (this.history.size() == 0) {
            return null;
        }
        return new Date(this.history.get(this.history.size() - 1).getEndTime());
    }

    void validateStartOfNewRun(Plan plan) {
        Plan.State latestState = this.getLatestState();
        if (!latestState.checkTransition(Plan.State.RUNNING)) {
            throw new IllegalCommandException(plan + " can't be run, last state was " + (Object)((Object)latestState));
        }
    }

    PlanRun startNewRun() {
        int numPastRuns = this.history.size();
        if (numPastRuns > 0) {
            for (int i = numPastRuns - 1; i >= 0; --i) {
                Plan.State pastState = this.history.get(i).getState();
                if (pastState == Plan.State.ERROR || pastState == Plan.State.INTERRUPTED) continue;
                throw new OperationFaultException("This plan can only be retried if previous attempts were interrupted or failed. Run " + i + " status=" + (Object)((Object)pastState) + " Past run status: " + this.showRuns());
            }
        }
        PlanRun attempt = new PlanRun(this.history.size() + 1, this);
        this.history.add(attempt);
        return attempt;
    }

    String showRuns() {
        StringBuilder sb = new StringBuilder();
        for (PlanRun run : this.history) {
            sb.append(run + "\n");
        }
        return sb.toString();
    }

    String getLatestRunFailureDescription() {
        PlanRun planRun = this.getLatestPlanRun();
        if (planRun == null) {
            return null;
        }
        return planRun.getFailureDescription(true);
    }

    void setPlanState(Planner planner, Plan plan, Plan.State newState, String msg) {
        if (this.history.size() == 0) {
            this.preRunState = this.changeState(planner, plan, this.preRunState, newState, 0, msg);
            return;
        }
        this.getLatestPlanRun().setState(planner, plan, newState, msg);
    }

    Plan.State changeState(Planner planner, Plan plan, Plan.State oldState, Plan.State newState, int attemptNumber, String msg) {
        if (oldState == newState) {
            return newState;
        }
        Plan.State.validateTransition(oldState, newState);
        PlanStateChange change = new PlanStateChange(plan.getId(), plan.getName(), newState, attemptNumber, msg);
        planner.getAdmin().getMonitor().publish(change);
        return newState;
    }

    public PlanRun getLatestPlanRun() {
        if (this.history.size() == 0) {
            return null;
        }
        return this.history.get(this.history.size() - 1);
    }

    String getPlanName() {
        return this.planName;
    }

    public List<PlanRun> getHistory() {
        return this.history;
    }

    ExceptionTransfer getLatestExceptionTransfer() {
        PlanRun planRun = this.getLatestPlanRun();
        if (planRun == null) {
            return null;
        }
        return planRun.getExceptionTransfer();
    }

    @Persistent
    public static class ExceptionTransfer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient Throwable failure = null;
        private String stackTrace = null;
        private String description;

        ExceptionTransfer(Throwable t, String msg) {
            this.description = msg;
            if (t != null) {
                Throwable trueCause = t;
                if (t instanceof ExecutionException) {
                    trueCause = t.getCause();
                }
                this.failure = trueCause;
                if (trueCause.getMessage() != null) {
                    this.description = this.description + ": " + trueCause.getMessage();
                }
                this.stackTrace = LoggerUtils.getStackTrace(t);
            }
        }

        ExceptionTransfer() {
        }

        public Throwable getFailure() {
            if (this.failure == null && this.stackTrace != null) {
                throw new NonfatalAssertionException("Unexpected call to getFailure after reconstitution.");
            }
            return this.failure;
        }

        public String getDescription() {
            return this.description;
        }

        public String getStackTrace() {
            return this.stackTrace;
        }

        public String toString() {
            return this.description + " " + this.stackTrace;
        }
    }
}

