/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import com.sleepycat.je.rep.ReplicationNetworkConfig;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import java.net.InetSocketAddress;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.PollCondition;
import oracle.kv.impl.util.PortRange;

public class TopologyCheckUtils {
    static Map<StorageNodeId, SNServices> groupServicesBySN(Topology topology, Parameters params) {
        TreeMap<StorageNodeId, SNServices> resourceInfo = new TreeMap<StorageNodeId, SNServices>(new SNNameComparator());
        List<StorageNode> sortedSNs = topology.getSortedStorageNodes();
        for (StorageNode sn : sortedSNs) {
            resourceInfo.put((StorageNodeId)sn.getResourceId(), new SNServices((StorageNodeId)sn.getResourceId()));
        }
        for (RepGroup rg : topology.getRepGroupMap().getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                StorageNodeId target = rn.getStorageNodeId();
                SNServices snInfo = (SNServices)resourceInfo.get(target);
                snInfo.add((RepNodeId)rn.getResourceId());
            }
        }
        for (AdminId adId : params.getAdminIds()) {
            StorageNodeId target = params.get(adId).getStorageNodeId();
            SNServices snInfo = (SNServices)resourceInfo.get(target);
            if (snInfo == null) {
                snInfo = new SNServices(target);
                resourceInfo.put(target, snInfo);
            }
            snInfo.add(adId);
        }
        return resourceInfo;
    }

    static Set<ReplicationNode> getJEHAGroupDB(final String groupName, int timeoutMs, final Logger logger, final Set<InetSocketAddress> helperSockets, final ReplicationNetworkConfig repNetConfig) {
        StringBuilder problem;
        HashSet<ReplicationNode> groupDB;
        boolean found;
        int checkMs = timeoutMs;
        if (checkMs > 1000) {
            checkMs = 1000;
        }
        if (!(found = new PollCondition(checkMs, timeoutMs, groupDB = new HashSet<ReplicationNode>(), problem = new StringBuilder()){
            final /* synthetic */ Set val$groupDB;
            final /* synthetic */ StringBuilder val$problem;
            {
                this.val$groupDB = set2;
                this.val$problem = stringBuilder;
                super(x0, x1);
            }

            @Override
            protected boolean condition() {
                logger.fine("TopoCheckUtils:  getting JE repGroupDb for " + groupName);
                try {
                    ReplicationGroupAdmin jeRGA = new ReplicationGroupAdmin(groupName, helperSockets, repNetConfig);
                    this.val$groupDB.addAll(jeRGA.getGroup().getDataNodes());
                    return true;
                }
                catch (Exception e) {
                    this.val$problem.append(e.getMessage());
                    return false;
                }
            }
        }.await())) {
            logger.fine("TopoCheckUtils unable to get JE repGroupDb for " + groupName + " " + problem);
        }
        return groupDB;
    }

    static StorageNodeId translateToSNId(Topology topo, Parameters params, Set<StorageNodeId> snCheckSet, String haHostname, int haPort) {
        StorageNodeParams snp;
        for (StorageNodeId snId : snCheckSet) {
            snp = params.get(snId);
            if (!snp.getHAHostname().equals(haHostname) || !PortRange.contains(snp.getHAPortRange(), haPort)) continue;
            return snId;
        }
        for (StorageNodeId snId : topo.getStorageNodeIds()) {
            snp = params.get(snId);
            if (!snp.getHAHostname().equals(haHostname) || !PortRange.contains(snp.getHAPortRange(), haPort)) continue;
            return snId;
        }
        return null;
    }

    public static String findPeerRNHelpers(RepNodeId targetRNId, Parameters parameters, Topology topo) {
        RepNode targetRN = topo.get(targetRNId);
        RepGroup rg = topo.get(targetRN.getRepGroupId());
        StringBuilder helperHosts = new StringBuilder();
        for (RepNode rn : rg.getRepNodes()) {
            if (((RepNodeId)rn.getResourceId()).equals(targetRNId)) continue;
            if (helperHosts.length() != 0) {
                helperHosts.append(",");
            }
            RepNodeParams peerParams = parameters.get((RepNodeId)rn.getResourceId());
            helperHosts.append(peerParams.getJENodeHostPort());
        }
        return helperHosts.toString();
    }

    static class SNServices {
        private final StorageNodeId snId;
        public final Set<RepNodeId> rnIds;
        public AdminId adminId;
        public LoadParameters remoteParams;

        SNServices(StorageNodeId snId) {
            this.snId = snId;
            this.rnIds = new TreeSet<RepNodeId>();
        }

        public void add(AdminId adId) {
            this.adminId = adId;
        }

        public void add(RepNodeId rnId) {
            this.rnIds.add(rnId);
        }

        SNServices(StorageNodeId snId, Set<RepNodeId> allRNs, AdminId aId, LoadParameters remoteParams) {
            this.snId = snId;
            this.rnIds = allRNs;
            this.adminId = aId;
            this.remoteParams = remoteParams;
        }

        Set<RepNodeId> getAllRepNodeIds() {
            return this.rnIds;
        }

        AdminId getAdminId() {
            return this.adminId;
        }

        StorageNodeId getStorageNodeId() {
            return this.snId;
        }

        Set<RepNodeId> getAllRNs() {
            return this.rnIds;
        }

        public boolean contains(RepNodeId rnId) {
            return this.rnIds.contains(rnId);
        }
    }

    static class SNNameComparator
    implements Comparator<StorageNodeId> {
        SNNameComparator() {
        }

        @Override
        public int compare(StorageNodeId o1, StorageNodeId o2) {
            return o1.getStorageNodeId() - o2.getStorageNodeId();
        }
    }
}

