/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import java.net.SocketException;
import java.util.HashSet;
import javax.security.auth.Subject;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.LoginCredentials;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.AdminPasswordRenewer;
import oracle.kv.impl.admin.AdminService;
import oracle.kv.impl.admin.AdminUserVerifier;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.security.KVStoreRolePrincipal;
import oracle.kv.impl.security.login.LoginResult;
import oracle.kv.impl.security.login.LoginTable;
import oracle.kv.impl.security.login.UserLoginHandler;
import oracle.kv.impl.security.util.SecurityUtils;
import oracle.kv.impl.topo.AdminId;

public class AdminLoginHandler
extends UserLoginHandler {
    private final AdminService adminService;
    private final AdminUserVerifier userVerifier;
    private final LoginTable sessionMgr;

    public static AdminLoginHandler create(AdminService adminService) {
        AdminUserVerifier adminVerifier = new AdminUserVerifier(adminService);
        AdminPasswordRenewer passwordRenewer = new AdminPasswordRenewer(adminService);
        AdminParams ap = adminService.getParams().getAdminParams();
        Admin admin = adminService.getAdmin();
        AdminId adminId = null;
        adminId = admin != null ? ap.getAdminId() : new AdminId(-1);
        GlobalParams gp = adminService.getParams().getGlobalParams();
        UserLoginHandler.LoginConfig loginConfig = UserLoginHandler.LoginConfig.buildLoginConfig(gp);
        LoginTable sessMgr = new LoginTable(ap.getSessionLimit(), new byte[0], 16);
        return new AdminLoginHandler(adminId, adminService, adminVerifier, passwordRenewer, sessMgr, loginConfig);
    }

    @Override
    public LoginResult login(LoginCredentials creds, String clientHost) throws AuthenticationFailureException {
        if (!this.userVerifier.userDataExists()) {
            if (creds != null) {
                throw new AuthenticationFailureException("No user data exists, only anonymous login is allowed.");
            }
            return this.tryAnonymousLogin(creds, clientHost);
        }
        if (creds == null) {
            throw new AuthenticationFailureException("Authentication failed");
        }
        return super.login(creds, clientHost);
    }

    LoginResult tryAnonymousLogin(LoginCredentials creds, String clientHost) throws AuthenticationFailureException {
        boolean isLocal = false;
        try {
            isLocal = SecurityUtils.isLocalHost(clientHost);
        }
        catch (SocketException se) {
            this.logger.info("Encountered exception while checking whether " + clientHost + " is local: " + se);
        }
        catch (SecurityException se) {
            this.logger.info("Encountered exception while checking whether " + clientHost + " is local: " + se);
        }
        if (!isLocal) {
            this.logger.info("anonymous client login from " + clientHost + ": host is not a local address");
            throw new AuthenticationFailureException("Anonymous login allowed only from local host");
        }
        return this.createLoginSession(this.makeAdminSubject(), clientHost);
    }

    private AdminLoginHandler(AdminId ownerId, AdminService adminService, AdminUserVerifier adminVerifier, AdminPasswordRenewer passwordRenewer, LoginTable sessionManager, UserLoginHandler.LoginConfig loginConfig) {
        super(ownerId, adminService.getAdmin() == null, adminVerifier, passwordRenewer, sessionManager, loginConfig, adminService.getLogger());
        this.adminService = adminService;
        this.userVerifier = adminVerifier;
        this.sessionMgr = sessionManager;
    }

    private Subject makeAdminSubject() {
        HashSet<KVStoreRolePrincipal> adminPrincipals = new HashSet<KVStoreRolePrincipal>();
        adminPrincipals.add(KVStoreRolePrincipal.SYSADMIN);
        adminPrincipals.add(KVStoreRolePrincipal.PUBLIC);
        HashSet publicCreds = new HashSet();
        HashSet privateCreds = new HashSet();
        return new Subject(true, adminPrincipals, publicCreds, privateCreds);
    }

    public boolean updateSessionLimit(int newLimit) {
        return this.sessionMgr.updateSessionLimit(newLimit);
    }
}

