/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.core.ojdl.logging.HandlerFactory;
import oracle.core.ojdl.logging.LoggingConfigurationException;
import oracle.core.ojdl.logging.ODLHandler;
import oracle.core.ojdl.logging.ODLHandlerBase;
import oracle.core.ojdl.logging.ODLHandlerFactory;
import oracle.core.ojdl.logging.ODLLevel;
import oracle.core.ojdl.logging.ODLLogger;
import oracle.core.ojdl.logging.QuickTraceHandler;
import oracle.core.ojdl.logging.QuickTraceHandlerFactory;
import oracle.core.ojdl.messages.Messages;
import oracle.core.ojdl.messages.Msgs;
import oracle.core.ojdl.util.SAXErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class LoggingConfigurationImpl
implements PropertyChangeListener {
    private HashMap m_warningIssued = new HashMap();
    private static final String CONFIG_FILE_PROP = "oracle.core.ojdl.logging.config.file";
    private static final String DTD_PATH = "/oracle/core/ojdl/logging/logging-config.dtd";
    private File m_referenceDir;
    private Map<String, HandlerState> m_handlers = new HashMap<String, HandlerState>();
    private Map<String, LoggerState> m_loggers = new HashMap<String, LoggerState>();
    private String m_fileName = "";
    private Properties m_handlerDefaults = new Properties();
    private Properties m_env;
    private static Class QUICKTRACEHANDLERCLASS;

    public LoggingConfigurationImpl() throws LoggingConfigurationException {
        String configFile = System.getProperty(CONFIG_FILE_PROP);
        if (configFile == null) {
            throw new LoggingConfigurationException(Msgs.get("ODL-52040", this.getClass().getName(), CONFIG_FILE_PROP));
        }
        this.m_fileName = configFile;
        this.m_referenceDir = new File(configFile).getParentFile();
        LogManager.getLogManager().reset();
        this.configure(this.parse(configFile), true);
    }

    public LoggingConfigurationImpl(String configFile) throws LoggingConfigurationException {
        this.m_fileName = configFile;
        this.m_referenceDir = new File(configFile).getParentFile();
        this.configure(this.parse(configFile), true);
    }

    public LoggingConfigurationImpl(String configFile, Properties env) throws LoggingConfigurationException {
        this.m_env = env;
        this.m_fileName = configFile;
        this.m_referenceDir = new File(configFile).getParentFile();
        this.configure(this.parse(configFile), true);
    }

    public LoggingConfigurationImpl(Document document) throws LoggingConfigurationException {
        this.configure(document, false);
    }

    public void reset() {
        for (LoggerState ls : this.m_loggers.values()) {
            ls.resetLogger(this.m_handlers);
        }
        for (HandlerState hs : this.m_handlers.values()) {
            hs.closeHandler();
        }
        this.m_handlers = new HashMap<String, HandlerState>();
        this.m_loggers = new HashMap<String, LoggerState>();
    }

    public void reload(String path) throws LoggingConfigurationException {
        this.m_fileName = path;
        this.configure(this.getRootElement(this.parse(this.m_fileName), true), false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    private String getVar(String name) {
        if ("ORACLE_HOME".equals(name)) {
            this.deprecationWarning(name, "oracle.instance");
            return this.getProperty("oracle.instance");
        }
        if ("OPMN_PROC_TYPE".equals(name)) {
            this.deprecationWarning(name, "oracle.component.type");
            return this.getProperty("oracle.component.type");
        }
        if ("OPMN_PROC_SET".equals(name)) {
            this.deprecationWarning(name, "oracle.component.name");
            return this.getProperty("oracle.component.name");
        }
        if ("OPMN_PROC_INDEX".equals(name)) {
            this.deprecationWarning(name, "oracle.process.index");
            return this.getProperty("oracle.process.index");
        }
        return null;
    }

    private void deprecationWarning(String name, String replacement) {
        if (!this.m_warningIssued.containsKey(name)) {
            Logger.getLogger("oracle.odl.loggingconfiguration").logrb(Level.WARNING, (String)null, (String)null, Messages.class.getName(), "ODL-52041", new Object[]{"%" + name + "%", "${" + replacement + "}", this.m_fileName});
            this.m_warningIssued.put(name, "");
        }
    }

    private void configure(Document document, boolean hasWrapper) throws LoggingConfigurationException {
        try {
            this.configure(this.getRootElement(document, hasWrapper), true);
        }
        catch (LoggingConfigurationException e) {
            this.reset();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(Element root, boolean setLoggingProperties) throws LoggingConfigurationException {
        Properties loggingProperties = new Properties();
        HashMap<String, HandlerState> newHandlers = new HashMap<String, HandlerState>();
        HashMap<String, LoggerState> newLoggers = new HashMap<String, LoggerState>();
        this.readConfiguration(root, loggingProperties, newHandlers, newLoggers);
        if (setLoggingProperties) {
            this.initLoggingProperties(loggingProperties);
        }
        for (HandlerState hs : newHandlers.values()) {
            if (this.m_handlers.containsKey(hs.getName())) {
                hs.updateHandler(this.m_handlers.get(hs.getName()));
                continue;
            }
            hs.initHandler();
        }
        for (LoggerState ls : newLoggers.values()) {
            Logger logger;
            if (!this.m_loggers.containsKey(ls.getName())) {
                ls.initLogger(newHandlers);
                continue;
            }
            LoggerState oldls = this.m_loggers.get(ls.getName());
            Logger logger2 = logger = ODLLogger.getLogger(ls.getName());
            synchronized (logger2) {
                ls.updateLogger(oldls, this.m_handlers, newHandlers);
            }
        }
        for (LoggerState ls : this.m_loggers.values()) {
            if (newLoggers.containsKey(ls.getName())) continue;
            ls.resetLogger(this.m_handlers);
        }
        for (HandlerState hs : this.m_handlers.values()) {
            HandlerState nhs = (HandlerState)newHandlers.get(hs.getName());
            if (nhs != null && nhs.getHandler() == hs.getHandler()) continue;
            hs.closeHandler();
        }
        this.m_handlers = newHandlers;
        this.m_loggers = newLoggers;
    }

    private void readConfiguration(Element root, Properties properties, Map<String, HandlerState> handlers, Map<String, LoggerState> loggers) throws LoggingConfigurationException {
        properties.putAll((Map<?, ?>)this.getLoggingProperties(root));
        handlers.putAll(this.getHandlers(root));
        loggers.putAll(this.getLoggers(root, handlers));
    }

    private Properties getLoggingProperties(Element root) throws LoggingConfigurationException {
        Properties props = new Properties();
        NodeList nl = root.getElementsByTagName("logging_properties");
        if (nl.getLength() == 0) {
            return props;
        }
        Element elem = (Element)nl.item(0);
        nl = elem.getElementsByTagName("property");
        for (int i = 0; i < nl.getLength(); ++i) {
            elem = (Element)nl.item(i);
            String pname = elem.getAttribute("name");
            String pvalue = this.expandProperties(elem.getAttribute("value"));
            props.setProperty(pname, pvalue);
        }
        return props;
    }

    private Map<String, LoggerState> getLoggers(Element root, Map<String, HandlerState> handlers) throws LoggingConfigurationException {
        NodeList nl = root.getElementsByTagName("loggers");
        if (nl.getLength() != 1) {
            throw new LoggingConfigurationException(Msgs.get("ODL-52043", "loggers"));
        }
        HashMap<String, LoggerState> loggers = new HashMap<String, LoggerState>();
        Element loggersElem = (Element)nl.item(0);
        nl = loggersElem.getElementsByTagName("logger");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element el = (Element)nl.item(i);
            String name = el.getAttribute("name");
            Level level = this.getLevelAttribute(el);
            String usePH = el.getAttribute("useParentHandlers");
            String filterClass = el.getAttribute("filter");
            LoggerState ls = new LoggerState(name, level, usePH, filterClass);
            NodeList nl2 = el.getElementsByTagName("handler");
            for (int j = 0; j < nl2.getLength(); ++j) {
                Element handlerElem = (Element)nl2.item(j);
                String handlerName = handlerElem.getAttribute("name");
                if (!handlers.containsKey(handlerName)) {
                    throw new LoggingConfigurationException(Msgs.get("ODL-52044", handlerName));
                }
                ls.addHandler(handlerName);
            }
            loggers.put(ls.getName(), ls);
        }
        return loggers;
    }

    private Map<String, HandlerState> getHandlers(Element root) throws LoggingConfigurationException {
        HashMap<String, HandlerState> handlers = new HashMap<String, HandlerState>();
        NodeList nl = root.getElementsByTagName("log_handlers");
        if (nl.getLength() == 0) {
            return handlers;
        }
        Element elem = (Element)nl.item(0);
        boolean addJvmNumber = "true".equalsIgnoreCase(elem.getAttribute("addJvmNumber"));
        this.m_handlerDefaults = this.getHandlerDefaults(elem);
        nl = elem.getElementsByTagName("log_handler");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            elem = (Element)nl.item(i);
            String name = elem.getAttribute("name");
            String clazz = elem.getAttribute("class");
            Level level = this.getLevelAttribute(elem);
            String errorManagerClass = elem.getAttribute("errorManager");
            String filterClass = elem.getAttribute("filter");
            String formatterClass = elem.getAttribute("formatter");
            String encoding = elem.getAttribute("encoding");
            NodeList nl2 = elem.getElementsByTagName("property");
            Properties properties = new Properties(this.m_handlerDefaults);
            for (int j = 0; j < nl2.getLength(); ++j) {
                n = nl2.item(j);
                Element el2 = (Element)nl2.item(j);
                String pname = el2.getAttribute("name");
                String pvalue = el2.getAttribute("value");
                pvalue = this.resolveProperty(pname, pvalue);
                properties.put(pname, pvalue);
            }
            if (addJvmNumber) {
                properties.put("addJvmNumber", "true");
            }
            HandlerState hs = new HandlerState(name, clazz, level, errorManagerClass, filterClass, formatterClass, encoding, properties);
            handlers.put(name, hs);
        }
        return handlers;
    }

    private Properties getHandlerDefaults(Element logHandlers) throws LoggingConfigurationException {
        Properties props = new Properties();
        NodeList defaultsList = logHandlers.getElementsByTagName("default_properties");
        if (defaultsList.getLength() > 0) {
            Element defaults = (Element)defaultsList.item(0);
            NodeList propertyList = defaults.getElementsByTagName("property");
            for (int i = 0; i < propertyList.getLength(); ++i) {
                Element property = (Element)propertyList.item(i);
                String propertyName = property.getAttribute("name");
                String originalValue = property.getAttribute("value");
                String expandedValue = this.resolveProperty(propertyName, originalValue);
                props.setProperty(propertyName, expandedValue);
            }
        }
        return props;
    }

    private String resolveProperty(String name, String originalValue) throws LoggingConfigurationException {
        String newValue = this.replaceVars(originalValue);
        newValue = this.expandProperties(newValue);
        if ("path".equals(name)) {
            newValue = this.resolveRelativePath(newValue);
        }
        return newValue;
    }

    public Properties getCachedHandlerDefaults() {
        Properties clone = new Properties();
        Enumeration<?> keys = this.m_handlerDefaults.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = this.m_handlerDefaults.getProperty(key);
            clone.setProperty(key, value);
        }
        return clone;
    }

    private void initLoggingProperties(Properties properties) throws LoggingConfigurationException {
        if (properties.size() > 0) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                properties.store(out, null);
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                LogManager.getLogManager().readConfiguration(in);
            }
            catch (IOException e) {
                throw new LoggingConfigurationException(e);
            }
        }
    }

    private static boolean isHandlerFactory(String className) throws LoggingConfigurationException {
        Class factoryClass = LoggingConfigurationImpl.getClass("oracle.core.ojdl.logging.HandlerFactory");
        Class clazz = LoggingConfigurationImpl.getClass(className);
        return factoryClass.isAssignableFrom(clazz);
    }

    private static Handler getHandlerInstance(String className, Properties props) throws LoggingConfigurationException {
        Class factoryClass = LoggingConfigurationImpl.getClass("oracle.core.ojdl.logging.HandlerFactory");
        Class handlerClass = LoggingConfigurationImpl.getClass("java.util.logging.Handler");
        Class clazz = LoggingConfigurationImpl.getClass(className);
        if (factoryClass.isAssignableFrom(clazz)) {
            HandlerFactory factory;
            try {
                factory = (HandlerFactory)clazz.newInstance();
            }
            catch (Throwable t) {
                throw new LoggingConfigurationException(Msgs.get("ODL-52049", className, t.toString()), t);
            }
            try {
                return factory.create(props);
            }
            catch (Throwable t) {
                throw new LoggingConfigurationException(Msgs.get("ODL-52053", className, t.toString()), t);
            }
        }
        if (handlerClass.isAssignableFrom(clazz)) {
            try {
                return (Handler)clazz.newInstance();
            }
            catch (Throwable t) {
                throw new LoggingConfigurationException(Msgs.get("ODL-52049", className, t.toString()), t);
            }
        }
        throw new LoggingConfigurationException(Msgs.get("ODL-52045", className));
    }

    private Level getLevelAttribute(Element el) throws LoggingConfigurationException {
        String levelStr = el.getAttribute("level");
        if (levelStr != null && levelStr.length() > 0) {
            try {
                return ODLLevel.parse(levelStr);
            }
            catch (IllegalArgumentException e1) {
                try {
                    return ODLLevel.parse(levelStr.toUpperCase());
                }
                catch (IllegalArgumentException e2) {
                    throw new LoggingConfigurationException(e1.toString());
                }
            }
        }
        return null;
    }

    private static Class getClass(String className) throws LoggingConfigurationException {
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e1) {
            throw new LoggingConfigurationException(Msgs.get("ODL-52046", className), e1);
        }
        catch (LinkageError e2) {
            throw new LoggingConfigurationException(Msgs.get("ODL-52047", className, e2.toString()), e2);
        }
    }

    private static Object getInstance(String className, Class type) throws LoggingConfigurationException {
        Class cl = LoggingConfigurationImpl.getClass(className);
        if (!type.isAssignableFrom(cl)) {
            throw new LoggingConfigurationException(Msgs.get("ODL-52048", className, type.getName()));
        }
        try {
            return cl.newInstance();
        }
        catch (Throwable t) {
            throw new LoggingConfigurationException(Msgs.get("ODL-52049", className, t.toString()), t);
        }
    }

    private String resolveRelativePath(String path) {
        File f;
        if (this.m_referenceDir != null && !(f = new File(path)).isAbsolute()) {
            return new File(this.m_referenceDir, path).getPath();
        }
        return path;
    }

    private String addJvmNumber(String path) {
        String jvmNum = this.getProperty("oracle.process.index");
        if (jvmNum == null) {
            return path;
        }
        path = path.endsWith(".log") || path.endsWith(".trc") ? path.substring(0, path.length() - 4) + "-jvm" + jvmNum + path.substring(path.length() - 4) : path + "-jvm" + jvmNum;
        return path;
    }

    private String expandProperties(String s) throws LoggingConfigurationException {
        StringBuffer sb = new StringBuffer();
        int pos = 0;
        while ((pos = this.replaceNextVar(s, pos, sb, "${", "}")) > 0) {
        }
        return sb.toString();
    }

    private String replaceVars(String s) throws LoggingConfigurationException {
        StringBuffer sb = new StringBuffer();
        int pos = 0;
        while ((pos = this.replaceNextVar(s, pos, sb, "%", "%")) > 0) {
        }
        return sb.toString();
    }

    private int replaceNextVar(String str, int pos, StringBuffer sb, String varBeg, String varEnd) throws LoggingConfigurationException {
        int p1 = str.indexOf(varBeg, pos);
        if (p1 < 0) {
            sb.append(str.substring(pos));
            return -1;
        }
        int p2 = str.indexOf(varEnd, p1 + varBeg.length());
        if (p2 < 0) {
            sb.append(str.substring(pos));
            return -1;
        }
        sb.append(str.substring(pos, p1));
        String var = str.substring(p1 + varBeg.length(), p2);
        String value = null;
        if ("%".equals(varBeg)) {
            value = this.getVar(var);
        } else if (var.length() > 0) {
            value = this.getProperty(var);
        }
        if (value == null) {
            throw new LoggingConfigurationException(Msgs.get("ODL-52042", varBeg + var + varEnd));
        }
        sb.append(value);
        return p2 + varEnd.length();
    }

    private Element getRootElement(Document document, boolean hasWrapper) throws LoggingConfigurationException {
        if (hasWrapper) {
            Element wrapper_root = document.getDocumentElement();
            NodeList nl = wrapper_root.getElementsByTagName("logging_configuration");
            return (Element)nl.item(0);
        }
        return document.getDocumentElement();
    }

    private Document parse(String filename) throws LoggingConfigurationException {
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            fact.setValidating(true);
            DocumentBuilder parser = fact.newDocumentBuilder();
            parser.setErrorHandler(new SAXErrorHandler());
            return parser.parse(this.getWrapper(filename));
        }
        catch (SAXParseException e1) {
            throw new LoggingConfigurationException(Msgs.get("ODL-52050", filename, e1.getLineNumber(), e1.getColumnNumber(), e1.toString()), e1);
        }
        catch (Exception e2) {
            throw new LoggingConfigurationException(Msgs.get("ODL-52051", filename, e2.toString()), e2);
        }
    }

    private InputSource getWrapper(String filename) throws IOException, MalformedURLException, LoggingConfigurationException {
        String s;
        InputStream in = this.getClass().getResourceAsStream(DTD_PATH);
        if (in == null) {
            throw new LoggingConfigurationException(Msgs.get("ODL-52052", DTD_PATH));
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuffer sb = new StringBuffer(1000);
        sb.append("<!DOCTYPE root [ <!ENTITY file SYSTEM \"");
        sb.append(new File(filename).toURL().toString());
        sb.append("\"> <!ELEMENT root (logging_configuration)>");
        while ((s = reader.readLine()) != null) {
            sb.append(s);
        }
        sb.append("]> <root>&file;</root>");
        return new InputSource(new StringReader(sb.toString()));
    }

    private String getProperty(final String name) {
        if (this.m_env != null && this.m_env.containsKey(name)) {
            return this.m_env.getProperty(name);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name);
            }
        });
    }

    static {
        try {
            QUICKTRACEHANDLERCLASS = Class.forName("oracle.core.ojdl.logging.QuickTraceHandler");
        }
        catch (Throwable t) {
            QUICKTRACEHANDLERCLASS = null;
        }
    }

    private static class HandlerState {
        private String m_name;
        private String m_class;
        private Level m_level;
        private String m_errorManager;
        private String m_filter;
        private String m_formatter;
        private String m_encoding;
        private Properties m_properties;
        private Handler m_instance;
        private Level m_defaultLevel;
        private Formatter m_defaultFormatter;
        private Filter m_defaultFilter;
        private ErrorManager m_defaultErrorManager;
        private String m_defaultEncoding;

        public HandlerState(String name, String handlerClass, Level level, String errorManagerClass, String filterClass, String formatterClass, String encoding, Properties properties) {
            this.m_name = name;
            this.m_class = handlerClass;
            this.m_level = level;
            this.m_errorManager = errorManagerClass;
            this.m_filter = filterClass;
            this.m_formatter = formatterClass;
            this.m_encoding = encoding;
            this.m_properties = properties;
        }

        public String getName() {
            return this.m_name;
        }

        public String getHandlerClass() {
            return this.m_class;
        }

        public Handler getHandler() {
            return this.m_instance;
        }

        public Properties getProperties() {
            return this.m_properties;
        }

        public void initHandler() throws LoggingConfigurationException {
            Handler handler = LoggingConfigurationImpl.getHandlerInstance(this.m_class, this.m_properties);
            this.m_defaultLevel = handler.getLevel();
            this.m_defaultFormatter = handler.getFormatter();
            this.m_defaultFilter = handler.getFilter();
            this.m_defaultErrorManager = handler.getErrorManager();
            this.m_defaultEncoding = handler.getEncoding();
            if (this.m_level != null) {
                handler.setLevel(this.m_level);
            }
            if (this.m_errorManager != null && this.m_errorManager.length() > 0) {
                handler.setErrorManager((ErrorManager)LoggingConfigurationImpl.getInstance(this.m_errorManager, ErrorManager.class));
            }
            if (this.m_filter != null && this.m_filter.length() > 0) {
                handler.setFilter((Filter)LoggingConfigurationImpl.getInstance(this.m_filter, Filter.class));
            }
            if (this.m_formatter != null && this.m_formatter.length() > 0) {
                handler.setFormatter((Formatter)LoggingConfigurationImpl.getInstance(this.m_formatter, Formatter.class));
            }
            if (this.m_encoding != null && this.m_encoding.length() > 0) {
                try {
                    handler.setEncoding(this.m_encoding);
                }
                catch (Exception e) {
                    throw new LoggingConfigurationException(e);
                }
            }
            if (handler instanceof ODLHandler) {
                ODLHandler oh = (ODLHandler)handler;
                oh.setName(this.m_name);
                if (QUICKTRACEHANDLERCLASS != null && QUICKTRACEHANDLERCLASS.isAssignableFrom(handler.getClass())) {
                    QuickTraceHandler qtoh = (QuickTraceHandler)handler;
                    qtoh.createDMSSensors();
                }
            }
            this.m_instance = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateHandler(HandlerState prevState) throws LoggingConfigurationException {
            if (!this.m_class.equals(prevState.m_class) || prevState.m_instance == null || LoggingConfigurationImpl.isHandlerFactory(this.m_class) && !(prevState.m_instance instanceof ODLHandler)) {
                this.initHandler();
                return;
            }
            this.m_instance = prevState.m_instance;
            this.m_defaultLevel = prevState.m_defaultLevel;
            this.m_defaultFormatter = prevState.m_defaultFormatter;
            this.m_defaultFilter = prevState.m_defaultFilter;
            this.m_defaultErrorManager = prevState.m_defaultErrorManager;
            this.m_defaultEncoding = prevState.m_defaultEncoding;
            if (this.m_instance instanceof ODLHandlerBase) {
                Lock wLock = ((ODLHandlerBase)this.m_instance).getReadWriteLock().writeLock();
                wLock.lock();
                try {
                    if (this.m_instance instanceof ODLHandler) {
                        try {
                            if (QUICKTRACEHANDLERCLASS != null && QUICKTRACEHANDLERCLASS.isAssignableFrom(this.m_instance.getClass())) {
                                new QuickTraceHandlerFactory().configure((QuickTraceHandler)this.m_instance, this.m_properties);
                            } else {
                                new ODLHandlerFactory().configure((ODLHandler)this.m_instance, this.m_properties);
                            }
                        }
                        catch (Exception e) {
                            throw new LoggingConfigurationException(Msgs.get("ODL-52053", this.m_class, e.toString()), e);
                        }
                    }
                    this.updateHandlerProperties();
                }
                finally {
                    if (wLock != null) {
                        wLock.unlock();
                    }
                }
            }
            Handler handler = this.m_instance;
            synchronized (handler) {
                this.updateHandlerProperties();
            }
        }

        public void closeHandler() {
            if (this.m_instance != null) {
                try {
                    this.m_instance.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_instance = null;
            }
        }

        private void updateHandlerProperties() throws LoggingConfigurationException {
            if (this.m_level != null) {
                this.m_instance.setLevel(this.m_level);
            } else {
                this.m_instance.setLevel(this.m_defaultLevel);
            }
            if (this.m_errorManager != null && this.m_errorManager.length() > 0) {
                this.m_instance.setErrorManager((ErrorManager)LoggingConfigurationImpl.getInstance(this.m_errorManager, ErrorManager.class));
            } else if (this.m_defaultErrorManager != null) {
                this.m_instance.setErrorManager(this.m_defaultErrorManager);
            }
            if (this.m_filter != null && this.m_filter.length() > 0) {
                this.m_instance.setFilter((Filter)LoggingConfigurationImpl.getInstance(this.m_filter, Filter.class));
            } else {
                this.m_instance.setFilter(this.m_defaultFilter);
            }
            if (this.m_formatter != null && this.m_formatter.length() > 0) {
                this.m_instance.setFormatter((Formatter)LoggingConfigurationImpl.getInstance(this.m_formatter, Formatter.class));
            } else if (this.m_defaultFormatter != null) {
                this.m_instance.setFormatter(this.m_defaultFormatter);
            }
            try {
                if (this.m_encoding != null && this.m_encoding.length() > 0) {
                    this.m_instance.setEncoding(this.m_encoding);
                } else {
                    this.m_instance.setEncoding(this.m_defaultEncoding);
                }
            }
            catch (Exception e) {
                throw new LoggingConfigurationException(e);
            }
        }
    }

    private static class LoggerState {
        private String m_name;
        private Logger m_instance;
        private boolean m_hasLevel = false;
        private Level m_level = null;
        private Level m_savedLevel = null;
        private boolean m_changedLevel = false;
        private boolean m_changedFilter = false;
        private String m_filterClass = null;
        private boolean m_hasUseParentHandlers = false;
        private boolean m_savedUseParentHandlers = false;
        private boolean m_useParentHandlers = false;
        private List<String> m_handlerNames = new ArrayList<String>(0);

        public LoggerState(String name, Level level, String usePH, String filterClass) {
            this.m_name = name;
            if (level != null) {
                this.m_hasLevel = true;
                this.m_level = level;
            }
            if (usePH != null && usePH.length() > 0) {
                this.m_hasUseParentHandlers = true;
                this.m_useParentHandlers = usePH.equalsIgnoreCase("true");
            }
            if (filterClass != null && filterClass.length() > 0) {
                this.m_filterClass = filterClass;
            }
        }

        public String getName() {
            return this.m_name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initLogger(Map<String, HandlerState> handlers) throws LoggingConfigurationException {
            Logger logger;
            Logger logger2 = logger = ODLLogger.getLogger(this.m_name);
            synchronized (logger2) {
                this.m_instance = logger;
                this.m_savedLevel = logger.getLevel();
                if (this.m_hasLevel) {
                    this.m_changedLevel = true;
                    logger.setLevel(this.m_level);
                }
                this.m_savedUseParentHandlers = logger.getUseParentHandlers();
                if (this.m_hasUseParentHandlers) {
                    logger.setUseParentHandlers(this.m_useParentHandlers);
                }
                if (this.m_filterClass != null) {
                    this.m_changedFilter = true;
                    Filter f = (Filter)LoggingConfigurationImpl.getInstance(this.m_filterClass, Filter.class);
                    logger.setFilter(f);
                }
                for (String handlerName : this.m_handlerNames) {
                    HandlerState hs = handlers.get(handlerName);
                    if (hs == null || hs.getHandler() == null) {
                        throw new RuntimeException("Unexpected error: HandlerState or Handler instance is null");
                    }
                    logger.addHandler(hs.getHandler());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetLogger(Map<String, HandlerState> handlers) {
            Logger logger;
            Logger logger2 = logger = ODLLogger.getLogger(this.m_name);
            synchronized (logger2) {
                for (String handlerName : this.m_handlerNames) {
                    HandlerState hs = handlers.get(handlerName);
                    if (hs == null || hs.getHandler() == null) continue;
                    logger.removeHandler(hs.getHandler());
                }
                if (this.m_changedLevel) {
                    logger.setLevel(this.m_savedLevel);
                }
                if (this.m_changedFilter) {
                    logger.setFilter(null);
                }
                logger.setUseParentHandlers(this.m_savedUseParentHandlers);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateLogger(LoggerState oldState, Map<String, HandlerState> oldHandlers, Map<String, HandlerState> newHandlers) throws LoggingConfigurationException {
            Logger logger;
            ArrayList<String> handlersToAdd = new ArrayList<String>();
            ArrayList<String> handlersToRemove = new ArrayList<String>();
            for (String name : oldState.m_handlerNames) {
                if (this.m_handlerNames.contains(name)) continue;
                handlersToRemove.add(name);
            }
            for (String name : this.m_handlerNames) {
                Handler newHandler;
                if (!oldState.m_handlerNames.contains(name)) {
                    handlersToAdd.add(name);
                    continue;
                }
                Handler oldHandler = oldHandlers.get(name).getHandler();
                if (oldHandler == (newHandler = newHandlers.get(name).getHandler())) continue;
                handlersToRemove.add(name);
                handlersToAdd.add(name);
            }
            Logger logger2 = logger = ODLLogger.getLogger(this.m_name);
            synchronized (logger2) {
                HandlerState hs;
                this.m_instance = logger;
                for (String handlerName : handlersToRemove) {
                    hs = oldHandlers.get(handlerName);
                    if (hs == null || hs.getHandler() == null) continue;
                    logger.removeHandler(hs.getHandler());
                }
                this.m_savedLevel = oldState.m_savedLevel;
                this.m_changedLevel = oldState.m_changedLevel;
                if (this.m_hasLevel) {
                    this.m_changedLevel = true;
                    logger.setLevel(this.m_level);
                }
                this.m_savedUseParentHandlers = oldState.m_savedUseParentHandlers;
                if (this.m_hasUseParentHandlers) {
                    logger.setUseParentHandlers(this.m_useParentHandlers);
                }
                this.m_changedFilter = oldState.m_changedFilter;
                if (this.m_filterClass != null) {
                    this.m_changedFilter = true;
                    Filter f = (Filter)LoggingConfigurationImpl.getInstance(this.m_filterClass, Filter.class);
                    logger.setFilter(f);
                }
                for (String handlerName : handlersToAdd) {
                    hs = newHandlers.get(handlerName);
                    if (hs == null || hs.getHandler() == null) {
                        throw new RuntimeException("Unexpected error: HandlerState or Handler instance is null");
                    }
                    logger.addHandler(hs.getHandler());
                }
            }
        }

        public void addHandler(String name) {
            this.m_handlerNames.add(name);
        }
    }
}

