/*
 * Decompiled with CFR 0.152.
 */
package ice.debug;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDump {
    private static final int BUFFERSIZE = 4096;
    private String fileName = null;
    private FileOutputStream fos = null;

    public static IOException dumpStream(InputStream is, String fileName) {
        return FileDump.doDump(null, 0, 0, is, fileName);
    }

    public static IOException dumpStream(byte[] data, int dataOffset, int dataLength, InputStream is, String fileName) {
        return FileDump.doDump(data, dataOffset, dataLength, is, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IOException doDump(byte[] data, int dataOffset, int dataLength, InputStream is, String fileName) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            try {
                if (data != null) {
                    fos.write(data, dataOffset, dataLength);
                }
                if (is != null) {
                    FileDump.writeSteam(is, fos);
                }
                fos.flush();
            }
            finally {
                fos.close();
            }
            return null;
        }
        catch (IOException ex) {
            return ex;
        }
    }

    private static void writeSteam(InputStream is, OutputStream os) throws IOException {
        int readBytes;
        byte[] buffer = new byte[4096];
        while ((readBytes = is.read(buffer, 0, buffer.length)) >= 0) {
            os.write(buffer, 0, readBytes);
        }
    }

    public FileDump(String fileNameIn) throws IOException {
        this.fileName = fileNameIn;
        this.fos = new FileOutputStream(this.fileName);
    }

    public void write(byte[] buffer, int index, int length) throws IOException {
        this.fos.write(buffer, index, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.fos.flush();
        }
        finally {
            this.fos.close();
        }
    }
}

