/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ProtocolException;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ocvs.OCVSConnection;
import oracle.ocvs.OCVSRequest;
import oracle.ocvs.OCVSRoot;
import oracle.ocvs.OCVSServerException;

public class OCVSPServerConnection
extends OCVSConnection {
    private final String _hostName;
    private int _port = 2401;
    private Socket _socket;
    private int _soTimeout = 60000;
    private String _proxy;
    private int _proxyPort = 3128;

    public OCVSPServerConnection(String hostName) {
        this._hostName = hostName;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public void setSoTimeout(int soTimeout) {
        this._soTimeout = soTimeout;
    }

    public void setProxy(String proxy) {
        this._proxy = proxy;
    }

    public void setProxyPort(int proxyPort) {
        this._proxyPort = proxyPort;
    }

    public boolean authenticateUser(OCVSRoot root, char[] password, boolean verifyOnly) throws IOException, OCVSServerException {
        if (this._socket == null) {
            throw new IllegalStateException();
        }
        this.writeLine(verifyOnly ? "BEGIN VERIFICATION REQUEST" : "BEGIN AUTH REQUEST");
        this.writeLine(root.getRepository());
        this.writeLine(root.getUserName());
        this.writeLine(password);
        this.writeLine(verifyOnly ? "END VERIFICATION REQUEST" : "END AUTH REQUEST");
        String response = this.readLine();
        if (response != null && response.equals("I LOVE YOU")) {
            return true;
        }
        if (response != null && response.equals("I HATE YOU")) {
            return false;
        }
        if (response == null) {
            throw new EOFException();
        }
        if (response.startsWith("E ")) {
            throw new OCVSServerException(response.substring(2));
        }
        if (response.startsWith("error ")) {
            throw OCVSRequest.createErrorResponseException(response.substring(6));
        }
        if (response.indexOf(" aborted]") >= 0) {
            throw new OCVSServerException(response);
        }
        throw new ProtocolException(MessageFormat.format("unrecognized auth response from {0}: {1}", this._hostName, response));
    }

    @Override
    protected void openImpl() throws IOException {
        if (this._socket != null) {
            throw new IllegalStateException();
        }
        this._socket = this.createSocket();
        this._socket.setSoTimeout(this._soTimeout);
    }

    @Override
    protected void closeImpl() throws IOException {
        if (this._socket == null) {
            throw new IllegalStateException();
        }
        this._socket.close();
        this._socket = null;
    }

    @Override
    protected InputStream getInputStreamImpl() throws IOException {
        return this._socket.getInputStream();
    }

    @Override
    protected OutputStream getOutputStreamImpl() throws IOException {
        return this._socket.getOutputStream();
    }

    private Socket createSocket() throws IOException {
        if (this._proxy == null) {
            return new Socket(this._hostName, this._port);
        }
        Socket socket = new Socket(this._proxy, this._proxyPort);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
        bw.write(MessageFormat.format("CONNECT {0}:{1} HTTP/1.0\n\n", this._hostName, Integer.toString(this._port)));
        bw.flush();
        String proxyResponse = this.readLine(socket.getInputStream());
        Pattern pattern = Pattern.compile("[^ ]* (\\d+).*", 32);
        Matcher matcher = pattern.matcher(proxyResponse);
        try {
            if (!matcher.matches() || Integer.parseInt(matcher.group(1)) / 100 != 2) {
                socket.close();
                throw new ProtocolException(MessageFormat.format("Proxy server {0} does not support HTTP tunnelling", this._proxy));
            }
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        InputStream in = socket.getInputStream();
        while (in.available() > 0) {
            in.read();
        }
        return socket;
    }
}

