/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.KeyPair;
import java.io.File;
import java.util.Map;
import oracle.ocvs.OCVSClientException;
import oracle.ocvs.OCVSCommand;
import oracle.ocvs.OCVSProcessIO;

public class OCVSKeyGen
extends OCVSCommand {
    public OCVSKeyGen() {
        super(null);
    }

    @Override
    public String getCommandId() {
        return "keygen";
    }

    @Override
    public int executeCommand(OCVSProcessIO io, File dir, Map options, String[] arguments) throws Exception {
        char[] passphrase;
        if (arguments.length < 3) {
            OCVSKeyGen.throwUsageException();
        }
        int type = -1;
        if (arguments[0].equals("rsa")) {
            type = 2;
        }
        if (arguments[0].equals("dsa")) {
            type = 1;
        }
        if (type < 0) {
            OCVSKeyGen.throwUsageException();
        }
        if ((passphrase = io.getPrompter().promptSsh2Passphrase("Enter passphrase (empty for no passphrase)")) == null) {
            return -1;
        }
        JSch jsch = new JSch();
        File keyFile = new File(arguments[1]);
        if (!keyFile.isAbsolute()) {
            keyFile = new File(dir, keyFile.getPath());
        }
        KeyPair keyPair = KeyPair.genKeyPair((JSch)jsch, (int)type);
        char[] s = passphrase;
        keyPair.setPassphrase(new String(s));
        keyPair.writePrivateKey(keyFile.getPath());
        keyPair.writePublicKey(keyFile.getPath() + ".pub", arguments[2]);
        io._out.println("Finger print: " + keyPair.getFingerPrint());
        keyPair.dispose();
        return 0;
    }

    private static final void throwUsageException() throws OCVSClientException {
        throw new OCVSClientException("arguments - rsa|dsa output_keyfile comment");
    }
}

