/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import oracle.ocvs.OCVSConnection;

public class OCVSForkConnection
extends OCVSConnection {
    static final String DEFAULT_SERVER = "cvs";
    static final String SERVER_COMMAND = "server";
    private Process _process;
    private InputStream _errorStream;
    private String _server = "cvs";

    public void setServer(String server) {
        this._server = server;
    }

    @Override
    protected void openImpl() throws IOException {
        if (this._process != null) {
            throw new IllegalStateException();
        }
        this._process = Runtime.getRuntime().exec(this.createServerCommandArray());
    }

    @Override
    protected void closeImpl() throws IOException {
        if (this._process == null) {
            throw new IllegalStateException();
        }
        this._process.destroy();
        this._process = null;
    }

    @Override
    protected InputStream getInputStreamImpl() {
        return this._process.getInputStream();
    }

    @Override
    protected OutputStream getOutputStreamImpl() {
        return this._process.getOutputStream();
    }

    @Override
    public String readLine() throws IOException {
        String line;
        InputStream inputStream = this.getInputStream();
        InputStream errorStream = this.getErrorStream();
        if (inputStream.available() < 0 && errorStream.available() < 0) {
            return null;
        }
        try {
            while (inputStream.available() <= 0 && errorStream.available() <= 0) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException ie) {
            throw new InterruptedIOException(ie.getMessage());
        }
        if (errorStream.available() > 0) {
            line = this.readLine(errorStream);
            if (line.indexOf("Unknown command: `server'") >= 0) {
                throw new IOException("CVS executable doesn't have server support");
            }
        } else {
            line = super.readLine();
        }
        return line != null ? line : this.readLine(errorStream);
    }

    protected String[] createServerCommandArray() {
        return new String[]{this._server, SERVER_COMMAND};
    }

    protected InputStream getErrorStreamImpl() throws IOException {
        return this._process.getErrorStream();
    }

    private InputStream getErrorStream() throws IOException {
        if (this._errorStream == null) {
            this._errorStream = this.getErrorStreamImpl();
        }
        return this._errorStream;
    }
}

