/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import oracle.ocvs.OCVSRuntimeUtil;

public class OCVSFileUtil {
    public static final boolean IS_LF_PLATFORM = System.getProperty("line.separator").equals("\n");
    public static final boolean IS_CRLF_PLATFORM = System.getProperty("line.separator").equals("\r\n");

    private OCVSFileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[] readFileLines(File file) throws IOException {
        String[] stringArray;
        if (!file.exists()) {
            return null;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            ArrayList<String> c = new ArrayList<String>();
            String line = null;
            while ((line = br.readLine()) != null) {
                c.add(line);
            }
            stringArray = c.toArray(new String[0]);
        }
        catch (Throwable throwable) {
            OCVSFileUtil.closeReader(br);
            throw throwable;
        }
        OCVSFileUtil.closeReader(br);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeFileLines(File file, String[] lines) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
            for (int i = 0; i < lines.length; ++i) {
                bw.write(lines[i]);
                bw.newLine();
            }
        }
    }

    public static final byte[] readFileBytes(File file) throws IOException {
        byte[] bytes = new byte[(int)Math.min(file.length(), Integer.MAX_VALUE)];
        try (FileInputStream fis = null;){
            fis = new FileInputStream(file);
            fis.read(bytes);
        }
        return bytes;
    }

    public static final File createTempFile(String suffix) throws IOException {
        return File.createTempFile("ocvs", suffix);
    }

    public static final boolean isFileSystemCaseSensitive() {
        return !new File("A").equals(new File("a"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final File createPlatformEOLFile(File inputFile) throws IOException {
        File file = OCVSFileUtil.createTempFile(null);
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(inputFile));
            bw = new BufferedWriter(new FileWriter(file));
            while ((line = br.readLine()) != null) {
                bw.write(line);
                bw.newLine();
            }
        }
        catch (Throwable throwable) {
            OCVSFileUtil.closeReader(br);
            OCVSFileUtil.closeWriter(bw);
            throw throwable;
        }
        OCVSFileUtil.closeReader(br);
        OCVSFileUtil.closeWriter(bw);
        return file;
    }

    private static void closeWriter(BufferedWriter bw) {
        if (bw != null) {
            try {
                bw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void closeReader(BufferedReader br) {
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final File createServerEOLFile(File inputFile) throws IOException {
        File file = OCVSFileUtil.createTempFile(null);
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(inputFile));
            bw = new BufferedWriter(new FileWriter(file));
            while ((line = br.readLine()) != null) {
                bw.write(line);
                bw.write(10);
            }
        }
        catch (Throwable throwable) {
            OCVSFileUtil.closeReader(br);
            OCVSFileUtil.closeWriter(bw);
            throw throwable;
        }
        OCVSFileUtil.closeReader(br);
        OCVSFileUtil.closeWriter(bw);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean renameTo(File sourceFile, File destinationFile) {
        if (sourceFile.renameTo(destinationFile)) {
            return true;
        }
        if (OCVSRuntimeUtil.isWindows()) {
            return false;
        }
        if (destinationFile.exists()) {
            return false;
        }
        FileChannel sourceChannel = null;
        AbstractInterruptibleChannel destinationChannel = null;
        try {
            sourceChannel = new FileInputStream(sourceFile).getChannel();
            destinationChannel = new FileOutputStream(destinationFile).getChannel();
            sourceChannel.transferTo(0L, sourceChannel.size(), (WritableByteChannel)((Object)destinationChannel));
            boolean bl = sourceFile.delete();
            return bl;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (sourceChannel != null) {
                try {
                    sourceChannel.close();
                }
                catch (IOException iOException) {}
            }
            if (destinationChannel != null) {
                try {
                    destinationChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

