/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OCVSEntry {
    public static final int T_FILE = 0;
    public static final int T_SUBDIR = 1;
    private final String _entrySpec;
    private final int _type;
    private final String _user;
    private String _version = "";
    private String _timestamp = "";
    private String _options = "";
    private String _tag = null;
    private String _date = null;
    private String _conflict = null;

    public OCVSEntry(OCVSEntry entry) {
        this(entry._entrySpec, entry._type, entry._user);
        this._version = entry._version;
        this._timestamp = entry._timestamp;
        this._options = entry._options;
        this._tag = entry._tag;
        this._date = entry._date;
        this._conflict = entry._conflict;
    }

    public OCVSEntry(String entrySpec, int type, String user) {
        this._entrySpec = entrySpec;
        this._type = type;
        this._user = user;
    }

    public String getEntrySpec() {
        return this._entrySpec;
    }

    public int getType() {
        return this._type;
    }

    public String getUser() {
        return this._user;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public String getVersion() {
        return this._version;
    }

    public void setTimestamp(String timestamp) {
        this._timestamp = timestamp;
    }

    public String getTimestamp() {
        return this._timestamp;
    }

    public void setOptions(String options) {
        this._options = options;
    }

    public String getOptions() {
        return this._options;
    }

    public void setTag(String tag) {
        this._tag = tag;
    }

    public String getTag() {
        return this._tag;
    }

    public void setDate(String date) {
        this._date = date;
    }

    public String getDate() {
        return this._date;
    }

    public void setConflict(String conflict) {
        this._conflict = conflict;
    }

    public String getConflict() {
        return this._conflict;
    }

    public String toString() {
        StringBuilder entryBuffer = new StringBuilder();
        if (this._type == 1) {
            entryBuffer.append('D');
        }
        entryBuffer.append('/');
        entryBuffer.append(this._user);
        entryBuffer.append('/');
        entryBuffer.append(this._version);
        entryBuffer.append('/');
        entryBuffer.append(this._timestamp);
        if (this._conflict != null) {
            entryBuffer.append('+');
            entryBuffer.append(this._conflict);
        }
        entryBuffer.append('/');
        entryBuffer.append(this._options);
        entryBuffer.append('/');
        if (this._tag != null) {
            entryBuffer.append('T');
            entryBuffer.append(this._tag);
        }
        if (this._tag == null && this._date != null) {
            entryBuffer.append('D');
            entryBuffer.append(this._date);
        }
        return entryBuffer.toString();
    }

    public boolean isBinary() {
        return this._options.indexOf("-kb") >= 0;
    }

    public static final OCVSEntry parseEntrySpec(String entrySpec) throws ParseException {
        if (entrySpec.equals("D")) {
            return new OCVSEntry(entrySpec, 1, "");
        }
        Pattern pattern = Pattern.compile("(D)?/(.+)/(.*)/([^+/]*)(\\+.+)?/(.*)/((T.+)|(D.+))?", 32);
        Matcher matcher = pattern.matcher(entrySpec);
        if (!matcher.find()) {
            throw new ParseException(MessageFormat.format("bad entries line `{0}'' from server", entrySpec), 0);
        }
        int type = matcher.group(1) == null ? 0 : 1;
        OCVSEntry entry = new OCVSEntry(entrySpec, type, matcher.group(2));
        entry.setVersion(matcher.group(3));
        entry.setTimestamp(matcher.group(4));
        entry.setOptions(matcher.group(6));
        if (matcher.group(8) != null) {
            entry.setTag(matcher.group(8).substring(1));
        }
        if (matcher.group(9) != null) {
            entry.setDate(matcher.group(9).substring(1));
        }
        if (matcher.group(5) != null) {
            entry.setConflict(matcher.group(5).substring(1));
        }
        return entry;
    }
}

