/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.Tokenizer;

public class PlSqlTokenizer {
    private static final Collection<String> s_twoCharOperators = Collections.unmodifiableCollection(Arrays.asList(":=", "=>", "||", "**", "<<", ">>", "..", "<>", "!=", "~=", "^=", "<=", ">="));
    private static final String DOUBLE_SLASH = "//";
    private Tokenizer m_tokenizer;

    PlSqlTokenizer(String source, String ... userTokens) {
        if (source != null) {
            Tokenizer.Config config = new Tokenizer.Config();
            config.setSource(source);
            config.setFactory(new DefaultTokenFactory());
            config.addTokens(Token.Type.PUNCTUATION, PlSqlTokenizer.getTwoCharOperators());
            if (userTokens != null && userTokens.length > 0) {
                config.addTokens(Token.Type.USER_TOKEN, Arrays.asList(userTokens));
            }
            this.m_tokenizer = new Tokenizer(config);
        }
    }

    @Deprecated
    public int getLineNumber(int offset) {
        return -1;
    }

    final PlSqlToken getStartMarker() {
        return (PlSqlToken)(this.m_tokenizer == null ? null : this.m_tokenizer.getStartMarker());
    }

    final PlSqlToken getEndMarker() {
        return (PlSqlToken)(this.m_tokenizer == null ? null : this.m_tokenizer.getEndMarker());
    }

    final PlSqlToken getFirst() {
        return (PlSqlToken)(this.m_tokenizer == null ? null : this.m_tokenizer.getFirst());
    }

    public static PlSqlToken tokenize(String source, String ... userTokens) {
        return PlSqlTokenizer.tokenize(source, null, null, userTokens);
    }

    public static PlSqlToken tokenize(String source, Tokenizer.TokenFactory tokenFactory) {
        return PlSqlTokenizer.tokenize(source, null, tokenFactory, new String[0]);
    }

    public static PlSqlToken tokenize(Reader reader) {
        return PlSqlTokenizer.tokenize(reader, null, null, new String[0]);
    }

    public static PlSqlToken tokenize(Reader reader, Integer maxCodeTokens) {
        return PlSqlTokenizer.tokenize(reader, maxCodeTokens, null, new String[0]);
    }

    public static Collection<String> getTwoCharOperators() {
        return s_twoCharOperators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlSqlToken tokenize(String source, Integer maxCodeTokens, Tokenizer.TokenFactory tokenFactory, String ... userTokens) {
        PlSqlToken retval = null;
        if (source != null) {
            try (StringReader reader = new StringReader(source);){
                retval = PlSqlTokenizer.tokenize(reader, maxCodeTokens, tokenFactory, userTokens);
            }
        }
        return retval;
    }

    public static PlSqlToken tokenize(Reader reader, Integer maxCodeTokens, Tokenizer.TokenFactory tokenFactory, String ... userTokens) {
        PlSqlToken retval = null;
        if (reader != null) {
            Tokenizer.Config config = new Tokenizer.Config();
            config.setReader(reader);
            config.setMaxTokens(maxCodeTokens);
            if (tokenFactory != null) {
                config.setFactory(tokenFactory);
            } else {
                config.setFactory(new DefaultTokenFactory());
            }
            config.addTokens(Token.Type.PUNCTUATION, PlSqlTokenizer.getTwoCharOperators());
            if (userTokens != null && userTokens.length > 0) {
                config.addTokens(Token.Type.USER_TOKEN, Arrays.asList(userTokens));
            }
            Tokenizer tz = new Tokenizer(config);
            retval = (PlSqlToken)tz.getFirst();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static PlSqlToken tokenizeJava(String source) {
        PlSqlToken retval = null;
        if (source != null) {
            try (StringReader reader = new StringReader(source);){
                Tokenizer.Config config = new Tokenizer.Config();
                config.setReader(reader);
                config.setSingleLineCommentStart(DOUBLE_SLASH);
                config.setFactory(new DefaultTokenFactory());
                Tokenizer tz = new Tokenizer(config);
                retval = (PlSqlToken)tz.getStartMarker().getNextToken();
            }
        }
        return retval;
    }

    private static class DefaultTokenFactory
    implements Tokenizer.TokenFactory {
        private DefaultTokenFactory() {
        }

        @Override
        public Token createToken(Token.Type type, int start, Token prev) {
            return new PlSqlToken(type, start, (PlSqlToken)prev);
        }

        @Override
        public void setEnd(Token tk, int end) {
            tk.setEnd(end);
        }
    }
}

