/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.css;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.language.css.CSSRuleRenderer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.css.CSSRuleSetLexer;

public class CSSRuleSetRenderer
extends CSSRuleRenderer {
    public CSSRuleSetRenderer(TextBuffer textBuffer) {
        super(textBuffer);
    }

    @Override
    protected Lexer createLexer() {
        return new CSSRuleSetLexer();
    }

    @Override
    protected void renderToken(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        switch (token) {
            case 299: {
                int newClipStart = Math.max(tokenStart, clipStart);
                int newClipEnd = Math.min(tokenEnd, clipEnd);
                this.renderCSSDeclarations(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            default: {
                super.renderToken(fragmentsList, token, tokenStart, tokenEnd, clipStart, clipEnd);
            }
        }
    }

    @Override
    protected String mapTokenToStyleName(int token) {
        switch (token) {
            case 18: {
                return "css-comment-style";
            }
            case 202: {
                return "css-selector-style";
            }
        }
        return this.getDefaultStyleName();
    }
}

