/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.css;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.AbstractBraceProvider;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.css.CSSDeclarationsLexer;
import oracle.javatools.parser.css.CSSLexer;
import oracle.javatools.parser.generic.BraceHelper;

public class CSSBraceProvider
extends AbstractBraceProvider {
    private TextBuffer _textBuffer;
    private CSSLexer _lexer;
    private static final String[][] _BRACES = new String[][]{{"{", "}"}, {"[", "]"}, {"(", ")"}};
    private static final String _BRACE_CHARACTERS = "{}[]()";

    public CSSBraceProvider(LanguageSupport support) {
        this._textBuffer = support.getDocument().getTextBuffer();
        this._lexer = new CSSDeclarationsLexer();
        this._lexer.setTextBuffer((ReadTextBuffer)this._textBuffer);
        this._lexer.setPosition(0);
    }

    @Override
    protected TextBuffer getTextBuffer() {
        return this._textBuffer;
    }

    @Override
    protected BraceHelper getBraceHelper() {
        return new BraceHelper(_BRACES);
    }

    @Override
    protected Lexer getLexer() {
        return this._lexer;
    }

    @Override
    protected String getBraceCharacters() {
        return _BRACE_CHARACTERS;
    }

    @Override
    protected boolean isBraceToken(int token) {
        return token == 1 || token == 2 || token == 11 || token == 12 || token == 14 || token == 15 || token == 52 || token == 206;
    }

    @Override
    protected void fillBraceArray() throws InterruptedException {
        Lexer lexer = this.getLexer();
        lexer.setTextBuffer((ReadTextBuffer)this._textBuffer);
        lexer.setPosition(0);
        LexerToken lexerToken = lexer.createLexerToken();
        BraceHelper braceHelper = this.getBraceHelper();
        int bufferEnd = this._textBuffer.getLength();
        while (true) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            int token = lexer.lex(lexerToken);
            if (lexerToken.getStartOffset() >= bufferEnd || token == 0) break;
            if (!this.isBraceToken(token)) continue;
            int startOffset = lexerToken.getStartOffset();
            int endOffset = lexerToken.getEndOffset();
            if (token == 52 || token == 206) {
                int end;
                String text = this.getTextBuffer().getString(startOffset, endOffset - startOffset);
                int start = text.indexOf(40);
                if (start != -1) {
                    this._addToBraceArray(braceHelper, startOffset + start, startOffset + start + 1);
                }
                if ((end = text.indexOf(41)) == -1) continue;
                this._addToBraceArray(braceHelper, startOffset + end, startOffset + end + 1);
                continue;
            }
            this._addToBraceArray(braceHelper, startOffset, endOffset);
        }
    }

    private void _addToBraceArray(BraceHelper braceHelper, int startOffset, int endOffset) {
        int arrayIndex;
        int braceIndex = braceHelper.getBraceIndex((ReadTextBuffer)this._textBuffer, startOffset, endOffset);
        if ((arrayIndex = this.braceCount++ * 3) + 2 >= this.braceArray.length) {
            this.braceArray = this.expandBraceArray(this.braceArray);
        }
        this.braceArray[arrayIndex++] = startOffset;
        this.braceArray[arrayIndex++] = endOffset;
        this.braceArray[arrayIndex] = braceIndex;
    }
}

