/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.net.URL;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.Replacements;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.IdentifiersDb;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.refactor.Messages;
import oracle.dbtools.raptor.refactor.UndoableRefactoring;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Service;
import oracle.ide.Context;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public class Inliner
extends UndoableRefactoring {
    static final String path = "/oracle/dbtools/raptor/refactor/";
    static Parsed prg = null;
    static IProgram program = null;

    public Inliner(Context context) {
        super(context);
    }

    @Override
    protected Replacements runProgram(int n) {
        return this.runProgram(n, this.text, this.src, this.p, true);
    }

    Replacements runProgram(int n, String string, List<LexerToken> list, BasicEditorPane basicEditorPane, boolean bl) {
        long l = System.currentTimeMillis();
        try {
            Object object;
            TextBuffer textBuffer2;
            Comparable<PlSqlNode> comparable;
            int n2;
            int n3;
            ParseNode parseNode;
            int n4;
            ParseNode parseNode2;
            if (prg == null) {
                prg = new Parsed(Service.readFile(Inliner.class, (String)"/oracle/dbtools/raptor/refactor/inline.prg"), Program.getArboriParser(), "program");
            }
            Parsed parsed = new Parsed(string, list, (Earley)SqlEarley.getInstance(), "sql_statement");
            if (program == null) {
                program = new IProgram();
                Program.debug = false;
                parseNode2 = prg.getRoot();
                program.program(parseNode2, prg.getSrc(), prg.getInput());
            }
            Inliner.program.offset = LexerToken.scanner2parserOffset(list, (int)n);
            parseNode2 = list.get(Inliner.program.offset);
            if (basicEditorPane != null) {
                int n5;
                int n6 = basicEditorPane.getLineFromOffset(n);
                if (n6 < (n5 = basicEditorPane.getLineFromOffset(parseNode2.begin))) {
                    --Inliner.program.offset;
                }
                parseNode2 = list.get(Inliner.program.offset);
                n5 = basicEditorPane.getLineFromOffset(parseNode2.begin);
                if (n6 < n5) {
                    --Inliner.program.offset;
                }
            }
            String string2 = parseNode2.content;
            Map map = null;
            try {
                map = program.eval(parsed);
            }
            catch (AssertionError assertionError) {
                if (((Throwable)((Object)assertionError)).getMessage().contains("syntactically invalid")) {
                    String string3 = Messages.getString("SyntaxErrorMsg");
                    SyntaxError syntaxError = parsed.getSyntaxError();
                    if (syntaxError != null) {
                        string3 = syntaxError.getDetailedMessage();
                    }
                    MessageDialog.information(null, (Object)string3, (String)Messages.getString("ErrorTitle"), null);
                }
                System.out.println("Refactoring aborted due to " + ((Throwable)((Object)assertionError)).getMessage());
                return null;
            }
            ParseNode parseNode3 = null;
            ParseNode parseNode4 = null;
            boolean bl2 = false;
            MaterializedPredicate materializedPredicate = (MaterializedPredicate)map.get("\"prm val\"");
            MaterializedPredicate materializedPredicate2 = (MaterializedPredicate)map.get("\"prm decl\"");
            MaterializedPredicate materializedPredicate3 = (MaterializedPredicate)map.get("\"all calls\"");
            if (materializedPredicate3.cardinality() == 0) {
                int n7 = 0;
                MaterializedPredicate materializedPredicate4 = (MaterializedPredicate)map.get("\"proc@offset\"");
                if (n7 < materializedPredicate4.cardinality()) {
                    ParseNode parseNode5 = materializedPredicate4.getAttribute(n7, "id");
                    string2 = parseNode5.content(list);
                }
                String string4 = Messages.getString("NoCalls") + " " + string2;
                MessageDialog.information(null, (Object)string4, (String)Messages.getString("ErrorTitle"), null);
                return null;
            }
            int n8 = materializedPredicate2.cardinality();
            TreeMap treeMap = new TreeMap();
            MaterializedPredicate materializedPredicate5 = (MaterializedPredicate)map.get("\"all calls+fml\"");
            for (n4 = 0; n4 < materializedPredicate3.cardinality(); ++n4) {
                ParseNode parseNode6;
                parseNode = materializedPredicate3.getAttribute(n4, "call");
                string2 = parseNode.content(list);
                parseNode3 = materializedPredicate3.getAttribute(n4, "body");
                bl2 = materializedPredicate3.getAttribute(n4, "f").contains(SqlEarley.getInstance().getSymbol("'FUNCTION'"));
                if (bl2) {
                    MessageDialog.information(null, (Object)Messages.getString("CantInlineFunction"), (String)Messages.getString("ErrorTitle"), null);
                    return null;
                }
                if (parseNode3.from <= parseNode.from && parseNode.to <= parseNode3.to) {
                    MessageDialog.information(null, (Object)Messages.getString("RecursiveInvocationMsg"), (String)Messages.getString("ErrorTitle"), null);
                    return null;
                }
                if (parseNode.from <= Inliner.program.offset && Inliner.program.offset <= parseNode.to) {
                    parseNode4 = parseNode;
                }
                TreeMap<ParseNode, ParseNode> treeMap2 = new TreeMap<ParseNode, ParseNode>();
                ParseNode parseNode7 = null;
                for (n3 = 0; n3 < materializedPredicate5.cardinality(); ++n3) {
                    parseNode6 = materializedPredicate5.getAttribute(n3, "call");
                    if (parseNode.from != parseNode6.from || parseNode.to != parseNode6.to) continue;
                    parseNode7 = materializedPredicate5.getAttribute(n3, "paren_expr_list");
                    break;
                }
                if (parseNode7 != null) {
                    for (n3 = 0; n3 < materializedPredicate.cardinality(); ++n3) {
                        parseNode6 = materializedPredicate.getAttribute(n3, "arg");
                        if (parseNode7.from > parseNode6.from || parseNode6.to > parseNode7.to) continue;
                        ParseNode parseNode8 = materializedPredicate2.getAttribute(n3 % n8, "prm_spec");
                        treeMap2.put(parseNode6, parseNode8);
                    }
                }
                treeMap.put(parseNode, treeMap2);
            }
            System.out.println("Inline time = " + (System.currentTimeMillis() - l));
            n4 = treeMap.size();
            if (bl && !MessageDialog.confirm(null, (Object)MessageFormat.format(Messages.getString("Replace"), n4, list.get((int)(parseNode3.from + 1)).content), (String)Messages.getString("InlineProcedure"), null)) {
                return null;
            }
            parseNode = new Replacements(string);
            int n9 = list.get((int)parseNode3.from).begin;
            int n10 = string.substring(0, n9).lastIndexOf(10) + 1;
            if (n10 < 0) {
                n10 = 0;
            }
            if ((n2 = (n3 = list.get((int)(parseNode3.to - 1)).end) + string.substring(n3).indexOf(10) + 1) < 0) {
                n2 = n3;
            }
            if (this.notPublic(string2)) {
                parseNode.put(n10, n2, "");
            } else if (this.notUsedOutsideBody(string2)) {
                boolean bl3 = false;
                comparable = this.getPkgNode();
                if (comparable != null) {
                    for (Member iterator2 : ((PlSqlNode)comparable).parseMembers()) {
                        if (!iterator2.name.equals(string2)) continue;
                        textBuffer2 = comparable.tryAcquireTextBuffer();
                        try {
                            textBuffer2.beginEdit();
                            object = ((PlSqlNode)comparable).getParser().src;
                            textBuffer2.remove(object.get((int)iterator2.from).begin, object.get((int)iterator2.to).begin - ((LexerToken)object.get((int)iterator2.from)).begin);
                            textBuffer2.endEdit();
                            bl3 = true;
                        }
                        catch (Exception exception) {
                            System.err.println("Failed to delete member from package declaration");
                        }
                        break;
                    }
                }
                if (bl3) {
                    parseNode.put(n10, n2, "");
                }
            }
            int n11 = n9 - n10;
            comparable = new StringBuffer();
            for (int i = 0; i < n11; ++i) {
                ((StringBuffer)comparable).append(' ');
            }
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = parseNode3.children().iterator();
            while (iterator.hasNext() && !(textBuffer2 = (ParseNode)iterator.next()).contains(IdentifiersDb.instance.decl_id)) {
                if (textBuffer2.contains(IdentifiersDb.instance.subprg_spec) || textBuffer2.contains(SqlEarley.getInstance().getSymbol("'IS'")) || textBuffer2.contains(SqlEarley.getInstance().getSymbol("'AS'"))) continue;
                if (stringBuilder.length() == 0) {
                    stringBuilder.append(Inliner.padFromNL2Pos(list.get((int)textBuffer2.from).begin, string));
                }
                stringBuilder.append(string.substring(list.get((int)textBuffer2.from).begin, list.get((int)textBuffer2.to).begin));
            }
            stringBuilder.append(";");
            for (TextBuffer textBuffer2 : treeMap.keySet()) {
                int n5;
                object = (Map)treeMap.get(textBuffer2);
                String string3 = comparable + "declare\n" + stringBuilder.toString();
                for (ParseNode parseNode5 : object.keySet()) {
                    ParseNode parseNode6 = (ParseNode)object.get(parseNode5);
                    String string4 = list.get((int)parseNode6.from).content;
                    String string5 = list.get((int)parseNode5.from).content;
                    string3 = string3.replace(string4, string5);
                }
                ParseNode parseNode7 = parsed.getRoot().parent(textBuffer2.from, textBuffer2.to);
                if (!parseNode7.contains(SqlEarley.getInstance().getSymbol("stmt"))) {
                    parseNode7 = parsed.getRoot().parent(parseNode7.from, parseNode7.to);
                }
                if ((n5 = string.substring(0, n9 = list.get((int)parseNode7.from).begin).lastIndexOf(10) + 1) < 0) {
                    n5 = 0;
                }
                parseNode.put(n5, list.get((int)(parseNode7.to - 1)).end, Inliner.indentLines(n9 - n5 - n11, string3));
            }
            return parseNode;
        }
        catch (Exception exception) {
            System.err.println("Exception caught during inline: ");
            exception.printStackTrace();
            return null;
        }
    }

    private boolean notPublic(String string) {
        if (this.plsNode == null) {
            return true;
        }
        PlSqlNode plSqlNode = this.getPkgNode();
        if (plSqlNode == null) {
            return true;
        }
        for (Member member : plSqlNode.parseMembers()) {
            if (!member.name.equals(string)) continue;
            return false;
        }
        return true;
    }

    private boolean notUsedOutsideBody(String string) {
        if (this.plsNode == null) {
            return true;
        }
        String string2 = this.plsNode.getConnectionName();
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(string2, true);
        }
        catch (DBException dBException) {
            return true;
        }
        String string3 = DBUtil.getInstance((Connection)connection).executeReturnOneCol("select * from sys.all_identifiers where rownum <= 5 \nand name ='" + string + "'  and usage ='CALL' and object_name != '" + this.plsNode.getObjectName() + "' --and owner ='SCOTT';");
        return string3 == null;
    }

    public static String indentLines(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().intern();
            stringBuffer2.append(string2);
            if (!"\n".equals(string2)) continue;
            stringBuffer2.append(stringBuffer);
        }
        return stringBuffer2.toString();
    }

    private static String padFromNL2Pos(int n, String string) {
        int n2 = string.substring(0, n).lastIndexOf(10) + 1;
        if (n2 < 0) {
            n2 = 0;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n - n2; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private PlSqlNode getPkgNode() {
        URL uRL = this.plsNode.getURL();
        String string = DBURLFormatHelper.getBaseType(uRL);
        URL uRL2 = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL), "", DBURLFormatHelper.getSchema(uRL), string.substring(0, string.indexOf(32))), DBURLFormatHelper.getName(uRL));
        return PlSqlNode.find(uRL2);
    }

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile(Inliner.class, (String)"testInline.sql");
        Parsed parsed = new Parsed(string, (Earley)SqlEarley.getInstance(), "sql_statements");
        parsed.getRoot().printTree();
        int n = parsed.getInput().indexOf("--^");
        Replacements replacements = new Inliner(null).runProgram(n, parsed.getInput(), parsed.getSrc(), null, true);
        if (replacements == null) {
            return;
        }
        System.out.println(replacements.toString());
    }

    static class IProgram
    extends SqlProgram {
        int offset = -1;

        IProgram() {
        }
    }
}

