/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.IdentifiersDb;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.editors.DbEditor;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.runner.DBStarterFactory;
import oracle.dbtools.raptor.runner.PlSqlRunnerPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.db.model.SqlNode;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.runner.Debugger;
import oracle.ide.runner.RunProcess;
import oracle.ide.view.View;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdeveloper.runner.RunningProcess;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.run.JRunner;

public class PLSQLController
implements Controller {
    static Logger LOGGER = Logger.getLogger(PLSQLController.class.getName());
    private static final Object LOCK = new Object();
    public static final int COMPILE_COMMAND = Ide.findOrCreateCmdID((String)"PlSqlController.Compile");
    public static final int COMPILE_DEBUG_COMMAND = Ide.findOrCreateCmdID((String)"PlSqlController.CompileDebug");
    public static final int MAKE_COMMAND = Ide.findOrCreateCmdID((String)"PlSqlController.Make");
    public static final int RUN_COMMAND = Ide.findOrCreateCmdID((String)"PlSqlController.Run");
    public static final int DEBUG_COMMAND = Ide.findOrCreateCmdID((String)"PlSqlController.Debug");
    int tmpDebug = 0;
    private String selection = null;
    List<LexerToken> fragment;
    Matrix matrix;
    ParseNode selRoot;

    public boolean update(IdeAction ideAction, Context context) {
        Node node = context.getNode();
        if (node instanceof PlSqlNode) {
            PLSQLController.updateAction(ideAction, (PlSqlNode)node);
        } else if (node instanceof SqlNode) {
            this.updateAction(ideAction, context);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(IdeAction ideAction, final Context context) {
        boolean bl = false;
        final int n = ideAction.getCommandId();
        if (n == MAKE_COMMAND || n == COMPILE_DEBUG_COMMAND || n == COMPILE_COMMAND) {
            Node node = context.getNode();
            if (node instanceof PlSqlNode) {
                PlSqlNode plSqlNode = (PlSqlNode)node;
                WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
                waitCursor.show();
                try {
                    plSqlNode.ensureOpen();
                    plSqlNode.markDirty(true);
                    plSqlNode.invokedFromToolbar = true;
                    String string = plSqlNode.getConnectionName();
                    if (string == null) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString("PLSQLController.noConnectionMsg"), (String)Messages.getString("PLSQLController.noConnectionTitle"), null);
                        boolean bl2 = true;
                        return bl2;
                    }
                    if (n == COMPILE_DEBUG_COMMAND) {
                        this.setDebug(true, string);
                    } else if (n == COMPILE_COMMAND) {
                        this.setDebug(false, string);
                    } else {
                        this.setDebug(null, string);
                    }
                    plSqlNode.save();
                    this.restoreDebug(string);
                }
                catch (IOException iOException) {
                    System.out.println("PLSQLController.IOException:" + iOException.getMessage());
                }
                finally {
                    waitCursor.hide();
                }
                Ide.getStatusBar().setText(Messages.getString("PLSQLController.0"));
                bl = true;
            }
        } else if (n == RUN_COMMAND || n == DEBUG_COMMAND) {
            final Node node = context.getNode();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Object object;
                    TextBuffer textBuffer = null;
                    boolean bl = node instanceof PlSqlNode;
                    if (bl) {
                        object = n == DEBUG_COMMAND ? new PlSqlRunnerPanel.PlSqlDebuggerPanel((PlSqlNode)node) : new PlSqlRunnerPanel((PlSqlNode)node);
                        textBuffer = ((PlSqlRunnerPanel)object).runDialog();
                        ((PlSqlRunnerPanel)object).cleanup();
                    }
                    if (textBuffer != null || !bl) {
                        RunConfiguration runConfiguration;
                        object = context.getProject();
                        if (object != null && (runConfiguration = RunConfigurations.getRunConfigurationByName((Project)object, (String)RunConfiguration.getDefaultName())) != null) {
                            context.setProperty("RunContext.RUN_CONFIGURATION", (Object)runConfiguration);
                        }
                        runConfiguration = JRunner.prepareProcessContext((Context)context, (boolean)false);
                        if (textBuffer != null) {
                            runConfiguration.setProperty("PlSqlStarter.SQL", (Object)textBuffer.getString(0, textBuffer.getLength()));
                        }
                        RunningProcess runningProcess = n == RUN_COMMAND ? new RunningProcess((Context)runConfiguration) : new DebuggingProcess((Context)runConfiguration);
                        RunConfiguration runConfiguration2 = runningProcess.getRunConfiguration();
                        boolean bl2 = DBURLFormatHelper.isDBURL(node.getURL());
                        if (!bl2) {
                            runConfiguration2.setCompileBeforeRun(false);
                            if (node instanceof PlSqlNode) {
                                runConfiguration2.setTargetURL(((PlSqlNode)node).matchingDbUrl());
                            } else {
                                try {
                                    runConfiguration2.setTargetURL(new URL("http://potato.com"));
                                    Class<RunProcess> clazz = RunProcess.class;
                                    Field field = clazz.getDeclaredField("starter");
                                    field.setAccessible(true);
                                    View view = context.getView();
                                    String string = ((DbEditor)view).getConnectionName();
                                    field.set(runningProcess, (Object)new DBStarterFactory.PlSqlStarter((JRunProcess)runningProcess, PLSQLController.this.selection, string, context));
                                }
                                catch (Exception exception) {
                                    System.err.println(exception);
                                }
                            }
                        } else {
                            runConfiguration2.setTargetURL(node.getURL());
                        }
                        runningProcess.start();
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
            bl = true;
        }
        return bl;
    }

    private void restoreDebug(String string) {
        DBConfig.getInstance().putInt("PLSQLOPTIMLEVEL", this.tmpDebug);
        Connections connections = Connections.getInstance();
        DBConfig dBConfig = DBConfig.getInstance();
        try {
            int n = Connections.getInstance().getConnection(string).getMetaData().getDatabaseMajorVersion();
            if (n >= 10) {
                DBUtil.getInstance((String)string).execute("alter session set PLSQL_OPTIMIZE_LEVEL=" + dBConfig.getString("PLSQLOPTIMLEVEL"), Collections.emptyList());
            }
        }
        catch (SQLException sQLException) {
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (!connections.isTimesTen(string)) {
            DBUtil.getInstance((String)string).execute("alter session set PLSQL_DEBUG=" + (dBConfig.getInt("PLSQLOPTIMLEVEL") < 2), Collections.emptyList());
        }
    }

    private void setDebug(Boolean bl, String string) {
        this.tmpDebug = DBConfig.getInstance().getInt("PLSQLOPTIMLEVEL");
        int n = bl == null ? this.tmpDebug : (bl != false ? 1 : 2);
        DBConfig.getInstance().putInt("PLSQLOPTIMLEVEL", n);
        if (bl == null) {
            bl = DBConfig.getInstance().getInt("PLSQLOPTIMLEVEL") < 2;
        }
        Connections connections = Connections.getInstance();
        try {
            int n2 = Connections.getInstance().getConnection(string).getMetaData().getDatabaseMajorVersion();
            if (n2 >= 10) {
                DBUtil.getInstance((String)string).execute("alter session set PLSQL_OPTIMIZE_LEVEL=" + n, Collections.emptyList());
            }
        }
        catch (SQLException sQLException) {
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (!connections.isTimesTen(string) && bl != null) {
            DBUtil.getInstance((String)string).execute("alter session set PLSQL_DEBUG=" + bl, Collections.emptyList());
        }
    }

    public static boolean updateAction(final IdeAction ideAction, final PlSqlNode plSqlNode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ideAction.setEnabled(true);
                boolean bl = plSqlNode.getConnectionName() != null;
                Debugger debugger = Debugger.getDebugger();
                if (debugger.isDebugging() || !bl) {
                    ideAction.setEnabled(false);
                }
                if (DBURLFormatHelper.isDBURL(plSqlNode.getURL()) && Boolean.valueOf((String)plSqlNode.getProperty("INVALID")).booleanValue() && (ideAction.getCommandId() == RUN_COMMAND || ideAction.getCommandId() == DEBUG_COMMAND)) {
                    ideAction.setEnabled(false);
                }
                if ("BLOCK".equals(plSqlNode.getObjectType())) {
                    ideAction.setEnabled(false);
                }
                if (("TYPE".equals(plSqlNode.getObjectType()) || "PACKAGE".equals(plSqlNode.getObjectType())) && ideAction.getCommandId() == DEBUG_COMMAND && !plSqlNode.hasBody()) {
                    ideAction.setEnabled(false);
                }
            }
        });
        return true;
    }

    void updateAction(final IdeAction ideAction, final Context context) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ideAction.setEnabled(false);
                View view = context.getView();
                BasicEditorPane basicEditorPane = ((BasicEditorPaneContainer)view).getFocusedEditorPane();
                String string = ((DbEditor)view).getConnectionName();
                Debugger debugger = Debugger.getDebugger();
                if (basicEditorPane.getLineCount() > 1000 || string == null || debugger.isDebugging()) {
                    return;
                }
                int n = basicEditorPane.getCaretPosition();
                BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
                String string2 = PLSQLController.this.extractText(basicDocument.getTextBuffer());
                List list = LexerToken.parse((String)string2);
                LazyNode lazyNode = StackParser.getInstance().parse(list);
                LazyNode lazyNode2 = null;
                if ("declare".equalsIgnoreCase(lazyNode.startToken) || "begin".equalsIgnoreCase(lazyNode.startToken)) {
                    lazyNode2 = lazyNode;
                } else {
                    for (ParseNode parseNode : lazyNode.children()) {
                        if (((LexerToken)list.get((int)parseNode.from)).begin > n || n >= ((LexerToken)list.get((int)(parseNode.to - 1))).end) continue;
                        lazyNode2 = (LazyNode)parseNode;
                        if ("declare".equalsIgnoreCase(lazyNode2.startToken) || "begin".equalsIgnoreCase(lazyNode2.startToken)) break;
                        return;
                    }
                    if (lazyNode2 == null) {
                        return;
                    }
                }
                PLSQLController.this.selection = string2.substring(((LexerToken)list.get((int)lazyNode2.from)).begin, ((LexerToken)list.get((int)(lazyNode2.to - 1))).end);
                if (!PLSQLController.this.selection.endsWith(";")) {
                    PLSQLController.this.selection = PLSQLController.this.selection + ";";
                }
                if (!PLSQLController.this.parse(PLSQLController.this.selection)) {
                    return;
                }
                ideAction.setEnabled(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String extractText(TextBuffer textBuffer) {
        String string = "";
        try {
            if (!textBuffer.tryReadLock()) {
                String string2 = string;
                return string2;
            }
            if (textBuffer.getLength() > 50000) {
                Logger.getLogger(this.getClass().getName()).warning("Source too big");
                String string3 = string;
                return string3;
            }
            string = textBuffer.getString(0, textBuffer.getLength());
            if (string != null) return string;
            String string4 = "";
            return string4;
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            return string;
        }
        finally {
            try {
                textBuffer.readUnlock();
            }
            catch (Throwable throwable) {}
        }
    }

    private boolean parse(String string) {
        this.fragment = LexerToken.parse((String)string);
        SqlEarley sqlEarley = SqlEarley.getInstance();
        Matrix matrix = new Matrix((Parser)sqlEarley);
        sqlEarley.parse(this.fragment, matrix);
        if (!matrix.contains(0, this.fragment.size(), IdentifiersDb.instance.block_stmt)) {
            return false;
        }
        this.selRoot = sqlEarley.forest(this.fragment, matrix);
        return true;
    }
}

