/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.oviewer.search.NavSearchDockableFactory;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.DockableView;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.model.Node;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.editor.find.Finder;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;

public class FindHighlightListener
implements EditorListener {
    private MouseListener mouseler;
    private KeyListener keydler;
    private BasicEditorPane editorPane;
    private Editor editor;

    public void editorOpened(Editor editor) {
    }

    public void editorActivated(Editor editor) {
        Node node = editor.getContext().getNode();
        if (!(node instanceof EquippedWithParser) && !(editor instanceof EquippedWithParser)) {
            return;
        }
        this.editor = editor;
        this.addListeners();
    }

    private void addListeners() {
        if (null == this.editor) {
            return;
        }
        if (!(this.editor instanceof BasicEditorPaneContainer)) {
            return;
        }
        this.editorPane = ((BasicEditorPaneContainer)this.editor).getFocusedEditorPane();
        if (this.editorPane != null) {
            EquippedWithParser equippedWithParser = null;
            final Node node = this.editor.getContext().getNode();
            if (node instanceof EquippedWithParser) {
                equippedWithParser = (EquippedWithParser)node;
            } else if (this.editor instanceof EquippedWithParser) {
                equippedWithParser = (EquippedWithParser)this.editor;
            }
            if (equippedWithParser == null) {
                return;
            }
            final BackgroundParser backgroundParser = equippedWithParser.getParser();
            final HighlightLayer highlightLayer = this.editorPane.createHighlightLayer();
            this.mouseler = new MouseAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Finder.clearHighlights((BasicEditorPane)FindHighlightListener.this.editorPane);
                    if (highlightLayer != null) {
                        highlightLayer.removeAllHighlights();
                    }
                    if (mouseEvent.getClickCount() != 2) {
                        return;
                    }
                    String string = FindHighlightListener.this.editorPane.getSelectedText();
                    int n = FindHighlightListener.this.editorPane.getSelectionStart();
                    HighlightStyle highlightStyle = Finder.getFindStyle();
                    highlightLayer.beginBlockUpdate();
                    try {
                        LexerToken lexerToken = null;
                        for (LexerToken lexerToken2 : backgroundParser.src) {
                            if (lexerToken2.begin != n || !lexerToken2.content.equalsIgnoreCase(string)) continue;
                            lexerToken = lexerToken2;
                            break;
                        }
                        if (lexerToken == null) {
                            return;
                        }
                        for (LexerToken lexerToken2 : backgroundParser.src) {
                            if (lexerToken2.end - lexerToken2.begin != lexerToken.end - lexerToken.begin || lexerToken2.type != lexerToken.type || !lexerToken2.content.equalsIgnoreCase(lexerToken.content)) continue;
                            highlightLayer.addHighlight(highlightStyle, lexerToken2.begin, lexerToken2.end);
                        }
                    }
                    finally {
                        highlightLayer.endBlockUpdate();
                    }
                }
            };
            this.keydler = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (highlightLayer != null) {
                        highlightLayer.removeAllHighlights();
                    }
                    if (!keyEvent.isAltDown() || keyEvent.getKeyChar() != 'g') {
                        return;
                    }
                    String string = FindHighlightListener.this.editorPane.getSelectedText();
                    if (string == null || 50 < string.length()) {
                        int n = FindHighlightListener.this.editorPane.getSelectionStart();
                        LexerToken lexerToken = null;
                        for (LexerToken lexerToken2 : backgroundParser.src) {
                            if (lexerToken2.begin > n || n > lexerToken2.end) continue;
                            lexerToken = lexerToken2;
                            break;
                        }
                        if (lexerToken == null) {
                            return;
                        }
                        string = lexerToken.content;
                    }
                    String string2 = null;
                    if (FindHighlightListener.this.editor instanceof IDBEditor) {
                        string2 = ((IDBEditor)FindHighlightListener.this.editor).getConnectionName();
                    }
                    if (node instanceof PlSqlNode) {
                        string2 = ((PlSqlNode)node).getConnectionName();
                    }
                    if (string2 == null) {
                        return;
                    }
                    DockUtil.showDockableWindow((DockableView)NavSearchDockableFactory.getSearchWindow(string2, string));
                }
            };
            this.editorPane.addMouseListener(this.mouseler);
            this.editorPane.addKeyListener(this.keydler);
            this.editorPane.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (highlightLayer != null) {
                        highlightLayer.removeAllHighlights();
                    }
                }

                @Override
                public void focusGained(FocusEvent focusEvent) {
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FindHighlightListener.this.addListeners();
                }
            });
        }
    }

    public void editorDeactivated(Editor editor) {
        if (!"CodeEditor".equals(editor.getDisplayName()) && !"Worksheet".equals(editor.getDisplayName())) {
            return;
        }
        this.editor = null;
        if (this.editorPane != null) {
            this.editorPane.removeMouseListener(this.mouseler);
            this.editorPane.removeKeyListener(this.keydler);
        }
    }

    public void editorClosed(Editor editor) {
    }
}

