/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.plsql.IdentifierDefinitionLookup;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.ISchedulingRule;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.internal.ObjectMutexRule;
import oracle.dbtools.raptor.cloud.navigator.CloudObject;
import oracle.dbtools.raptor.cloud.navigator.CloudViewerDetail;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.IResultSetTableDrillDown;
import oracle.dbtools.raptor.controls.ViewerOpener;
import oracle.dbtools.raptor.controls.search.BaseSearchPanel;
import oracle.dbtools.raptor.navigator.ViewableSelectionComponentProvider;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.db.model.DatabaseItem;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ViewableElement;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.navigator.ui.CustomTree;
import oracle.dbtools.raptor.onsd.navigator.OnsdObject;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.oviewer.cloud.CloudEditorUtils;
import oracle.dbtools.raptor.plsql.structure.OutlineWindow;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;

public class NavSelectionListener
implements ViewSelectionListener,
IResultSetTableDrillDown,
ViewerOpener {
    private ViewableElement _pendingNodeSelectionChange;
    private boolean _hasMousePressed;
    private boolean _hasMouseReleased;
    private boolean _hasSelectionChanged;
    private boolean _inRightClick;
    private static NavSelectionListener _instance;
    private String row;
    private MouseAdapter m_mouseHandler = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            Boolean bl = DBConfig.getInstance().getBoolean("OPEN_ON_SINGLE_CLICK");
            if (bl.booleanValue() || mouseEvent.getClickCount() == 2) {
                Object object = mouseEvent.getSource();
                ViewableElement viewableElement = null;
                if (object instanceof CustomTree) {
                    CustomTree customTree = (CustomTree)object;
                    TreePath treePath = customTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath != null) {
                        viewableElement = NavSelectionListener.this.getLastObject(customTree);
                    }
                } else if (object instanceof JList) {
                    viewableElement = NavSelectionListener.this.getLastObject(mouseEvent.getPoint(), (JList)object);
                }
                if (viewableElement != null) {
                    NavSelectionListener.this.whenDatabaseObjectSelected(viewableElement, bl == false);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            NavSelectionListener.this._inRightClick = mouseEvent.getModifiers() == 4 || mouseEvent.getModifiers() == 8;
            NavSelectionListener.this.cancelPendingChanges();
            NavSelectionListener.this._hasMousePressed = true;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            ViewableElement viewableElement = null;
            boolean bl = false;
            if (object instanceof CustomTree) {
                CustomTree customTree = (CustomTree)mouseEvent.getSource();
                viewableElement = NavSelectionListener.this.getLastObject(customTree);
                bl = customTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()) != null;
            } else if (object instanceof JList) {
                viewableElement = NavSelectionListener.this.getLastObject(mouseEvent.getPoint(), (JList)object);
                boolean bl2 = bl = viewableElement != null;
            }
            if (viewableElement != null) {
                NavSelectionListener.this._pendingNodeSelectionChange = viewableElement;
            }
            if (NavSelectionListener.this._hasSelectionChanged && bl) {
                NavSelectionListener.this.doPendingChanges();
            } else {
                NavSelectionListener.this._hasMouseReleased = true;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            NavSelectionListener.this.cancelPendingChanges();
            NavSelectionListener.this._hasMousePressed = true;
        }
    };
    private List<ViewableElement> _opening = new ArrayList<ViewableElement>();

    private NavSelectionListener() {
    }

    public static NavSelectionListener getInstance() {
        return _instance;
    }

    private static void onInit() {
        Ide.getMainWindow().addActiveViewListener(new ActiveViewListener(){

            public void activeViewChanged(ActiveViewEvent activeViewEvent) {
                View view;
                if (activeViewEvent.getOldView() != null) {
                    activeViewEvent.getOldView().removeViewSelectionListener((ViewSelectionListener)_instance);
                }
                if ((view = activeViewEvent.getNewView()) instanceof ViewableSelectionComponentProvider) {
                    NavSelectionListener.hookNavigator(view, (ViewableSelectionComponentProvider)view);
                }
            }
        });
    }

    public static void initialize() {
        _instance = new NavSelectionListener();
        IdentifierDefinitionLookup.registerViewerOpener(_instance);
        BaseSearchPanel.registerViewerOpener(_instance);
        DatabaseSourceNode.registerViewerOpener(_instance);
        NavSelectionListener.onInit();
    }

    private static void hookNavigator(View view, ViewableSelectionComponentProvider viewableSelectionComponentProvider) {
        view.addViewSelectionListener((ViewSelectionListener)_instance);
        Component component = viewableSelectionComponentProvider.getViewableSelectionComponent();
        boolean bl = true;
        MouseAdapter mouseAdapter = NavSelectionListener._instance.m_mouseHandler;
        for (MouseListener mouseListener : component.getMouseListeners()) {
            if (mouseListener != mouseAdapter) continue;
            bl = false;
            break;
        }
        if (bl) {
            component.addMouseListener(mouseAdapter);
            component.addMouseMotionListener(mouseAdapter);
        }
    }

    public void viewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
        Element element;
        Element[] elementArray = viewSelectionEvent.getSelection();
        if (elementArray != null && DBConfig.getInstance().getBoolean("OPEN_ON_SINGLE_CLICK").booleanValue() && elementArray.length == 1 && this.isObjectNode(element = elementArray[0])) {
            this._pendingNodeSelectionChange = (ViewableElement)element;
            boolean bl = false;
            if (!this._hasSelectionChanged && this._hasMousePressed && (!this._hasMouseReleased || this._inRightClick)) {
                bl = true;
            }
            if (bl) {
                this._hasSelectionChanged = true;
            } else {
                this.doPendingChanges();
            }
        }
    }

    private boolean isObjectNode(Element element) {
        return element instanceof ViewableElement;
    }

    private void whenDatabaseObjectSelected(final ViewableElement viewableElement, final boolean bl) {
        if (this._inRightClick || this._opening.contains(viewableElement)) {
            return;
        }
        this._opening.add(viewableElement);
        RaptorTask<Void> raptorTask = new RaptorTask<Void>("Object Selection", true, IRaptorTaskRunMode.TASKVIEWER){
            private ISchedulingRule m_rule;

            protected Void doWork() throws TaskException {
                if (viewableElement instanceof CloudObject) {
                    CloudObject cloudObject = (CloudObject)viewableElement;
                    LinkedHashMap<String, CloudViewerDetail> linkedHashMap = cloudObject.getViewers();
                    CloudEditorUtils cloudEditorUtils = CloudEditorUtils.getInstance();
                    String string = cloudObject.getObjectType();
                    float f = 10000.0f;
                    for (Map.Entry<String, CloudViewerDetail> entry : linkedHashMap.entrySet()) {
                        try {
                            CloudViewerDetail cloudViewerDetail = entry.getValue();
                            cloudEditorUtils.addTab(entry.getKey(), string, null, Float.valueOf(f), cloudViewerDetail.getUriString(), cloudViewerDetail.getStyle());
                            f -= 1.0f;
                        }
                        catch (Exception exception) {
                            Logger.severe(NavSelectionListener.class, (Throwable)exception);
                        }
                    }
                    NavSelectionListener.this.open(viewableElement, bl);
                } else if (viewableElement instanceof OnsdObject) {
                    ((OnsdObject)viewableElement).register();
                    NavSelectionListener.this.open(viewableElement, bl);
                } else if (viewableElement instanceof DatabaseSourceNode) {
                    int n = 1;
                    try {
                        n = Integer.parseInt(NavSelectionListener.this.row);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    NavSelectionListener.this.open(viewableElement, n, -1, null, bl);
                } else if (viewableElement instanceof ObjectFolder) {
                    DatabaseFolder databaseFolder;
                    ObjectFolder objectFolder = (ObjectFolder)viewableElement;
                    DatabaseItem databaseItem = objectFolder.getFolderInstance().getDescriptor();
                    if (databaseItem instanceof DatabaseFolder && (databaseFolder = (DatabaseFolder)databaseItem).isSingleClickOpen()) {
                        NavSelectionListener.this.open(viewableElement, bl);
                    }
                } else if (!(viewableElement instanceof ObjectFolder)) {
                    NavSelectionListener.this.open(viewableElement, bl);
                }
                return null;
            }

            public synchronized ISchedulingRule getSchedulingRule() {
                if (this.m_rule == null) {
                    this.m_rule = new ObjectMutexRule((Object)NavSelectionListener.this);
                }
                return this.m_rule;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    @Override
    public void open(URL uRL) {
        this.open(uRL, 0, 0);
    }

    @Override
    public void open(URL uRL, int n, int n2) {
        this.open(uRL, n, n2, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitOnOpen(URL uRL, int n, int n2) {
        WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
        waitCursor.show();
        try {
            boolean bl = this.open(uRL, n, n2, null, true);
            return bl;
        }
        finally {
            waitCursor.hide();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitOnOpen(URL uRL, String string) {
        WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
        waitCursor.show();
        try {
            boolean bl = this.open(uRL, 0, 0, string, true);
            return bl;
        }
        finally {
            waitCursor.hide();
        }
    }

    private boolean open(URL uRL, int n, int n2, String string, boolean bl) {
        Node node = NodeFactory.find((URL)uRL);
        ViewableElement viewableElement = null;
        if (node instanceof ViewableElement) {
            viewableElement = (ViewableElement)node;
        } else {
            String string2 = DBURLFormatHelper.getName(uRL);
            if (string2 == null) {
                Folder folder = DatabaseNavigatorElementFactory.getTypeFolder(uRL, null);
                if (folder instanceof ViewableElement) {
                    viewableElement = (ViewableElement)folder;
                }
            } else {
                viewableElement = PlSqlNode.find(uRL);
                if (viewableElement == null) {
                    viewableElement = DatabaseNavigatorElementFactory.getObjectNode(uRL);
                }
            }
        }
        return this.open(viewableElement, n, n2, string, bl);
    }

    public void open(ViewableElement viewableElement, int n, int n2, String string) {
        this.open(viewableElement, n, n2, string, true);
    }

    private boolean open(final ViewableElement viewableElement, final int n, final int n2, final String string, final boolean bl) {
        if (viewableElement instanceof DatabaseSourceNode) {
            final DatabaseSourceNode databaseSourceNode = (DatabaseSourceNode)viewableElement;
            DBObject dBObject = new DBObject(databaseSourceNode);
            if ("MIGREPO".equals(dBObject.getConnectionType()) || "MIGREPOC".equals(dBObject.getConnectionType())) {
                return this.open(viewableElement, bl);
            }
            String string2 = databaseSourceNode.getConnectionName();
            if (string2 != null) {
                Connections connections = Connections.getInstance();
                Connection connection = null;
                try {
                    connection = connections.getConnection(string2, false);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (connection == null || !connections.lock(connection, true)) {
                    return false;
                }
                connections.unlock(connection);
            }
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Node node;
                    Context context;
                    EditorManager editorManager = EditorManager.getEditorManager();
                    Context context2 = null;
                    for (Object e : editorManager.getAllEditors()) {
                        context = ((Editor)e).getContext();
                        node = context != null ? context.getNode() : null;
                        if (node != databaseSourceNode) continue;
                        context2 = context;
                    }
                    WaitCursor waitCursor = null;
                    if (context2 == null) {
                        waitCursor = new WaitCursor((Component)Ide.getMainWindow());
                    }
                    try {
                        if (waitCursor != null) {
                            waitCursor.show();
                        }
                        int n4 = 0;
                        if (string != null) {
                            int n22 = 100000;
                            int n3 = (context = databaseSourceNode.acquireTextBuffer()).getLength();
                            String string2 = context.getString(0, n22 < n3 ? n22 : n3);
                            List list = LexerToken.parse((String)string2);
                            LexerToken lexerToken = null;
                            for (LexerToken lexerToken2 : list) {
                                if (lexerToken2.content.toLowerCase().equals(string) && lexerToken != null && (lexerToken.content.toLowerCase().equals("procedure") || lexerToken.content.toLowerCase().equals("function"))) {
                                    n4 = lexerToken2.begin;
                                    break;
                                }
                                lexerToken = lexerToken2;
                            }
                            databaseSourceNode.releaseTextBuffer();
                        } else if (0 < n) {
                            context = databaseSourceNode.acquireTextBuffer();
                            node = context.getLineMap();
                            n4 = node.getLineStartOffset(n - ("create or replace ".contains("\n") ? 0 : 1)) + n2 - 1;
                            databaseSourceNode.releaseTextBuffer();
                        }
                        if (context2 == null) {
                            context2 = Context.newIdeContext((Element)viewableElement);
                        }
                        context = (CodeEditor)NavSelectionListener.this.openEditor(context2, bl, CodeEditor.class);
                        context.gotoOffset(n4, 0);
                        OutlineWindow.getInstance().refresh((Editor)context);
                    }
                    finally {
                        if (waitCursor != null) {
                            waitCursor.hide();
                        }
                    }
                }
            });
            return true;
        }
        return this.open(viewableElement, bl);
    }

    public void open(Node node) {
        this.open(node, true);
    }

    public void open(Node node, boolean bl) {
        if (node instanceof ViewableElement) {
            this.open((ViewableElement)node, bl);
        }
    }

    private boolean open(ViewableElement viewableElement, boolean bl) {
        ViewerNode viewerNode = ViewerNode.getUnpinnedInstance();
        viewerNode.ensureOpen();
        DBObject dBObject = new DBObject(viewableElement);
        if (!this.raiseEditor(viewableElement, bl)) {
            boolean bl2;
            boolean bl3;
            Connection connection;
            Object object;
            String string = dBObject.getConnectionName();
            if (string != null) {
                object = Connections.getInstance();
                connection = null;
                try {
                    connection = ((Connections)object).getConnection(string, false);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (connection == null || !((Connections)object).lock(connection, true)) {
                    return false;
                }
                ((Connections)object).unlock(connection);
            }
            if (viewerNode.getDBObject() == null) {
                bl3 = true;
                bl2 = this.hasViewer(dBObject);
            } else {
                object = viewerNode.getDBObject();
                boolean bl4 = bl3 = ModelUtil.areDifferent((Object)((DBObject)object).getObjectType(), (Object)dBObject.getObjectType()) || ModelUtil.areDifferent((Object)((DBObject)object).getConnectionType(), (Object)dBObject.getConnectionType()) || ModelUtil.areDifferent((Object)((DBObject)object).getDBVersion(), (Object)dBObject.getDBVersion());
                if (!bl3) {
                    bl3 = "true".equals(((DBObject)object).getDictionary().get("NEW_OBJECTVIEWER_FLAG"));
                }
                bl2 = bl3 ? this.hasViewer(dBObject) : true;
            }
            if (!bl2) {
                return false;
            }
            if (bl3) {
                this.closeObjectViewer(viewerNode);
            }
            viewerNode.setViewedObject(dBObject);
            boolean bl5 = DBConfig.getInstance().getBoolean("AUTOPIN");
            viewerNode.setPinned(bl5);
            connection = Context.newIdeContext((Node)viewerNode);
            this.invokeOpenEditorLater((Context)connection, bl);
            return true;
        }
        return false;
    }

    protected boolean hasViewer(DBObject dBObject) {
        boolean bl = false;
        ViewerNode viewerNode = ViewerNode.getTestInstance();
        viewerNode.setViewedObject(dBObject);
        EditorManager editorManager = EditorManager.getEditorManager();
        EditorAddin editorAddin = editorManager.getBestEditorAddin((Node)viewerNode);
        if (editorAddin != null) {
            bl = true;
        }
        return bl;
    }

    private void closeObjectViewer(final ViewerNode viewerNode) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                EditorManager editorManager = EditorManager.getEditorManager();
                List list = editorManager.getAllEditors();
                for (int i = list.size() - 1; i >= 0; --i) {
                    Editor editor = (Editor)list.get(i);
                    Context context = editor.getContext();
                    Node node = context.getNode();
                    if (viewerNode == node) continue;
                    list.remove(i);
                }
                if (!list.isEmpty()) {
                    editorManager.closeEditors(list);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                Logger.severe(NavSelectionListener.class, (Throwable)exception);
            }
        }
    }

    private ViewableElement getLastObject(CustomTree customTree) {
        NavigatorTreeNode navigatorTreeNode;
        Element element;
        ViewableElement viewableElement = null;
        if (customTree.getSelectionCount() > 0 && (element = (navigatorTreeNode = (NavigatorTreeNode)customTree.getLastSelectedPathComponent()).getElement()) instanceof ViewableElement) {
            viewableElement = (ViewableElement)element;
        }
        return viewableElement;
    }

    private boolean raiseEditor(final ViewableElement viewableElement, final boolean bl) {
        Callable<Boolean> callable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean bl2 = false;
                List list = EditorManager.getEditorManager().getAllEditors();
                for (Editor editor : list) {
                    Context context = editor.getContext();
                    Node node = null == context ? null : context.getNode();
                    if (!(node instanceof ViewerNode) || ((ViewerNode)node).getBaseNode() != viewableElement) continue;
                    NavSelectionListener.this.invokeOpenEditorLater(context, bl);
                    bl2 = true;
                    break;
                }
                return bl2;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                return (Boolean)callable.call();
            }
            catch (Exception exception) {
                Logger.warn(NavSelectionListener.class, (Throwable)exception);
            }
        } else {
            FutureTask<Boolean> futureTask = new FutureTask<Boolean>(callable);
            SwingUtilities.invokeLater(futureTask);
            try {
                return futureTask.get();
            }
            catch (Exception exception) {
                Logger.warn(NavSelectionListener.class, (Throwable)exception);
            }
        }
        return false;
    }

    private void doPendingChanges() {
        ViewableElement viewableElement = this._pendingNodeSelectionChange;
        this.cancelPendingChanges();
        this.whenDatabaseObjectSelected(viewableElement, false);
    }

    private void cancelPendingChanges() {
        this._pendingNodeSelectionChange = null;
        this._hasMousePressed = false;
        this._hasMouseReleased = false;
        this._hasSelectionChanged = false;
    }

    @Override
    public void performDrill(Element element, String string) {
        this.cancelPendingChanges();
        this._inRightClick = false;
        this.row = string;
        if (element instanceof ViewableElement) {
            this.whenDatabaseObjectSelected((ViewableElement)element, true);
        }
    }

    private ViewableElement getLastObject(Point point, JList jList) {
        Object e;
        Rectangle rectangle;
        ViewableElement viewableElement = null;
        int n = jList.locationToIndex(point);
        if (n != -1 && (rectangle = jList.getCellBounds(n, n)).contains(point) && (e = jList.getModel().getElementAt(n)) instanceof ViewableElement) {
            viewableElement = (ViewableElement)e;
        }
        return viewableElement;
    }

    private void invokeOpenEditorLater(final Context context, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NavSelectionListener.this.openEditor(context, bl);
            }
        });
    }

    private Editor openEditor(Context context, boolean bl) {
        return this.openEditor(context, bl, null);
    }

    private Editor openEditor(Context context, boolean bl, Class<?> clazz) {
        final OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, clazz);
        openEditorOptions.setFlags(bl ? 5 : 1);
        final Editor editor = this.openEditor(openEditorOptions);
        if (!bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Component component = editor.getGUI();
                    if (null == component || !component.isVisible()) {
                        NavSelectionListener.this.openEditor(openEditorOptions);
                    }
                }
            });
        }
        if (editor != null) {
            View.updateToolbarActions((Toolbar)editor.getToolbar());
        }
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Editor openEditor(OpenEditorOptions openEditorOptions) {
        EditorManager editorManager = EditorManager.getEditorManager();
        WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
        Editor editor = null;
        try {
            waitCursor.show();
            editor = editorManager.openEditor(openEditorOptions);
        }
        finally {
            waitCursor.hide();
            this._opening.clear();
        }
        return editor;
    }
}

