/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Component;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseContainer;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.OBResourcesArb;
import oracle.dbtools.raptor.oviewer.base.ConnectionExportNames;
import oracle.dbtools.raptor.oviewer.base.HTMLTabFormatter;
import oracle.dbtools.raptor.oviewer.base.Messages;
import oracle.dbtools.raptor.oviewer.base.ViewerAddin;
import oracle.dbtools.raptor.plsql.PLSQLDependencies;
import oracle.dbtools.raptor.plsql.PLSQLDetails;
import oracle.dbtools.raptor.plsql.PLSQLGrants;
import oracle.dbtools.raptor.plsql.PLSQLReferences;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class ConnectionExportTask
extends DatabaseQueryTask<File> {
    protected static final String NODE_TYPES_HTML = "/nodeTypes.html";
    private File _outputDir;
    protected DBObject _selectedObject;
    private ObjectFactory _factory;
    private List<DBFolderInstance> m_nodeTypeFilter;
    private int m_parallellism;
    private BlockingQueue<HTMLTabFormatterWorkerRequest> requestQ;
    private boolean m_generateEmptyTypes;
    private static String m_ideEncoding;
    private int errorCount;
    private boolean cancelled;
    private Map<DBFolderInstance, ConnectionExportNames[]> filterNameMap = new HashMap<DBFolderInstance, ConnectionExportNames[]>();

    public ConnectionExportTask(String string, File file, DBObject dBObject) {
        super(string, IRaptorTaskRunMode.MODAL_OPTIONAL, false, true, false);
        this._outputDir = file;
        this._selectedObject = dBObject;
        this.cancelled = false;
        this.m_parallellism = 1;
        m_ideEncoding = IdeUtil.getIdeEncoding();
        if (m_ideEncoding == null) {
            m_ideEncoding = "UTF-8";
        }
    }

    @Override
    public String getConnectionName() {
        return this._selectedObject.getConnectionName();
    }

    public File doWork() {
        if (this._outputDir != null) {
            this._outputDir.mkdirs();
            try {
                int n;
                boolean bl = false;
                List list = FileUtils.getFilesInPackage((String)"oracle.dbtools.raptor.oviewer.base.htmlExportResources", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"");
                for (URL uRL : list) {
                    if (uRL.getFile().endsWith("/") || this.copyResourceFile(this._outputDir, uRL, uRL.getFile().substring(uRL.getFile().lastIndexOf("/") + 1))) continue;
                    bl = true;
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, this.getDescriptor().getMessage());
                }
                this.errorCount = 0;
                this.requestQ = new LinkedBlockingQueue<HTMLTabFormatterWorkerRequest>();
                Thread[] threadArray = new Thread[this.m_parallellism];
                for (n = 0; n < this.m_parallellism; ++n) {
                    HTMLTabFormatterWorker hTMLTabFormatterWorker = new HTMLTabFormatterWorker(this.requestQ, this._selectedObject.getConnectionName());
                    Thread thread = new Thread(hTMLTabFormatterWorker);
                    thread.start();
                    threadArray[n] = thread;
                }
                this.createNodeTypes(this._outputDir);
                try {
                    for (n = 0; n < this.m_parallellism; ++n) {
                        this.requestQ.put(new HTMLTabFormatterWorkerRequest());
                    }
                    for (n = 0; n < this.m_parallellism; ++n) {
                        threadArray[n].join();
                    }
                    this.getDescriptor().setProgress(100);
                    this.setProgressbarMsg(OBResourcesArb.getString("DBDOC_GENERATE_COMPLETED"));
                    if (this.errorCount != 0) {
                        String string = Messages.getString("ConnectionExportTask.generationError").replace("{0}", Integer.toString(this.errorCount));
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, string);
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new ExecutionException(interruptedException);
                }
                if (bl) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, this.getDescriptor().getMessage());
                    return null;
                }
            }
            catch (IOException iOException) {
                this.setProgressbarMsg(iOException.getMessage());
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable instanceof CancellationException) {
                    this.setProgressbarMsg(Messages.getString("ConnectionExportTask.4"));
                }
                this.setProgressbarMsg(executionException.getMessage());
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, executionException.getStackTrace()[0].toString(), executionException);
            }
        }
        if (this._outputDir == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)Messages.getString("ConnectionExportTask.5"), (String)Messages.getString("ConnectionExportTask.6"), (String)"f1_dbdoc_html");
                }
            });
        }
        return this._outputDir;
    }

    public boolean cancel() {
        this.cancelled = true;
        return true;
    }

    protected void setProgressbarMsg(String string) {
        this.getDescriptor().setMessage(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createNodeTypes(File file) throws IOException, ExecutionException {
        String string = this._selectedObject.getConnectionName();
        Connection connection = this._selectedObject.getConnection();
        this.setProgressbarMsg(OBResourcesArb.getString("DBDOC_GENERATE_OBJ_TYPE"));
        this._factory = ObjectFactory.getFactory(string, connection);
        this.checkCanProceed();
        if (this._factory != null) {
            Writer writer = null;
            StringBuilder stringBuilder = new StringBuilder();
            try {
                writer = ConnectionExportTask.getFileWriter(file.getAbsolutePath() + NODE_TYPES_HTML);
                writer.write("<html>" + ConnectionExportTask.getLineTerminator());
                ConnectionExportTask.writeStyleSheetTag(writer, "./");
                writer.write("<body id=\"top_left\">" + ConnectionExportTask.getLineTerminator());
                writer.write("<h2>" + this._factory.getSchema() + "</h2>" + ConnectionExportTask.getLineTerminator());
                boolean bl = false;
                for (DBFolderInstance dBFolderInstance : this.m_nodeTypeFilter) {
                    if (this.cancelled) {
                        break;
                    }
                    ConnectionExportNames[] connectionExportNamesArray = this.filterNameMap.get(dBFolderInstance);
                    if (connectionExportNamesArray == null) {
                        connectionExportNamesArray = new ConnectionExportNames[]{new ConnectionExportNames(dBFolderInstance.getType(), this.getFolderTypeName(dBFolderInstance))};
                    }
                    for (ConnectionExportNames connectionExportNames : connectionExportNamesArray) {
                        String string2 = connectionExportNames.getLabel();
                        String string3 = "";
                        File file2 = new File(file.getAbsolutePath() + "/" + connectionExportNames.getType().toLowerCase());
                        file2.mkdir();
                        if (this.createNodeValues(dBFolderInstance, connectionExportNames, file2)) {
                            if (bl) {
                                string3 = "<a href=\"javascript:$n('" + connectionExportNames.getType().toLowerCase() + "')\" id=\"" + connectionExportNames.getType().toLowerCase() + "\" class=\"current\">" + string2 + "</a>";
                                bl = true;
                            } else {
                                string3 = "<a href=\"javascript:$n('" + connectionExportNames.getType().toLowerCase() + "')\" id=\"" + connectionExportNames.getType().toLowerCase() + "\">" + string2 + "</a>";
                            }
                            stringBuilder.append(string3 + ConnectionExportTask.getLineTerminator());
                        }
                        this.getDescriptor().makeProgress(100 / this.m_nodeTypeFilter.size());
                        this.checkCanProceed();
                    }
                }
            }
            finally {
                if (writer != null) {
                    writer.write(stringBuilder.toString() + ConnectionExportTask.getLineTerminator() + "</body> </html>");
                    writer.close();
                }
            }
        }
    }

    protected static void writeStyleSheetTag(Writer writer, String string) throws IOException {
        writer.write("<head>" + ConnectionExportTask.getLineTerminator());
        writer.write("<meta http-equiv=\"content-type\" content=\"text/html; charset=" + m_ideEncoding + "\" />" + ConnectionExportTask.getLineTerminator());
        writer.write("<script src=\"" + string + "dbdoc.js\" type=\"text/javascript\"></script>" + ConnectionExportTask.getLineTerminator());
        writer.write("<link href=\"" + string + "dbdoc.css\" type=\"text/css\" rel=\"stylesheet\">" + ConnectionExportTask.getLineTerminator());
        writer.write("</head>" + ConnectionExportTask.getLineTerminator());
    }

    public static Writer getFileWriter(String string) throws IOException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, m_ideEncoding);
            return outputStreamWriter;
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createNodeValues(DBFolderInstance dBFolderInstance, ConnectionExportNames connectionExportNames, File file) throws IOException, ExecutionException {
        Writer writer = null;
        boolean bl = false;
        try {
            writer = ConnectionExportTask.getFileWriter(file.getAbsolutePath() + "/index.html");
            if (writer == null) {
                boolean bl2 = false;
                return bl2;
            }
            writer.write("<html>" + ConnectionExportTask.getLineTerminator());
            ConnectionExportTask.writeStyleSheetTag(writer, "../");
            writer.write("<body id=\"bottom_left\">" + ConnectionExportTask.getLineTerminator());
            String string = connectionExportNames.getLabel();
            writer.write("<h2>" + string + "" + ConnectionExportTask.getLineTerminator());
            writer.write("<div id=\"search\"><input type=\"text\" onkeyup=\"$d_Find('narrow',this.value,'a')\"/></div></h2><div id=\"narrow\">");
            try {
                List<? extends DBChildInstance> list = dBFolderInstance.listChildren();
                Collections.sort(list, new Comparator<DBChildInstance>(){

                    @Override
                    public int compare(DBChildInstance dBChildInstance, DBChildInstance dBChildInstance2) {
                        Comparable comparable = (Comparable)dBChildInstance.getProperty("NAME");
                        Comparable comparable2 = (Comparable)dBChildInstance2.getProperty("NAME");
                        return comparable.compareTo(comparable2);
                    }
                });
                for (DBChildInstance dBChildInstance : list) {
                    if (this.cancelled) {
                        break;
                    }
                    bl = true;
                    String string2 = (String)dBChildInstance.getProperty("NAME");
                    String string3 = ConnectionExportTask.getEncodedURLName(string2);
                    String string4 = "<a href =\"" + string3 + ".html\" target=\"ObjectDetailsFrame\">" + string2 + "</a>";
                    writer.write(string4 + ConnectionExportTask.getLineTerminator());
                    this.createNodeDetails(connectionExportNames, dBChildInstance, file);
                    this.checkCanProceed();
                }
            }
            catch (SQLException sQLException) {
                this.setProgressbarMsg(sQLException.getMessage());
            }
            catch (AbortException abortException) {
                this.setProgressbarMsg(abortException.getMessage());
            }
        }
        finally {
            if (writer != null) {
                writer.write(ConnectionExportTask.getLineTerminator() + "</div></body> </html>");
                writer.close();
            }
        }
        if (this.m_generateEmptyTypes) {
            return true;
        }
        return bl;
    }

    public static String getEncodedURLName(String string) throws UnsupportedEncodingException {
        String string2 = URLEncoder.encode(string, "UTF-8");
        return string2.replace("*", "%2A").replace("%", "%25");
    }

    private String getFolderTypeName(DBFolderInstance dBFolderInstance) {
        String string = dBFolderInstance.getType().toLowerCase();
        if (dBFolderInstance.getDescriptor() instanceof DatabaseContainer) {
            string = ((DatabaseContainer)dBFolderInstance.getDescriptor()).getLabel();
        }
        return string;
    }

    private void createNodeDetails(ConnectionExportNames connectionExportNames, DBChildInstance dBChildInstance, File file) throws IOException, ExecutionException {
        Connection connection;
        String string = this._selectedObject.getConnectionName();
        ObjectFactory objectFactory = ObjectFactory.getFactory(string, connection = this._selectedObject.getConnection());
        if (objectFactory != null) {
            ViewerAddin viewerAddin = (ViewerAddin)AddinManager.getAddinManager().getAddin(ViewerAddin.class);
            String string2 = (String)dBChildInstance.getProperty("NAME");
            URL uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", string, null, this._factory.getSchema(), connectionExportNames.getType()), string2);
            DBObject dBObject = new DBObject(uRL);
            List<DisplayModel> list = viewerAddin.getModels(dBObject);
            if (list == null || list.size() == 0) {
                list = this.buildPlSqlModels(dBObject);
            }
            if (list != null && list.size() > 0) {
                for (DisplayModel displayModel : list) {
                    displayModel.setConnection(dBObject.getConnection());
                }
                try {
                    this.requestQ.put(new HTMLTabFormatterWorkerRequest(connectionExportNames.getType(), dBObject, list, this.buildBindMap(dBObject, dBChildInstance), file));
                }
                catch (InterruptedException interruptedException) {
                    throw new ExecutionException(interruptedException);
                }
            }
            this.checkCanProceed();
        }
    }

    private Map<String, Object> buildBindMap(DBObject dBObject, DBChildInstance dBChildInstance) {
        Map<String, Object> map = dBObject.getDictionary();
        for (String string : dBChildInstance.getPropertyKeys()) {
            if (map.containsKey(string)) continue;
            map.put(string, dBChildInstance.getProperty(string));
        }
        return map;
    }

    protected List<DisplayModel> buildPlSqlModels(DBObject dBObject) {
        boolean bl;
        LinkedList<DisplayModel> linkedList = new LinkedList<DisplayModel>();
        int n = 9;
        String string = dBObject.getDBVersion();
        if (string != null && string.indexOf(46) > 0) {
            String string2 = string.substring(0, string.indexOf(46));
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                n = 9;
            }
        }
        boolean bl2 = bl = dBObject.getObjectType().startsWith("PACKAGE") || dBObject.getObjectType().equals("PROCEDURE") || dBObject.getObjectType().equals("FUNCTION");
        if (dBObject.getObjectType().startsWith("PACKAGE") || dBObject.getObjectType().equals("PROCEDURE") || dBObject.getObjectType().equals("FUNCTION") || dBObject.getObjectType().equals("TRIGGER") || dBObject.getObjectType().equals("TYPE")) {
            if (bl) {
                this.addDetail(linkedList, "Doc", false, "Doc", "select text from all_source where name = :OBJECT_NAME\nand owner = '" + dBObject.getSchemaName() + "' and type = '" + dBObject.getObjectType() + "'");
            }
            this.addDetail(linkedList, null, true, "Details", PLSQLDetails.query(n));
            this.addDetail(linkedList, null, false, "Grants", PLSQLGrants.query(n));
            this.addDetail(linkedList, null, false, "References", PLSQLReferences.query(n));
            this.addDetail(linkedList, null, false, "Dependencies", PLSQLDependencies.query(n));
            this.addDetail(linkedList, "Code", false, "Code", "select text from all_source where name = :OBJECT_NAME\nand owner = '" + dBObject.getSchemaName() + "' and type = '" + dBObject.getObjectType() + "'");
        }
        return linkedList;
    }

    private void addDetail(List<DisplayModel> list, String string, boolean bl, String string2, String string3) {
        DisplayModel displayModel = new DisplayModel();
        displayModel.setName(string2);
        if (string != null) {
            displayModel.setStyle(string);
        }
        if (bl) {
            displayModel.getExtValues().put("TYPE", "vertical");
        }
        Query query = new Query();
        query.setSql(string3);
        displayModel.addQuery(query);
        list.add(displayModel);
    }

    private static String getLineTerminator() {
        return System.getProperty("line.separator");
    }

    private boolean copyFileFromJar(URL uRL, File file, Object[] objectArray) throws IOException {
        file.createNewFile();
        InputStream inputStream = uRL.openStream();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        if (objectArray != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = null;
            byte[] byArray = ConnectionExportTask.getLineTerminator().getBytes();
            while ((string = bufferedReader.readLine()) != null) {
                string = MessageFormat.format(string, objectArray);
                fileOutputStream.write(string.getBytes());
                fileOutputStream.write(byArray);
            }
        } else {
            int n;
            byte[] byArray = new byte[4096];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        fileOutputStream.close();
        inputStream.close();
        return true;
    }

    protected boolean copyResourceFile(File file, URL uRL, String string) {
        try {
            Object[] objectArray = null;
            if ("index.html".equals(string)) {
                ConnectionExportNames[] connectionExportNamesArray;
                objectArray = this.m_nodeTypeFilter.size() > 0 ? ((connectionExportNamesArray = this.filterNameMap.get(this.m_nodeTypeFilter.get(0))).length > 0 ? new String[]{connectionExportNamesArray[0].getType().toLowerCase()} : new String[]{""}) : new String[]{""};
            }
            return this.copyFileFromJar(uRL, new File(file.getAbsolutePath() + "/" + string), objectArray);
        }
        catch (IOException iOException) {
            this.setProgressbarMsg(iOException.getMessage());
            return false;
        }
    }

    @Override
    public String getQuery() {
        return Messages.getString("ConnectionExportTask.2");
    }

    public void setFilter(DBFolderInstance[] dBFolderInstanceArray) {
        this.m_nodeTypeFilter = new ArrayList<DBFolderInstance>();
        for (DBFolderInstance dBFolderInstance : dBFolderInstanceArray) {
            this.m_nodeTypeFilter.add(dBFolderInstance);
        }
    }

    public void setFilterNames(DBFolderInstance dBFolderInstance, ConnectionExportNames[] connectionExportNamesArray) {
        this.filterNameMap.put(dBFolderInstance, connectionExportNamesArray);
    }

    public void setGenerateEmptyTypes(boolean bl) {
        this.m_generateEmptyTypes = bl;
    }

    public void setParallelism(int n) {
        this.m_parallellism = n;
    }

    class HTMLTabFormatterWorker
    implements Runnable {
        private BlockingQueue<HTMLTabFormatterWorkerRequest> requestQ;
        private String connectionName;
        private Connection connection;

        HTMLTabFormatterWorker(BlockingQueue<HTMLTabFormatterWorkerRequest> blockingQueue, Connection connection) {
            this.connection = connection;
            this.requestQ = blockingQueue;
        }

        HTMLTabFormatterWorker(BlockingQueue<HTMLTabFormatterWorkerRequest> blockingQueue, String string) {
            this.connectionName = string;
            this.requestQ = blockingQueue;
        }

        @Override
        public void run() {
            try {
                while (!ConnectionExportTask.this.cancelled && this.process(this.requestQ.take())) {
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getMessage(), exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean process(HTMLTabFormatterWorkerRequest hTMLTabFormatterWorkerRequest) {
            switch (hTMLTabFormatterWorkerRequest.type) {
                case PROCESS: {
                    try {
                        if (this.connection == null) {
                            this.connection = Connections.getInstance().cloneConnection(this.connectionName);
                        }
                        ConnectionExportTask.this.setProgressbarMsg(Messages.getString("ConnectionExportTask.3") + hTMLTabFormatterWorkerRequest.folderType + " " + hTMLTabFormatterWorkerRequest.dbo.getObjectName());
                        HTMLTabFormatter hTMLTabFormatter = new HTMLTabFormatter(hTMLTabFormatterWorkerRequest.dbo, hTMLTabFormatterWorkerRequest.models, hTMLTabFormatterWorkerRequest.bindMap, hTMLTabFormatterWorkerRequest.newDir);
                        if (hTMLTabFormatter.start(this.connection)) return true;
                        HTMLTabFormatterWorker hTMLTabFormatterWorker = this;
                        synchronized (hTMLTabFormatterWorker) {
                            ConnectionExportTask.this.errorCount++;
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getMessage(), exception);
                        HTMLTabFormatterWorker hTMLTabFormatterWorker = this;
                        synchronized (hTMLTabFormatterWorker) {
                            ConnectionExportTask.this.errorCount++;
                            return true;
                        }
                    }
                }
                case TERMINATE: {
                    return false;
                }
            }
            return false;
        }
    }

    static class HTMLTabFormatterWorkerRequest {
        Type type;
        String folderType;
        DBObject dbo;
        List<DisplayModel> models;
        Map<String, Object> bindMap;
        File newDir;

        HTMLTabFormatterWorkerRequest(String string, DBObject dBObject, List<DisplayModel> list, Map<String, Object> map, File file) {
            this.type = Type.PROCESS;
            this.folderType = string;
            this.dbo = dBObject;
            this.models = list;
            this.bindMap = map;
            this.newDir = file;
        }

        HTMLTabFormatterWorkerRequest() {
            this.type = Type.TERMINATE;
        }

        static enum Type {
            PROCESS,
            TERMINATE;

        }
    }
}

