/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.navigator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.model.AsynchronousNavigatorTreeNode;
import oracle.dbtools.raptor.onsd.OnsdBrowserResources;
import oracle.dbtools.raptor.onsd.connection.NSConnection;
import oracle.dbtools.raptor.onsd.connection.NSConnectionException;
import oracle.dbtools.raptor.onsd.connection.NSConnections;
import oracle.dbtools.raptor.onsd.connection.OnsdTask;
import oracle.dbtools.raptor.onsd.navigator.OnsdController;
import oracle.dbtools.raptor.onsd.navigator.OnsdFolder;
import oracle.dbtools.raptor.onsd.navigator.OnsdTable;
import oracle.dbtools.raptor.onsd.navigator.TableTreeNode;
import oracle.dbtools.util.Logger;
import oracle.ide.model.Element;
import oracle.kv.KVStore;
import oracle.kv.table.Table;
import oracle.kv.table.TableAPI;

public class FolderTreeNode
extends AsynchronousNavigatorTreeNode {
    @Override
    protected RaptorTask<Collection<Element>> getLoadingTask() {
        return new LoadTask((OnsdFolder)this.getElement());
    }

    private class LoadTask
    extends OnsdTask<Collection<Element>> {
        private OnsdFolder m_owner;
        private String m_cName;

        LoadTask(OnsdFolder onsdFolder) {
            super(OnsdBrowserResources.getString("TASK_ONSD_CONNECT"), true, IRaptorTaskRunMode.TASKVIEWER);
            this.m_owner = onsdFolder;
            this.m_cName = onsdFolder.getConnectionName();
        }

        @Override
        protected String getConnectionName() {
            return this.m_cName;
        }

        protected Collection<Element> doWork() throws TaskException {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            URL uRL = this.m_owner.getURL();
            if (ModelUtil.areEqual((Object)this.m_owner.getObjectType().getType(), (Object)"TABLE")) {
                try {
                    NSConnection nSConnection = NSConnections.getInstance().getConnection(this.m_cName, false);
                    KVStore kVStore = nSConnection.getStore();
                    TableAPI tableAPI = kVStore.getTableAPI();
                    Map map = tableAPI.getTables();
                    for (String string : map.keySet()) {
                        Table table = (Table)map.get(string);
                        OnsdTable onsdTable = TableTreeNode.getTableElement(table, uRL);
                        onsdTable.setConnectionName(this.m_cName);
                        arrayList.add(onsdTable);
                    }
                }
                catch (NSConnectionException nSConnectionException) {
                    Logger.warn(OnsdController.class, (Throwable)nSConnectionException);
                    throw new TaskException((Throwable)nSConnectionException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.warn(OnsdController.class, (Throwable)illegalAccessException);
                    throw new TaskException((Throwable)illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    Logger.warn(OnsdController.class, (Throwable)instantiationException);
                    throw new TaskException((Throwable)instantiationException);
                }
            }
            return arrayList;
        }
    }
}

