/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.controls.celleditor;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.Connection;
import java.text.Format;
import java.text.ParsePosition;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.celleditor.ICellEditor;
import oracle.dbtools.raptor.controls.celleditor.RaptorTableEditorJPanel;
import oracle.dbtools.raptor.controls.celleditor.RaptorTableEditorTextField;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditor;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditorFactory;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditorHandler;
import oracle.dbtools.raptor.controls.display.EditableGridInfo;
import oracle.dbtools.raptor.controls.grid.RSTableMessages;
import oracle.dbtools.raptor.navigator.net.editor.BreakoutEditorListener;
import oracle.dbtools.raptor.onsd.controls.grid.OnsdIteratorTable;
import oracle.dbtools.raptor.onsd.controls.grid.OnsdIteratorTableModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.ide.dialogs.DialogSizeKeeper;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class DefaultOnsdTableCellEditor
extends DefaultCellEditor
implements PopupCellEditorHandler {
    private Object valFrompopupEditor = null;
    private int columnDataType = -1;
    private String columnDataTypeName = null;
    private Format format = null;
    private ICellEditor iCellEditor = null;
    private JTable table = null;

    public DefaultOnsdTableCellEditor(JTable jTable) {
        super(new RaptorTableEditorTextField(jTable));
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Component component;
        this.valFrompopupEditor = null;
        this.columnDataType = -1;
        this.columnDataTypeName = null;
        this.format = null;
        this.iCellEditor = null;
        this.table = jTable;
        Component component2 = null;
        if (object != null && object.toString().indexOf("SQLDEV:") == 0 && (component = this.getDrillComponent(object, jTable)) != null) {
            return component;
        }
        component = null;
        if (jTable instanceof OnsdIteratorTable && ((OnsdIteratorTable)((Object)jTable)).getGridModel() != null) {
            RaptorTableEditorJPanel raptorTableEditorJPanel;
            PopupCellEditor popupCellEditor;
            OnsdIteratorTable onsdIteratorTable = (OnsdIteratorTable)((Object)jTable);
            OnsdIteratorTableModel onsdIteratorTableModel = onsdIteratorTable.getGridModel();
            Connection connection = null;
            boolean bl2 = onsdIteratorTable.isEditable();
            this.columnDataType = 12;
            this.columnDataTypeName = "VARCHAR";
            this.format = this.getFormat(connection, this.columnDataType);
            boolean bl3 = false;
            boolean bl4 = false;
            if (bl2) {
                bl4 = onsdIteratorTableModel.isCellEditorEditable(onsdIteratorTable.convertRowIndexToModel(n), onsdIteratorTable.convertColumnIndexToModel(n2));
                if (bl4) {
                    // empty if block
                }
                bl3 = false;
            }
            if ((popupCellEditor = null) == null && this.iCellEditor == null) {
                popupCellEditor = PopupCellEditorFactory.getPopupCellEditorForDriver("oracle.jdbc.OracleDriver", this.columnDataType, this.columnDataTypeName);
            }
            if (popupCellEditor != null) {
                popupCellEditor.setConnection(connection);
                popupCellEditor.setRowData(onsdIteratorTableModel.getRowModel(n));
                popupCellEditor.setEditable(bl4);
                if (bl4) {
                    raptorTableEditorJPanel = null;
                    popupCellEditor.setGridInfo((EditableGridInfo)((Object)raptorTableEditorJPanel));
                }
            }
            if (DataTypesUtil.isExtendedType((Object)object, (int)this.columnDataType) || DataTypesUtil.isTemporalType((Object)object, (int)this.columnDataType)) {
                this.valFrompopupEditor = object instanceof String && ((String)object).length() == 0 ? null : object;
            }
            object = component == null ? DataTypesUtil.stringValue((Object)object, connection, (int)Integer.MAX_VALUE) : component;
            raptorTableEditorJPanel = null;
            if (component2 == null) {
                final Connection connection2 = connection;
                final RaptorTableEditorTextField raptorTableEditorTextField = new RaptorTableEditorTextField((JTable)((Object)onsdIteratorTable));
                raptorTableEditorTextField.setText(object != null ? object.toString() : "");
                this.delegate = new DefaultCellEditor.EditorDelegate(){

                    @Override
                    public void setValue(Object object) {
                        String string = DataTypesUtil.stringValue((Object)object, (Connection)connection2, (int)Integer.MAX_VALUE);
                        raptorTableEditorTextField.setText(string != null ? string : "");
                    }

                    @Override
                    public Object getCellEditorValue() {
                        return raptorTableEditorTextField.getText();
                    }
                };
                raptorTableEditorTextField.addActionListener(this.delegate);
                String string = raptorTableEditorTextField.getText();
                if (string.contains("\n") || string.contains("\t") || string.contains("\r")) {
                    bl3 = false;
                }
                raptorTableEditorJPanel = new RaptorTableEditorJPanel((PopupCellEditorHandler)this, raptorTableEditorTextField, bl3, popupCellEditor);
            } else {
                raptorTableEditorJPanel = new RaptorTableEditorJPanel((PopupCellEditorHandler)this, (JComponent)component2, bl3, popupCellEditor);
            }
            component2 = raptorTableEditorJPanel;
        }
        if (component2 == null) {
            component2 = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
        return component2;
    }

    protected boolean isInPlaceEditingAllowed(int n) {
        switch (n) {
            case -13: 
            case -4: 
            case -3: 
            case -2: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2007: 
            case 2009: {
                return false;
            }
        }
        return true;
    }

    public static boolean hasExtendedEdit(int n) {
        switch (n) {
            case -13: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 12: 
            case 91: 
            case 93: 
            case 2004: 
            case 2005: 
            case 2007: 
            case 2009: {
                return true;
            }
        }
        return false;
    }

    protected Format getFormat(Connection connection, int n) {
        if (Connections.getInstance().isOracle(connection)) {
            try {
                return NLSUtils.getFormat((Connection)connection, (int)n);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        MouseEvent mouseEvent;
        return !(eventObject instanceof MouseEvent) || (mouseEvent = (MouseEvent)eventObject).getClickCount() == 2;
    }

    @Override
    public Object getCellEditorValue() {
        Object object = null;
        if (this.format != null) {
            String string = (String)super.getCellEditorValue();
            if (string != null) {
                try {
                    String string2 = this.format.format(this.valFrompopupEditor);
                    if (ModelUtil.areDifferent((Object)string, (Object)string2)) {
                        this.valFrompopupEditor = this.format.parseObject(string, new ParsePosition(0));
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
            object = this.valFrompopupEditor;
        } else {
            object = this.valFrompopupEditor != null ? this.valFrompopupEditor : (this.valFrompopupEditor != null ? this.valFrompopupEditor : (this.iCellEditor != null ? this.iCellEditor.getValue() : super.getCellEditorValue()));
        }
        return object;
    }

    public void setValue(Object object) {
        this.delegate.setValue(object);
    }

    @Override
    public void handlePopupEdit(final PopupCellEditor popupCellEditor) {
        final JComponent jComponent = popupCellEditor.getComponent();
        if (jComponent == null) {
            return;
        }
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jComponent, (Component)popupCellEditor.getDefaultComponent(), (String)(popupCellEditor.isEditable() ? ControlsArb.getString("RESULTSET_EDIT_VALUE_TITLE") : ControlsArb.getString("RESULTSET_VIEW_VALUE_TITLE")));
        String string = popupCellEditor.getHelpTopicId();
        if (!ModelUtil.hasLength((String)string)) {
            string = "f1_extendeddataedit_html";
        }
        HelpSystem.getHelpSystem().registerTopic(jComponent, string);
        jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                String string;
                if ("closed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) && (string = popupCellEditor.validateValue()) != null) {
                    MessageDialog.error((Component)jComponent, (Object)string, (String)RSTableMessages.getString("ResultSetTableCellEditor.0"), (String)popupCellEditor.getHelpTopicId());
                    throw new PropertyVetoException(RSTableMessages.getString("ResultSetTableCellEditor.1"), propertyChangeEvent);
                }
            }
        });
        jEWTDialog.setResizable(true);
        DialogSizeKeeper.attachToComponent((Component)jEWTDialog, (String)(popupCellEditor.getClass().getName() + ".dialogSize"));
        jEWTDialog.setOKButtonEnabled(popupCellEditor.isEditable());
        popupCellEditor.setValue(this.getCellEditorValue());
        popupCellEditor.setPopupDialog(jEWTDialog);
        popupCellEditor.setBreakoutEditorListener(new BreakoutEditorListener(){

            @Override
            public void save(Object object) {
                if (this.savable()) {
                    DefaultOnsdTableCellEditor.this.valFrompopupEditor = object;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            DefaultOnsdTableCellEditor.this.setValue(DefaultOnsdTableCellEditor.this.valFrompopupEditor);
                            DefaultOnsdTableCellEditor.this.stopCellEditing();
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }

            @Override
            public boolean savable() {
                int n = DefaultOnsdTableCellEditor.this.getCellEditorListeners().length;
                return n > 0;
            }
        });
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            this.valFrompopupEditor = popupCellEditor.getValue();
            this.setValue(this.valFrompopupEditor);
            this.stopCellEditing();
        } else if (!popupCellEditor.editorBrokeout()) {
            this.cancelCellEditing();
        }
        popupCellEditor.dismissPopupEditor();
        if (this.table != null) {
            this.table.requestFocusInWindow();
            this.table = null;
        }
    }

    private Component getDrillComponent(Object object, JTable jTable) {
        return null;
    }
}

