/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.dbapi;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.navigator.db.dbapi.MetadataFolder;
import oracle.dbtools.raptor.navigator.db.dbapi.MetadataInstance;
import oracle.dbtools.raptor.navigator.db.dbapi.MetadataObjectFactory;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.query.QueryProgressListener;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;

class MetadataFolderInstance
extends MetadataInstance
implements DBFolderInstance {
    MetadataFolderInstance(MetadataObjectFactory metadataObjectFactory, MetadataFolder metadataFolder) {
        super(metadataObjectFactory, metadataFolder);
    }

    public List<DBObjectInstance> getChildren(String[] stringArray, boolean bl) {
        ArrayList<DBObjectInstance> arrayList = new ArrayList<DBObjectInstance>();
        Database database = this.getDatabase();
        try {
            Schema schema = (Schema)this.getProperty("dbapi.schema");
            SchemaObject[] schemaObjectArray = database.listObjects(new String[]{this.getType()}, schema);
            if (schemaObjectArray != null) {
                for (SchemaObject schemaObject : schemaObjectArray) {
                    DBObjectInstance dBObjectInstance = this.m_factory.createNodeInstance(schemaObject.getType());
                    if (dBObjectInstance == null) continue;
                    for (String string : this.getPropertyKeys()) {
                        dBObjectInstance.setProperty(string, this.getProperty(string));
                    }
                    dBObjectInstance.setProperty("dbapi.schemaobject", schemaObject);
                    dBObjectInstance.setProperty("NAME", schemaObject.getName());
                    arrayList.add(dBObjectInstance);
                }
            }
        }
        catch (DBException dBException) {
            ExceptionHandler.handleException((Throwable)dBException);
        }
        return arrayList;
    }

    @Override
    public String getType() {
        return (String)this.getProperty("TYPE");
    }

    public List<DBChildInstance> listChildren() {
        return this.listChildren(null);
    }

    public List<DBChildInstance> listChildren(QueryProgressListener queryProgressListener) {
        ArrayList<DBChildInstance> arrayList = new ArrayList<DBChildInstance>(this.getChildren(null, false));
        return arrayList;
    }

    @Override
    public boolean isFiltered() {
        return false;
    }

    @Override
    public void clearFilter() {
    }

    @Override
    public boolean promptForFilter() {
        return false;
    }

    @Override
    public boolean canHaveFilter() {
        return false;
    }
}

