/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.value;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.ListProperty;
import oracle.dbtools.raptor.metrics.listener.DXTableChanges;
import oracle.dbtools.raptor.metrics.value.DXRow;
import oracle.dbtools.raptor.metrics.value.ItemChangeAdapter;

class TableItemChangeListAdapter<K extends Comparable>
extends ItemChangeAdapter<DXTableChanges> {
    private final ListProperty<DXRow> property;
    private final Map<K, Integer> indexMap;

    TableItemChangeListAdapter(ListProperty<DXRow<K>> listProperty) {
        this.property = listProperty;
        this.indexMap = new HashMap<K, Integer>();
    }

    @Override
    void onChange(long l, DXTableChanges dXTableChanges) {
        int n;
        for (Object object : dXTableChanges.getRemovedRowKeys()) {
            n = this.indexMap.get(object);
            this.property.remove(n);
        }
        for (DXTableChanges.Cell cell : dXTableChanges.getChangedCells()) {
            n = this.indexMap.get(cell.getRowKey());
            DXRow dXRow = (DXRow)this.property.get(n);
            dXRow.get(cell.getColumnName(), Object.class).setValue(cell.getValue());
        }
        for (DXTableChanges.Row row : dXTableChanges.getAddedRows()) {
            DXRow dXRow = new DXRow(row);
            this.indexMap.put(dXRow.getKey(), this.property.size());
            this.property.add(dXRow);
        }
        this.setAvailable();
    }
}

