/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.value;

import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.SimpleBooleanProperty;
import oracle.dbtools.raptor.metrics.listener.DXChangeEvent;
import oracle.dbtools.raptor.metrics.listener.DXError;
import oracle.dbtools.raptor.metrics.listener.DXItemBind;
import oracle.dbtools.raptor.metrics.listener.DXItemListener;
import oracle.dbtools.raptor.metrics.listener.DXJobEvent;
import oracle.dbtools.raptor.metrics.listener.DXUnbind;

abstract class ItemChangeAdapter<T>
implements DXItemListener<T> {
    private final SimpleBooleanProperty available = new SimpleBooleanProperty();

    ItemChangeAdapter() {
    }

    BooleanExpression isAvailable() {
        return this.available;
    }

    abstract void onChange(long var1, T var3);

    void setAvailable() {
        this.available.set(true);
    }

    @Override
    public void onChange(DXChangeEvent<T> dXChangeEvent) {
        Platform.runLater(() -> {
            try {
                this.onChange(dXChangeEvent.getTStamp(), dXChangeEvent.getChange());
            }
            catch (RuntimeException runtimeException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "error thrown by metrics event handler", runtimeException);
            }
        });
    }

    @Override
    public void onJobEnd(DXJobEvent dXJobEvent) {
    }

    @Override
    public void onBind(DXItemBind dXItemBind) {
    }

    @Override
    public void onBindError(DXError dXError) {
        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "error binding '" + dXError.getId() + "'", dXError.getException());
    }

    @Override
    public void onUnbind(DXUnbind dXUnbind) {
    }
}

