/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TableColumn;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.listener.DXSource;
import oracle.dbtools.raptor.metrics.ui.CacheElement;
import oracle.dbtools.raptor.metrics.ui.CacheElementLookup;
import oracle.dbtools.raptor.metrics.ui.SourceElement;

class ConnectionElement
extends CacheElement {
    private final StringProperty connectionDisplayNameProperty;
    private final StringProperty connectionTypeNameProperty;

    ConnectionElement(CacheElementLookup cacheElementLookup, URI uRI, String string) {
        super(cacheElementLookup, uRI);
        this.connectionDisplayNameProperty = new SimpleStringProperty(string);
        this.connectionTypeNameProperty = new SimpleStringProperty(DXIds.getConnectionTypeName(this.getId()));
    }

    void addSource(URI uRI, DXSource dXSource) {
        this.addChildElement(new SourceElement(this.getLookup(), uRI, dXSource));
    }

    StringProperty connectionDisplayNameProperty() {
        return this.connectionDisplayNameProperty;
    }

    StringProperty connectionTypeNameProperty() {
        return this.connectionTypeNameProperty;
    }

    @Override
    List<TableColumn<? extends CacheElement, String>> getTableColumns() {
        ArrayList<TableColumn<? extends CacheElement, String>> arrayList = new ArrayList<TableColumn<? extends CacheElement, String>>();
        arrayList.add(this.createTableLeadColumn(MetricsResources.get("METRICS_UI_SOURCE_PATH"), cellDataFeatures -> ((SourceElement)cellDataFeatures.getValue()).pathProperty()));
        arrayList.add(this.createTableColumn(MetricsResources.get("METRICS_UI_CONNECTED"), cellDataFeatures -> ((SourceElement)cellDataFeatures.getValue()).connectedProperty().asString()));
        arrayList.add(this.createTableColumn(MetricsResources.get("METRICS_UI_INTERVAL"), cellDataFeatures -> ((SourceElement)cellDataFeatures.getValue()).minimumIntervalProperty().asString()));
        arrayList.add(this.createTableColumn(MetricsResources.get("METRICS_UI_CONNECTION_EXCEPTION"), cellDataFeatures -> ((SourceElement)cellDataFeatures.getValue()).lastConnectionAttemptExceptionProperty()));
        return arrayList;
    }

    @Override
    String getIconPath() {
        return "/oracle/dbtools/raptor/images/db.png";
    }

    public String toString() {
        return (String)this.connectionDisplayNameProperty.get();
    }
}

