/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.engine.Engine;
import oracle.dbtools.raptor.metrics.engine.EngineNotification;
import oracle.dbtools.raptor.metrics.engine.ItemType;
import oracle.dbtools.raptor.metrics.engine.Job;
import oracle.dbtools.raptor.metrics.engine.Source;
import oracle.dbtools.raptor.metrics.listener.DXChangeEvent;
import oracle.dbtools.raptor.metrics.listener.DXEngineListener;
import oracle.dbtools.raptor.metrics.listener.DXEvent;
import oracle.dbtools.raptor.metrics.listener.DXItemListener;
import oracle.dbtools.raptor.metrics.listener.DXItemUpdate;
import oracle.dbtools.raptor.metrics.listener.DXJobEvent;

public abstract class Item {
    private URI itemId;
    private final Job job;
    private final Set<DXItemListener<?>> itemListeners;
    private boolean changed;
    protected static final Logger logger = Logger.getLogger(Item.class.getName());

    protected Item(Job job) {
        this.job = job;
        this.itemListeners = new HashSet();
    }

    public abstract ItemType getItemType();

    public URI getItemId() {
        assert (Engine.isMetricsThread());
        if (this.itemId == null) {
            Source source = this.job.getSource();
            this.itemId = DXIds.newId(source.getSourceId(), this.getItemType().getItemPath());
        }
        return this.itemId;
    }

    public Job getJob() {
        return this.job;
    }

    protected abstract Object getChangeObject();

    protected Object getIncrementalChangeObject() {
        return this.getChangeObject();
    }

    protected abstract void update(Map<String, List<?>> var1);

    protected void markChanged() {
        assert (Engine.isMetricsThread());
        this.changed = true;
    }

    boolean isPinned() {
        return this.itemListeners.size() > 0;
    }

    boolean addItemListener(Engine engine, DXItemListener<?> dXItemListener) {
        assert (Engine.isMetricsThread());
        this.itemListeners.add(dXItemListener);
        if (this.itemListeners.size() == 1) {
            engine.addEvent(this.job.createItemPinned());
            engine.addNotification(new EngineNotification<DXItemUpdate>(engine){

                @Override
                DXItemUpdate createEvent() {
                    return this.createItemUpdateEvent(DXEvent.Type.ITEM_PIN, Item.this);
                }

                @Override
                void callListener(DXEngineListener dXEngineListener, DXItemUpdate dXItemUpdate) {
                    dXEngineListener.onPin(dXItemUpdate);
                }
            });
        }
        return this.job.hasRunAtLeastOnce();
    }

    boolean removeItemListener(Engine engine, DXItemListener<?> dXItemListener) {
        assert (Engine.isMetricsThread());
        boolean bl = this.itemListeners.remove(dXItemListener);
        if (bl && this.itemListeners.isEmpty()) {
            engine.addEvent(this.job.createItemUnpinned());
            engine.addNotification(new EngineNotification<DXItemUpdate>(engine){

                @Override
                DXItemUpdate createEvent() {
                    return this.createItemUpdateEvent(DXEvent.Type.ITEM_UNPIN, Item.this);
                }

                @Override
                void callListener(DXEngineListener dXEngineListener, DXItemUpdate dXItemUpdate) {
                    dXEngineListener.onPin(dXItemUpdate);
                }
            });
        }
        return bl;
    }

    void notifyChange() {
        assert (Engine.isMetricsThread());
        if (this.itemListeners.size() > 0) {
            URI uRI = this.getItemId();
            DXChangeEvent<Object> dXChangeEvent = null;
            if (this.changed) {
                dXChangeEvent = new DXChangeEvent<Object>(DXEvent.Type.VALUE_CHANGE, uRI, this.getIncrementalChangeObject());
            }
            DXJobEvent dXJobEvent = new DXJobEvent(DXEvent.Type.JOB_END, uRI);
            for (DXItemListener<?> dXItemListener : this.itemListeners) {
                if (this.changed) {
                    try {
                        dXItemListener.onChange(dXChangeEvent);
                    }
                    catch (RuntimeException runtimeException) {
                        logger.log(Level.WARNING, "Listener threw exception: " + dXItemListener, runtimeException);
                    }
                }
                try {
                    dXItemListener.onJobEnd(dXJobEvent);
                }
                catch (RuntimeException runtimeException) {
                    logger.log(Level.WARNING, "Listener threw exception: " + dXItemListener, runtimeException);
                }
            }
        }
        this.changed = false;
    }
}

