/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.models;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.extract.ExtractResources;

public class ExtractScript {
    public static final int EXEC_BEFORE_CREATE = 110;
    public static final int EXEC_AFTER_CREATE = 111;
    public static final int EXEC_BEFORE_LOAD = 112;
    public static final int EXEC_AFTER_LOAD = 113;
    public static final int EXEC_INITIAL = 114;
    public static final int EXEC_FINAL = 115;
    public static final String TYPE_BEFORE_CREATE = "BEFORE_CREATE";
    public static final String TYPE_AFTER_CREATE = "AFTER_CREATE";
    public static final String TYPE_BEFORE_LOAD = "BEFORE_LOAD";
    public static final String TYPE_AFTER_LOAD = "AFTER_LOAD";
    public static final String TYPE_INITIAL = "INITIAL";
    public static final String TYPE_FINAL = "FINAL";
    private static final HashMap<String, Integer> XML_IDS = new HashMap(4);
    public static final String BEFORE_CREATE_NAME;
    public static final String AFTER_CREATE_NAME;
    public static final String BEFORE_LOAD_NAME;
    public static final String AFTER_LOAD_NAME;
    public static final String INITIAL_NAME;
    public static final String FINAL_NAME;
    private int _executeWhen = 110;
    private String _path;
    private String _encoding;
    private boolean _isSelectedFile = false;

    public ExtractScript(String string, String string2, int n, boolean bl) {
        this._path = string;
        this._encoding = string2;
        this._executeWhen = n;
        this._isSelectedFile = bl;
    }

    public void setExecuteWhen(int n) {
        this._executeWhen = n;
    }

    public int getExecuteWhen() {
        return this._executeWhen;
    }

    public void isSelectedFile(boolean bl) {
        this._isSelectedFile = bl;
    }

    public boolean isSelectedFile() {
        return this._isSelectedFile;
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String string) {
        this._path = string;
    }

    public URL getUrl() {
        try {
            return new File(this._path).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, malformedURLException.getStackTrace()[0].toString(), malformedURLException);
            return null;
        }
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String string) {
        this._encoding = string;
    }

    public ExtractScript clone() {
        ExtractScript extractScript = new ExtractScript(this._path, this._encoding, this._executeWhen, this._isSelectedFile);
        return extractScript;
    }

    public String getIndent(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 9;
        }
        return new String(cArray);
    }

    public String toXML(int n) {
        return this.toXML(new StringBuffer(), n).toString();
    }

    public StringBuffer toXML(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.getIndent(n) + "<script");
        stringBuffer.append(">\n");
        stringBuffer.append(this.getIndent(n + 1) + "<execWhen><![CDATA[" + this.getType() + "]]></execWhen>\n");
        stringBuffer.append(this.getIndent(n + 1) + "<fileurl><![CDATA[" + this.getUrl() + "]]></fileurl>\n");
        stringBuffer.append(this.getIndent(n + 1) + "<encoding><![CDATA[" + this._encoding + "]]></encoding>\n");
        if (this._isSelectedFile) {
            stringBuffer.append(this.getIndent(n + 1) + "<includefile><![CDATA[" + "true" + "]]></includefile>\n");
        } else {
            stringBuffer.append(this.getIndent(n + 1) + "<includefile><![CDATA[" + "false" + "]]></includefile>\n");
        }
        stringBuffer.append(this.getIndent(n) + "</script>\n");
        return stringBuffer;
    }

    public String getName() {
        switch (this._executeWhen) {
            case 110: {
                return BEFORE_CREATE_NAME;
            }
            case 111: {
                return AFTER_CREATE_NAME;
            }
            case 112: {
                return BEFORE_LOAD_NAME;
            }
            case 113: {
                return AFTER_LOAD_NAME;
            }
            case 114: {
                return INITIAL_NAME;
            }
            case 115: {
                return FINAL_NAME;
            }
        }
        return "";
    }

    public String getType() {
        switch (this._executeWhen) {
            case 110: {
                return TYPE_BEFORE_CREATE;
            }
            case 111: {
                return TYPE_AFTER_CREATE;
            }
            case 112: {
                return TYPE_BEFORE_LOAD;
            }
            case 113: {
                return TYPE_AFTER_LOAD;
            }
            case 114: {
                return TYPE_INITIAL;
            }
            case 115: {
                return TYPE_FINAL;
            }
        }
        return "";
    }

    public static int getExecuteWhen(String string) {
        return XML_IDS.get(string);
    }

    static {
        XML_IDS.put(TYPE_BEFORE_CREATE, 110);
        XML_IDS.put(TYPE_AFTER_CREATE, 111);
        XML_IDS.put(TYPE_BEFORE_LOAD, 112);
        XML_IDS.put(TYPE_AFTER_LOAD, 113);
        XML_IDS.put(TYPE_INITIAL, 114);
        XML_IDS.put(TYPE_FINAL, 115);
        BEFORE_CREATE_NAME = ExtractResources.getString("BEFORE_CREATE_SCRIPT");
        AFTER_CREATE_NAME = ExtractResources.getString("AFTER_CREATE_SCRIPT");
        BEFORE_LOAD_NAME = ExtractResources.getString("BEFORE_LOAD_SCRIPT");
        AFTER_LOAD_NAME = ExtractResources.getString("AFTER_LOAD_SCRIPT");
        INITIAL_NAME = ExtractResources.getString("INITIAL_SCRIPT");
        FINAL_NAME = ExtractResources.getString("FINAL_SCRIPT");
    }

    public static enum xmlIds {
        xmlIdPreCreate,
        xmlIdPostCreate,
        xmlIdPreLoad,
        xmlIdPostLoad;

    }
}

