/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.actions;

import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.proformatter.SQLFormatter;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleManager;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleSQLOptions;
import oracle.dbtools.raptor.RaptorDBAddin;
import oracle.dbtools.raptor.dialogs.Messages;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class GenerateTAPIAction
extends AbstractMenuAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launch() {
        DBObject dBObject = this.getDBObject();
        String string = dBObject.getObjectName();
        String string2 = dBObject.getSchemaName();
        ResultSet resultSet = null;
        Connection connection = dBObject.getConnection();
        if (connection == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OBJECT_OWNER", string2);
        hashMap.put("OBJECT_NAME", string);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        if (!Connections.getInstance().lock(connection)) {
            return;
        }
        try {
            resultSet = DBUtil.getInstance((Connection)connection).executeQuery("select * from all_tab_columns \nwhere owner = :OBJECT_OWNER \nand table_name = :OBJECT_NAME \n", hashMap);
            while (resultSet.next()) {
                hashMap2.put(resultSet.getString("COLUMN_NAME"), resultSet.getString("NULLABLE"));
            }
        }
        catch (Exception exception) {
            try {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(connection);
                throw throwable;
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
        Connections.getInstance().unlock(connection);
        if (!Connections.getInstance().lock(connection)) {
            return;
        }
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            resultSet = DBUtil.getInstance((Connection)connection).executeQuery("SELECT cols.column_name column_name\nFROM (select constraint_name from all_constraints \nWHERE constraint_type in ('U','P')\nand owner = :OBJECT_OWNER\nand table_name = :OBJECT_NAME\nand rownum = 1\n) cons, all_cons_columns cols\nWHERE cons.constraint_name = cols.constraint_name\nand cols.owner = :OBJECT_OWNER\nand cols.table_name = :OBJECT_NAME\nand cols.constraint_name = cons.constraint_name\nORDER BY cols.position\n", hashMap);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("COLUMN_NAME"));
            }
            if (arrayList.size() == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString((String)"GenerateTAPIAction.MissingKey"), null, null);
                return;
            }
            String string3 = this.generatePkg(string, hashMap2, arrayList) + "\n/\n" + this.generateBody(string, hashMap2, arrayList);
            SQLFormatter.getInstance();
            CodingStyleSQLOptions codingStyleSQLOptions = CodingStyleManager.getCodingStyleManager().getCodingStyleSQLOptions();
            string3 = codingStyleSQLOptions.format(string3);
            RaptorDBAddin.getSqlOpener().openNewEditor(string3, dBObject.getConnectionName());
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
    }

    private String generatePkg(String string, Map<String, String> map, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("create or replace package " + string + "_tapi\n");
        stringBuilder.append("is\n\n");
        stringBuilder.append("type " + string + "_tapi_rec is record (\n");
        int n = -1;
        for (String string2 : map.keySet()) {
            stringBuilder.append((++n == 0 ? "" : ",") + string2 + "  " + string + "." + string2 + "%type\n");
        }
        stringBuilder.append(");\n");
        stringBuilder.append("type " + string + "_tapi_tab is table of " + string + "_tapi_rec;\n\n");
        stringBuilder.append("-- insert\n");
        stringBuilder.append("procedure ins (\n");
        this.argList(string, map, stringBuilder, true, true);
        stringBuilder.append(");\n");
        stringBuilder.append("-- update\n");
        stringBuilder.append("procedure upd (\n");
        this.argList(string, map, stringBuilder, true, true);
        stringBuilder.append(");\n");
        stringBuilder.append("-- delete\n");
        stringBuilder.append("procedure del (\n");
        n = -1;
        for (String string2 : list) {
            stringBuilder.append((++n == 0 ? "" : ",") + "p_" + string2 + " in " + string + "." + string2 + "%type\n");
        }
        stringBuilder.append(");\n");
        stringBuilder.append("end " + string + "_tapi;\n");
        return stringBuilder.toString();
    }

    private String generateBody(String string, Map<String, String> map, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("create or replace package body " + string + "_tapi\n");
        stringBuilder.append("is\n");
        stringBuilder.append("-- insert\n");
        stringBuilder.append("procedure ins (\n");
        this.argList(string, map, stringBuilder, true, true);
        stringBuilder.append(") is\n");
        stringBuilder.append("begin\n");
        stringBuilder.append("insert into " + string + "(\n");
        this.argList(string, map, stringBuilder, false, false);
        stringBuilder.append(") values (\n");
        this.argList(string, map, stringBuilder, false, true);
        stringBuilder.append(");");
        stringBuilder.append("end;\n");
        stringBuilder.append("-- update\n");
        stringBuilder.append("procedure upd (\n");
        this.argList(string, map, stringBuilder, true, true);
        stringBuilder.append(") is\n");
        stringBuilder.append("begin\n");
        stringBuilder.append("update " + string + " set\n");
        this.assignments(map, list, stringBuilder);
        stringBuilder.append("where ");
        this.where(list, stringBuilder);
        stringBuilder.append(";\n");
        stringBuilder.append("end;\n");
        stringBuilder.append("-- del\n");
        stringBuilder.append("procedure del (\n");
        int n = -1;
        for (String string2 : list) {
            stringBuilder.append((++n == 0 ? "" : ",") + "p_" + string2 + " in " + string + "." + string2 + "%type\n");
        }
        stringBuilder.append(") is\n");
        stringBuilder.append("begin\n");
        stringBuilder.append("delete from " + string + "\n");
        stringBuilder.append("where ");
        this.where(list, stringBuilder);
        stringBuilder.append(";\n");
        stringBuilder.append("end;\n");
        stringBuilder.append("end " + string + "_tapi;\n");
        return stringBuilder.toString();
    }

    private void argList(String string, Map<String, String> map, StringBuilder stringBuilder, boolean bl, boolean bl2) {
        int n = -1;
        for (String string2 : map.keySet()) {
            if (++n > 0) {
                stringBuilder.append(",");
            }
            if (bl2) {
                stringBuilder.append("p_");
            }
            stringBuilder.append(string2);
            if (bl) {
                stringBuilder.append(" in " + string + "." + string2 + "%type");
            }
            if ("Y".equals(map.get(string2)) && bl) {
                stringBuilder.append(" default null ");
            }
            stringBuilder.append("\n");
        }
    }

    private void assignments(Map<String, String> map, List<String> list, StringBuilder stringBuilder) {
        int n = -1;
        for (String string : map.keySet()) {
            if (list.contains(string)) continue;
            if (++n > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
            stringBuilder.append(" = p_");
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
    }

    private void where(List<String> list, StringBuilder stringBuilder) {
        int n = -1;
        for (String string : list) {
            if (++n > 0) {
                stringBuilder.append(" and ");
            }
            stringBuilder.append(string);
            stringBuilder.append(" = p_");
            stringBuilder.append(string);
        }
    }
}

