/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.ddl.IObjectDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleApex;
import oracle.dbtools.raptor.ddl.oracle.OracleApexPage;
import oracle.dbtools.raptor.ddl.oracle.OracleConstraintDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleConsumerGroupDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleContainerRMPlanDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleDataDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleDataFileDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleDbLinkDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleFunctionDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleIndexDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleMatViewDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleMatViewLogDDL;
import oracle.dbtools.raptor.ddl.oracle.OraclePackageBodyDDL;
import oracle.dbtools.raptor.ddl.oracle.OraclePackageDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleProcedureDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleProfileDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleQueueDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleQueueTableDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleRedoLogGroupDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleRefConstraintDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleResourceManagerPlanDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleRoleDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleRollbackSegmentDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleSequenceDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleSynonymnDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleTableDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleTableSpaceDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleTempTabGroupDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleTriggerDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleTypeDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleUserDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleViewDDL;
import oracle.dbtools.raptor.utils.DBObject;

public class DDLRegistry {
    private static Map<String, Class<? extends IObjectDDL>> _registry = new HashMap<String, Class<? extends IObjectDDL>>();

    public static synchronized ArrayList<String> getTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : _registry.keySet()) {
            String[] stringArray = string.split("#");
            arrayList.add(stringArray[1]);
        }
        return arrayList;
    }

    public static synchronized void registerHandler(String string, String string2, Class<? extends IObjectDDL> clazz) {
        if (!IObjectDDL.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class must be instance of IDdlGenerator");
        }
        _registry.put(DBObject.getKey(string, string2), clazz);
    }

    public static synchronized void unregisterHandler(String string) {
        _registry.remove(string);
    }

    public static synchronized IObjectDDL getInstanceFor(String string) {
        if (_registry.get(string) != null) {
            try {
                return _registry.get(string).newInstance();
            }
            catch (Exception exception) {
                Logger.getLogger(DDLRegistry.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                return null;
            }
        }
        return null;
    }

    public static synchronized boolean isSupported(String string) {
        if (_registry.get(string) != null) {
            return true;
        }
        String string2 = string.replace(" ", "_");
        return _registry.get(string2) != null;
    }

    static {
        DDLRegistry.registerHandler("Oracle", "TABLE", OracleTableDDL.class);
        DDLRegistry.registerHandler("Oracle", "CONSTRAINT", OracleConstraintDDL.class);
        DDLRegistry.registerHandler("Oracle", "REFCONSTRAINT", OracleRefConstraintDDL.class);
        DDLRegistry.registerHandler("Oracle", "INDEX", OracleIndexDDL.class);
        DDLRegistry.registerHandler("Oracle", "TRIGGER", OracleTriggerDDL.class);
        DDLRegistry.registerHandler("Oracle", "MATERIALIZED_VIEW", OracleMatViewDDL.class);
        DDLRegistry.registerHandler("Oracle", "MATERIALIZED_VIEW_LOG", OracleMatViewLogDDL.class);
        DDLRegistry.registerHandler("Oracle", "VIEW", OracleViewDDL.class);
        DDLRegistry.registerHandler("Oracle", "FUNCTION", OracleFunctionDDL.class);
        DDLRegistry.registerHandler("Oracle", "PACKAGE", OraclePackageDDL.class);
        DDLRegistry.registerHandler("Oracle", "PACKAGE_BODY", OraclePackageBodyDDL.class);
        DDLRegistry.registerHandler("Oracle", "PACKAGE BODY", OraclePackageBodyDDL.class);
        DDLRegistry.registerHandler("Oracle", "PROCEDURE", OracleProcedureDDL.class);
        DDLRegistry.registerHandler("Oracle", "DATABASE_LINK", OracleDbLinkDDL.class);
        DDLRegistry.registerHandler("Oracle", "SEQUENCE", OracleSequenceDDL.class);
        DDLRegistry.registerHandler("Oracle", "TYPE", OracleTypeDDL.class);
        DDLRegistry.registerHandler("Oracle", "SYNONYM", OracleSynonymnDDL.class);
        DDLRegistry.registerHandler("Oracle", "DATA", OracleDataDDL.class);
        DDLRegistry.registerHandler("Oracle", "APEX", OracleApex.class);
        DDLRegistry.registerHandler("Oracle", "APEX_PAGE", OracleApexPage.class);
        DDLRegistry.registerHandler("Oracle", "QUEUE_TABLE", OracleQueueTableDDL.class);
        DDLRegistry.registerHandler("Oracle", "QUEUE", OracleQueueDDL.class);
        DDLRegistry.registerHandler("Oracle_DBA", "TABLESPACE", OracleTableSpaceDDL.class);
        DDLRegistry.registerHandler("Oracle_DBA", "DATAFILE", OracleDataFileDDL.class);
        DDLRegistry.registerHandler("Oracle_DBA", "REDOLOGGROUP", OracleRedoLogGroupDDL.class);
        DDLRegistry.registerHandler("Oracle_DBA", "ROLLBACK_SEGMENT", OracleRollbackSegmentDDL.class);
        DDLRegistry.registerHandler("Oracle_DBA", "USER", OracleUserDDL.class);
        DDLRegistry.registerHandler("Oracle_DBA", "ROLE", OracleRoleDDL.class);
        DDLRegistry.registerHandler("Oracle_DBA", "PROFILE", OracleProfileDDL.class);
        DDLRegistry.registerHandler("Oracle_DBA", "RESOURCEMANAGERPLAN", OracleResourceManagerPlanDDL.class);
        DDLRegistry.registerHandler("Oracle_DBA", "CONTAINERRMPLAN", OracleContainerRMPlanDDL.class);
        DDLRegistry.registerHandler("Oracle_DBA", "CONSUMERGROUP", OracleConsumerGroupDDL.class);
        DDLRegistry.registerHandler("Oracle_DBA", "TT_GROUPS", OracleTempTabGroupDDL.class);
    }
}

