/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLMetaObject;
import oracle.dbtools.raptor.ddl.DDLRegistry;
import oracle.dbtools.raptor.ddl.DDLResources;
import oracle.dbtools.raptor.ddl.IObjectDDL;
import oracle.dbtools.raptor.ddl.Messages;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.util.IdeUtil;

public class DDLGenerator {
    private static final Object LOCK = new Object();
    private static DDLGenerator _generator;
    DDLFormat _format;
    Writer _out = null;
    String _file = null;
    String _enc = null;
    ArrayList<DDLMetaObject> _objects = new ArrayList();

    private DDLGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DDLGenerator getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_generator == null) {
                _generator = new DDLGenerator();
            }
        }
        return _generator;
    }

    public void setFormating(DDLFormat dDLFormat) {
        this._format = dDLFormat;
    }

    public DDLFormat getFormating() {
        return this._format;
    }

    public void setFile(String string, String string2) {
        this._file = string;
        this._enc = string2 != null ? string2 : IdeUtil.getIdeEncoding();
    }

    public boolean openFile() throws Exception {
        if (this._file == null || this._enc == null) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, Messages.getString("DDLGenerator.0"));
            return false;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this._file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        this._out = new OutputStreamWriter((OutputStream)bufferedOutputStream, this._enc);
        return true;
    }

    public void closeFile() throws IOException {
        this._out.flush();
        this._out.close();
    }

    private void checkFormat() {
        if (this._format == null) {
            this._format = new DDLFormat();
        }
    }

    public void setWriter(Writer writer) {
        this._out = writer;
    }

    public Writer getWriter() {
        return this._out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DBObject> getSchemaObjects(Connection connection, String string, String string2, String string3) {
        if (Connections.getInstance().lock(connection)) {
            try {
                ArrayList<DBObject> arrayList = DDLRegistry.getInstanceFor(string3).getSchemaObjects(connection, string, string2);
                return arrayList;
            }
            catch (Exception exception) {
                ArrayList<DBObject> arrayList = null;
                return arrayList;
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return null;
    }

    public String getGrants(DBObject dBObject) throws Exception {
        try {
            this.checkFormat();
            IObjectDDL iObjectDDL = this.getRegistry(dBObject);
            return iObjectDDL != null ? iObjectDDL.getGrantsDDL(dBObject) : this.getDDLNotAvailable(dBObject);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "getGrantsDDL - " + exception.getMessage());
            throw exception;
        }
    }

    public String getDDL(DBObject dBObject) throws Exception {
        try {
            this.checkFormat();
            IObjectDDL iObjectDDL = this.getRegistry(dBObject);
            return iObjectDDL != null ? iObjectDDL.getDDL(dBObject) : this.getDDLNotAvailable(dBObject);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "getDDL - " + exception.getMessage());
            throw exception;
        }
    }

    public String getDDL(DBObject dBObject, String string) throws Exception {
        try {
            this.checkFormat();
            IObjectDDL iObjectDDL = this.getRegistry(dBObject);
            return iObjectDDL != null ? iObjectDDL.getDDL(dBObject, string) : this.getDDLNotAvailable(dBObject);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "getDDL - " + exception.getMessage());
            throw exception;
        }
    }

    private IObjectDDL getRegistry(DBObject dBObject) {
        String string = this.getKey(dBObject);
        IObjectDDL iObjectDDL = DDLRegistry.getInstanceFor(string);
        return iObjectDDL;
    }

    private String getDDLNotAvailable(DBObject dBObject) {
        return DDLResources.format("DDL_NOT_AVAIL", Connections.getDisplayName(dBObject.getConnectionName()), dBObject.getSchemaName(), dBObject.getObjectType(), dBObject.getObjectName());
    }

    private String getKey(DBObject dBObject) {
        String string = dBObject.getKey().replace(" ", "_");
        if ("Oracle#PUBLIC_SYNONYM".equals(string)) {
            string = "Oracle#SYNONYM";
        } else if ("Oracle#PUBLIC_DATABASE_LINK".equals(string)) {
            string = "Oracle#DATABASE_LINK";
        }
        return string;
    }

    public String getCopyDDL(DBObject dBObject) throws Exception {
        try {
            this.checkFormat();
            IObjectDDL iObjectDDL = this.getRegistry(dBObject);
            return iObjectDDL != null ? iObjectDDL.getCopyDDL(dBObject) : this.getDDLNotAvailable(dBObject);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "getDDL - " + exception.getMessage());
            throw exception;
        }
    }

    public String getScriptDDL(DBObject dBObject) throws Exception {
        try {
            this.checkFormat();
            IObjectDDL iObjectDDL = this.getRegistry(dBObject);
            return iObjectDDL != null ? iObjectDDL.getScriptDDL(dBObject) : this.getDDLNotAvailable(dBObject);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "getDDL - " + exception.getMessage());
            throw exception;
        }
    }
}

