/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.ui.cell;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.StructureType;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.ui.DataValueUtils;
import oracle.dbtools.raptor.datatypes.ui.cell.BaseCustomCellEditor;
import oracle.dbtools.raptor.datatypes.ui.cell.NoEditCellEditor;
import oracle.dbtools.raptor.datatypes.ui.control.JTreeTable;
import oracle.dbtools.raptor.datatypes.ui.model.CompositeTypeTableModel;
import oracle.dbtools.raptor.datatypes.values.NamedDataValue;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.javatools.icons.OracleIcons;

public class CompositeTypeCustomCellEditor
extends BaseCustomCellEditor {
    protected CompositeTypeEditPanel customEditorComponent;

    public CompositeTypeCustomCellEditor() {
        super(new NoEditCellEditor());
    }

    @Override
    public void configure(DataType dataType) {
        this.customEditorComponent = new CompositeTypeEditPanel(dataType.getSqlDataType(ValueType.DEFAULT), dataType);
        super.configure(dataType);
    }

    @Override
    protected JComponent getCustomEditorComponent() {
        return this.customEditorComponent;
    }

    @Override
    protected JComponent getCustomEditorFocusComponent() {
        return this.customEditorComponent;
    }

    @Override
    protected Object getCustomEditorValue() {
        return this.customEditorComponent.getValue();
    }

    @Override
    protected void setCustomEditorValue(Object object) {
        this.customEditorComponent.setValue(object);
    }

    protected class CompositeTypeEditPanel
    extends JPanel {
        protected JTreeTable treetable;
        protected CompositeTypeTableModel model;
        protected int sqlType;
        protected Object descriptor;
        protected boolean editable;
        protected JPopupMenu popupMenu;
        protected JMenuItem addItem;
        protected JMenuItem deleteItem;
        protected JMenuItem insertItem;
        protected JMenuItem dupItem;

        public CompositeTypeEditPanel(int n, Object object) {
            JComponent jComponent;
            this.model = new CompositeTypeTableModel((DataType)object);
            this.sqlType = n;
            this.descriptor = object;
            this.editable = true;
            this.popupMenu = new JPopupMenu();
            this.addItem = new JMenuItem(StringUtils.stripMnemonic((String)ControlsArb.getString("BUTTON_ADD")), StringUtils.getMnemonicKeyCode((String)ControlsArb.getString("BUTTON_ADD")));
            this.addItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CompositeTypeEditPanel.this.model.addElement(CompositeTypeEditPanel.this.treetable.getTree().getSelectionPath().getLastPathComponent());
                }
            });
            this.popupMenu.add(this.addItem);
            this.insertItem = new JMenuItem(StringUtils.stripMnemonic((String)ControlsArb.getString("BUTTON_INSERT")), StringUtils.getMnemonicKeyCode((String)ControlsArb.getString("BUTTON_INSERT")));
            this.insertItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TreePath[] treePathArray = CompositeTypeEditPanel.this.treetable.getTree().getSelectionPaths();
                    Object object = null;
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (TreePath treePath : treePathArray) {
                        if (object == null) {
                            object = treePath.getParentPath().getLastPathComponent();
                        }
                        arrayList.add(treePath.getLastPathComponent());
                    }
                    if (object != null) {
                        CompositeTypeEditPanel.this.model.insertElements(object, arrayList);
                    }
                }
            });
            this.popupMenu.add(this.insertItem);
            this.dupItem = new JMenuItem(StringUtils.stripMnemonic((String)ControlsArb.getString("BUTTON_DUPLICATE")), StringUtils.getMnemonicKeyCode((String)ControlsArb.getString("BUTTON_DUPLICATE")));
            this.dupItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TreePath[] treePathArray = CompositeTypeEditPanel.this.treetable.getTree().getSelectionPaths();
                    Object object = null;
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (TreePath treePath : treePathArray) {
                        if (object == null) {
                            object = treePath.getParentPath().getLastPathComponent();
                        }
                        arrayList.add(treePath.getLastPathComponent());
                    }
                    if (object != null) {
                        CompositeTypeEditPanel.this.model.dupElements(object, arrayList);
                    }
                }
            });
            this.popupMenu.add(this.dupItem);
            this.deleteItem = new JMenuItem(StringUtils.stripMnemonic((String)ControlsArb.getString("BUTTON_DELETE")), StringUtils.getMnemonicKeyCode((String)ControlsArb.getString("BUTTON_DELETE")));
            this.deleteItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TreePath[] treePathArray = CompositeTypeEditPanel.this.treetable.getTree().getSelectionPaths();
                    Object object = null;
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (TreePath treePath : treePathArray) {
                        if (object == null) {
                            object = treePath.getParentPath().getLastPathComponent();
                        }
                        arrayList.add(treePath.getLastPathComponent());
                    }
                    if (object != null) {
                        CompositeTypeEditPanel.this.model.removeElements(object, arrayList);
                    }
                }
            });
            this.popupMenu.add(this.deleteItem);
            this.treetable = new JTreeTable(this.model){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    return this.getPreferredSize();
                }

                @Override
                public TableCellEditor getCellEditor(int n, int n2) {
                    DataType dataType;
                    if (n2 == 1 && (dataType = (DataType)this.getValueAt(n, 2)) != null) {
                        boolean bl = dataType.getStructureType() != StructureType.PRIMITIVE;
                        LinkedList<DataValue> linkedList = new LinkedList<DataValue>();
                        List<DataValue> list = this.getChoices(n, n2);
                        linkedList.addAll(list);
                        DataValue dataValue = dataType.getDataValue(this.getValueAt(n, n2));
                        Properties properties = new Properties();
                        properties.setProperty("BaseCustomCellEditor.DISABLE_EDIT_BUTTON", "" + bl);
                        return DataValueUtils.getTableCellEditor(dataValue, list, properties);
                    }
                    return super.getCellEditor(n, n2);
                }

                @Override
                public TableCellRenderer getCellRenderer(int n, int n2) {
                    DataType dataType;
                    if (n2 == 0) {
                        return super.getCellRenderer(n, n2);
                    }
                    if (n2 == 1 && (dataType = (DataType)this.getValueAt(n, 2)) != null) {
                        DataValue dataValue = dataType.getDataValue(this.getValueAt(n, n2));
                        return DataValueUtils.getTableCellRenderer(dataValue);
                    }
                    return new DefaultTableCellRenderer();
                }

                private List<DataValue> getChoices(int n, int n2) {
                    DataValue dataValue;
                    DataType dataType = (DataType)this.getValueAt(n, 2);
                    String string = (String)this.getValueAt(n, 0);
                    LinkedList<DataValue> linkedList = new LinkedList<DataValue>();
                    if (dataType.isEnumeration()) {
                        dataValue = dataType.getEnumerationValues().iterator();
                        while (dataValue.hasNext()) {
                            DataValue dataValue2 = (DataValue)dataValue.next();
                            linkedList.add(NamedDataValue.getNamedDataValue((String)string, (DataValue)dataValue2));
                        }
                    }
                    if (!linkedList.contains(dataValue = dataType.getDataValue(null))) {
                        linkedList.add(NamedDataValue.getNamedDataValue((String)string, (DataValue)dataValue));
                    }
                    return linkedList;
                }

                private String getCellRenderer(Object object) {
                    List list;
                    DataValue dataValue;
                    String string = "";
                    if (object != null && object instanceof DataValue && (dataValue = (DataValue)object).getDataType().getStructureType() == StructureType.TABLE && (list = dataValue.getComponents()) != null) {
                        string = "size " + list.size();
                    }
                    return string;
                }
            };
            this.treetable.addMouseListener((MouseListener)new UIUtils.MousePopupTriggerListener(){

                protected void doPopup(MouseEvent mouseEvent) {
                    boolean bl;
                    int n;
                    Rectangle rectangle;
                    if (CompositeTypeEditPanel.this.treetable.isEditing() && !(rectangle = CompositeTypeEditPanel.this.treetable.getCellRect(n = CompositeTypeEditPanel.this.treetable.getEditingRow(), (bl = CompositeTypeEditPanel.this.treetable.getEditingColumn()) ? 1 : 0, false)).contains(mouseEvent.getPoint())) {
                        CompositeTypeEditPanel.this.treetable.getCellEditor().stopCellEditing();
                    }
                    if (!CompositeTypeEditPanel.this.treetable.isEditing()) {
                        if (!this.isRowSelected(mouseEvent)) {
                            this.selectRow(mouseEvent);
                        }
                        if (CompositeTypeEditPanel.this.isEditable()) {
                            boolean bl2;
                            TreePath[] treePathArray = CompositeTypeEditPanel.this.treetable.getTree().getSelectionPaths();
                            bl = treePathArray != null && treePathArray.length == 1 && CompositeTypeEditPanel.this.model.getStructureType(treePathArray[0].getLastPathComponent()) == StructureType.TABLE;
                            boolean bl3 = bl2 = treePathArray != null && treePathArray.length > 0;
                            if (bl2) {
                                TreePath treePath = null;
                                for (TreePath treePath2 : treePathArray) {
                                    TreePath treePath3 = treePath2.getParentPath();
                                    if (treePath == null) {
                                        if (treePath3 == null || CompositeTypeEditPanel.this.model.getStructureType(treePath3.getLastPathComponent()) != StructureType.TABLE) {
                                            bl2 = false;
                                            break;
                                        }
                                        treePath = treePath3;
                                    }
                                    if (treePath3 == treePath) continue;
                                    bl2 = false;
                                    break;
                                }
                            }
                            CompositeTypeEditPanel.this.addItem.setEnabled(bl);
                            CompositeTypeEditPanel.this.deleteItem.setEnabled(bl2);
                            CompositeTypeEditPanel.this.insertItem.setEnabled(bl2);
                            CompositeTypeEditPanel.this.dupItem.setEnabled(bl2);
                            CompositeTypeEditPanel.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        }
                    } else if (!this.isRowSelected(mouseEvent)) {
                        this.selectRow(mouseEvent);
                    }
                }

                private int getFocusRow(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    return CompositeTypeEditPanel.this.treetable.rowAtPoint(point);
                }

                private boolean isRowSelected(MouseEvent mouseEvent) {
                    int n = this.getFocusRow(mouseEvent);
                    if (n >= 0) {
                        ListSelectionModel listSelectionModel = CompositeTypeEditPanel.this.treetable.getSelectionModel();
                        return listSelectionModel.isSelectedIndex(n);
                    }
                    return false;
                }

                private void selectRow(MouseEvent mouseEvent) {
                    int n = this.getFocusRow(mouseEvent);
                    if (n >= 0) {
                        ListSelectionModel listSelectionModel = CompositeTypeEditPanel.this.treetable.getSelectionModel();
                        listSelectionModel.setSelectionInterval(n, n);
                    }
                }
            });
            TreeCellRenderer treeCellRenderer = this.treetable.getTree().getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                jComponent = (DefaultTreeCellRenderer)treeCellRenderer;
                ((DefaultTreeCellRenderer)jComponent).setLeafIcon(OracleIcons.getIcon((String)"domain.png"));
                ((DefaultTreeCellRenderer)jComponent).setOpenIcon(RaptorImagesArb.getIcon("TYPE_FOLDER"));
                ((DefaultTreeCellRenderer)jComponent).setClosedIcon(RaptorImagesArb.getIcon("TYPE_FOLDER"));
            }
            this.treetable.setSelectionMode(2);
            this.treetable.setFillsViewportHeight(true);
            this.treetable.getTableHeader().setReorderingAllowed(false);
            jComponent = new JScrollPane();
            ((JScrollPane)jComponent).getViewport().add(this.treetable);
            ((JScrollPane)jComponent).setHorizontalScrollBarPolicy(30);
            ((JScrollPane)jComponent).setVerticalScrollBarPolicy(20);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)jComponent, gridBagConstraints);
            this.setPreferredSize(new Dimension(320, 240));
        }

        public Object getValue() {
            return this.model.getValue();
        }

        public boolean isEditable() {
            return this.editable && this.model.isEditable();
        }

        public void setEditable(boolean bl) {
            this.editable = bl;
        }

        public void setValue(Object object) {
            this.model.setValue(object);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CompositeTypeEditPanel.this.reload(CompositeTypeEditPanel.this.model.getRoot());
                }
            });
        }

        private void ensureRowIsVisible(int n) {
            if (n >= 0) {
                this.treetable.scrollRectToVisible(this.treetable.getCellRect(n, 0, true));
            }
        }

        protected void reload(Object object) {
            this.model.reloadChildren(object);
        }
    }
}

