/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class PreviewLimitPanel {
    private JCheckBox previewLimitCheckBox;
    private NumericSpinBox previewLimitSpinBox;
    private boolean checkBoxControlled;
    private ImportDataFormat dataFormat;
    private static final long serialVersionUID = -2739487292165944123L;

    public PreviewLimitPanel() {
        this(true);
    }

    public PreviewLimitPanel(ImportDataFormat importDataFormat, boolean bl) {
        this(bl);
        this.dataFormat = importDataFormat;
    }

    public PreviewLimitPanel(boolean bl) {
        try {
            this.checkBoxControlled = bl;
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.initPreviewLimit();
    }

    public JCheckBox getPreviewLimitCheckBox() {
        return this.previewLimitCheckBox;
    }

    public NumericSpinBox getPreviewLimitSpinBox() {
        return this.previewLimitSpinBox;
    }

    void initPreviewLimit() {
        this.previewLimitCheckBox = new JCheckBox();
        this.previewLimitCheckBox.setSelected(true);
        ResourceUtils.resButton((AbstractButton)this.previewLimitCheckBox, (String)DataImportArb.getString("WIZARD_PREVIEW_LIMIT"));
        if (this.checkBoxControlled) {
            this.previewLimitCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    PreviewLimitPanel.this.previewLimitSpinBox.setEnabled(jCheckBox.isSelected());
                }
            });
        }
        this.previewLimitSpinBox = new NumericSpinBox(0, Integer.MAX_VALUE);
    }

    public void onEntry() {
        DBConfig dBConfig = DBConfig.getInstance();
        this.setOptions(dBConfig);
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.setOptions(dBConfig);
    }

    private void setOptions(DBConfig dBConfig) {
        if (this.dataFormat != null) {
            this.previewLimitCheckBox.setSelected(this.dataFormat.getUsePreviewLimit());
            this.previewLimitSpinBox.setIntValue(this.dataFormat.getPreviewLimit());
        } else {
            this.previewLimitCheckBox.setSelected(dBConfig.getBoolean("IMPORT_USE_PREVIEW_LIMIT"));
            this.previewLimitSpinBox.setIntValue(dBConfig.getInt("IMPORT_PREVIEW_LIMIT"));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("IMPORT_USE_PREVIEW_LIMIT", this.previewLimitCheckBox.isSelected());
        dBConfig.putInt("IMPORT_PREVIEW_LIMIT", this.previewLimitSpinBox.getIntValue());
    }
}

