/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.core;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.DataType;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.readers.DataReadable;
import oracle.dbtools.raptor.data.readers.DataReaderException;
import oracle.dbtools.raptor.data.readers.DataReaderRegistry;
import oracle.dbtools.raptor.data.ui.PreReqListener;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPTZFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.util.ModelUtil;

public class ImportPreRequisiteChecker {
    public static final int ALL_OK = 0;
    public static final int FAIL = 1;
    public static final int WARN = 2;
    private ArrayList<PreReqListener> m_audience = new ArrayList();
    private TraversableContext m_ctx;
    private GenericTable table;
    private int testResult = 0;
    private ImportProperties _iProps;

    public ImportPreRequisiteChecker(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
    }

    public int runTests() {
        this.table = (GenericTable)this._iProps.get(ImportKeys.TABLE);
        this.tableNameOK();
        this.allColumnsMapped();
        this.columnsHaveDataTypes();
        this.columnsHaveSize();
        this.datesHaveMasks();
        this.dataTypeSupported();
        return this.testResult;
    }

    /*
     * WARNING - void declaration
     */
    private void allColumnsMapped() {
        this.fireStartTest(DataImportArb.getString("VERIFY_COLUMNS_MAPPED"), null);
        boolean bl = true;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Vector<String> vector = new Vector<String>(this.table.getColumns().length);
        for (Column column : this.table.getColumns()) {
            if (!ModelUtil.hasLength((String)column.getName())) {
                bl = false;
                stringBuffer.append(column.getSourceColumnName());
                stringBuffer.append(", ");
                continue;
            }
            if (vector.contains(column.getName())) {
                if (!bl2) {
                    bl2 = true;
                } else {
                    stringBuffer2.append(", ");
                }
                stringBuffer2.append(column.getSourceColumnName());
                continue;
            }
            vector.addElement(column.getName());
        }
        if (bl && !bl2) {
            this.fireEndTest(DataImportArb.getString("VERIFY_COLUMNS_MAPPED"), true, null);
        } else {
            void var6_11;
            String string = "";
            if (!bl) {
                String string2 = DataImportArb.format("COLUMNS_NOT_MAPPED_ERROR", stringBuffer.toString()) + ". ";
            }
            if (bl2) {
                void var6_9;
                String string3 = (String)var6_9 + DataImportArb.format("DUPLICATE_COLUMNS_MAPPED_ERROR", stringBuffer2.toString());
            }
            this.testResult = 1;
            this.fireEndTest(DataImportArb.getString("VERIFY_COLUMNS_MAPPED"), false, (String)var6_11);
        }
    }

    private void tableNameOK() {
        this.fireStartTest(DataImportArb.getString("VERIFY_TABLE_NAME"), null);
        String string = this.table.getTable().getTablename();
        if (ModelUtil.hasLength((String)string)) {
            if (ImportPreRequisiteChecker.containsWhiteSpace(string)) {
                this.testResult = 1;
                this.fireEndTest(DataImportArb.getString("VERIFY_TABLE_NAME"), false, DataImportArb.format("TABLE_NAME_WHITESPACE_ERROR", string));
            } else {
                this.fireEndTest(DataImportArb.getString("VERIFY_TABLE_NAME"), true, null);
            }
        } else {
            this.fireEndTest(DataImportArb.getString("VERIFY_TABLE_NAME"), false, DataImportArb.getString("TABLE_NAME_ERROR"));
        }
    }

    private void columnsHaveDataTypes() {
        this.fireStartTest(DataImportArb.getString("VERIFY_COLUMN_DATA_TYPES"), null);
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        for (Column column : this.table.getColumns()) {
            if (ModelUtil.hasLength((String)column.getType())) continue;
            bl = false;
            stringBuffer.append(column.getSourceColumnName());
            stringBuffer.append(", ");
        }
        if (bl) {
            this.fireEndTest(DataImportArb.getString("VERIFY_COLUMN_DATA_TYPES"), true, null);
        } else {
            this.testResult = 1;
            this.fireEndTest(DataImportArb.getString("VERIFY_COLUMN_DATA_TYPES"), false, DataImportArb.format("COLUMN_DATA_TYPE_ERROR", stringBuffer.toString()));
        }
    }

    private void columnsHaveSize() {
        this.fireStartTest(DataImportArb.getString("VERIFY_DATA_SIZE"), null);
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        for (Column columnArray : this.table.getColumns()) {
            String string = columnArray.getType();
            if (!DataType.VARCHAR2.toString().equals(string) && !DataType.CHAR.toString().equals(string) && !DataType.NCHAR.toString().equals(string) && !DataType.NVARCHAR2.toString().equals(string) || columnArray.getPrecision() > 0) continue;
            bl = false;
            stringBuffer.append(columnArray.getSourceColumnName());
            stringBuffer.append(", ");
        }
        if (bl) {
            this.fireEndTest(DataImportArb.getString("VERIFY_DATA_SIZE"), true, null);
        } else {
            this.testResult = 1;
            this.fireEndTest(DataImportArb.getString("VERIFY_DATA_SIZE"), false, DataImportArb.format("COLUMN_SIZE_ERROR", stringBuffer.toString()));
        }
        boolean bl2 = true;
        this.fireStartTest(DataImportArb.getString("VERIFY_DATA_SIZE_AGAINST_READER"), null);
        LoadFile loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        DataReadable dataReadable = DataReaderRegistry.getReader(loadFile.getType());
        dataReadable.setDataFormat((ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT));
        try {
            dataReadable.setFileName(loadFile.getName());
            dataReadable.setPage((Integer)this._iProps.get(ImportKeys.PAGEID));
        }
        catch (DataReaderException dataReaderException) {
            // empty catch block
        }
        for (Column column : this.table.getColumns()) {
            String string = column.getType();
            if (!DataType.VARCHAR2.toString().equals(string) && !DataType.CHAR.toString().equals(string) && !DataType.NCHAR.toString().equals(string) && !DataType.NVARCHAR2.toString().equals(string) || column.getPrecision() >= dataReadable.getWidth(column.getSourceColID())) continue;
            bl2 = false;
            stringBuffer.append(column.getSourceColumnName());
            stringBuffer.append(", ");
        }
        if (bl2) {
            this.fireEndTest(DataImportArb.getString("VERIFY_DATA_SIZE_AGAINST_READER"), true, null);
        } else {
            this.testResult = 1;
            this.fireEndTest(DataImportArb.getString("VERIFY_DATA_SIZE_AGAINST_READER"), false, DataImportArb.format("COLUMN_SIZE_ERROR_IN_DATA", stringBuffer.toString()));
        }
        dataReadable = null;
    }

    private void datesHaveMasks() {
        this.fireStartTest(DataImportArb.getString("VERIFY_DATE_MASK"), null);
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        Locale locale = (Locale)this._iProps.get(ImportKeys.LOCALE);
        for (Column column : this.table.getColumns()) {
            OraDATEFormat oraDATEFormat;
            String string;
            if (ModelUtil.hasLength((String)column.getType()) && DataType.DATE.toString().equals(column.getType())) {
                string = column.getFormat();
                if (ModelUtil.hasLength((String)string)) {
                    try {
                        oraDATEFormat = new OraDATEFormat(string, OraLocaleInfo.getInstance((Locale)locale));
                    }
                    catch (ParseException parseException) {
                        bl = false;
                        stringBuffer.append(column.getSourceColumnName());
                        stringBuffer.append(", ");
                    }
                } else {
                    bl = false;
                    stringBuffer.append(column.getSourceColumnName());
                    stringBuffer.append(", ");
                }
            }
            if (ModelUtil.hasLength((String)column.getType()) && DataType.TIMESTAMP.toString().equals(column.getType())) {
                string = column.getFormat();
                if (ModelUtil.hasLength((String)string)) {
                    try {
                        oraDATEFormat = new OraTIMESTAMPFormat(string, OraLocaleInfo.getInstance((Locale)locale));
                    }
                    catch (ParseException parseException) {
                        bl = false;
                        stringBuffer.append(column.getSourceColumnName());
                        stringBuffer.append(", ");
                    }
                } else {
                    bl = false;
                    stringBuffer.append(column.getSourceColumnName());
                    stringBuffer.append(", ");
                }
            }
            if (!ModelUtil.hasLength((String)column.getType()) || !DataType.TIMESTAMPTZ.toString().equals(column.getType()) && !DataType.TIMESTAMPLTZ.toString().equals(column.getType())) continue;
            string = column.getFormat();
            if (ModelUtil.hasLength((String)string)) {
                try {
                    oraDATEFormat = new OraTIMESTAMPTZFormat(string, OraLocaleInfo.getInstance((Locale)locale));
                }
                catch (ParseException parseException) {
                    bl = false;
                    stringBuffer.append(column.getSourceColumnName());
                    stringBuffer.append(", ");
                }
                continue;
            }
            bl = false;
            stringBuffer.append(column.getSourceColumnName());
            stringBuffer.append(", ");
        }
        if (bl) {
            this.fireEndTest(DataImportArb.getString("VERIFY_DATE_MASK"), true, null);
        } else {
            this.testResult = 1;
            this.fireEndTest(DataImportArb.getString("VERIFY_DATE_MASK"), false, DataImportArb.format("DATE_MASK_ERROR", stringBuffer.toString()));
        }
    }

    private void dataTypeSupported() {
        this.fireStartTest(DataImportArb.getString("VERIFY_TYPE_SUPPORTED"), null);
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        List<String> list = DataType.getValuesAsList();
        for (Column column : this.table.getColumns()) {
            if (!ModelUtil.hasLength((String)column.getType()) || list.contains(column.getType())) continue;
            bl = false;
            stringBuffer.append(column.getType());
            stringBuffer.append(", ");
        }
        if (bl) {
            this.fireEndTest(DataImportArb.getString("VERIFY_TYPE_SUPPORTED"), true, null);
        } else {
            this.testResult = 1;
            this.fireEndTest(DataImportArb.getString("VERIFY_TYPE_SUPPORTED"), false, DataImportArb.format("DATA_TYPE_NOT_SUPPORTED", stringBuffer.toString()));
        }
    }

    public void addListener(PreReqListener preReqListener) {
        if (!this.m_audience.contains(preReqListener)) {
            this.m_audience.add(preReqListener);
        }
    }

    protected boolean fireEndTest(String string, boolean bl, String string2) {
        for (PreReqListener preReqListener : this.m_audience) {
            preReqListener.testCompleted(string, bl, string2);
        }
        return bl;
    }

    protected void fireStartTest(String string, String string2) {
        for (PreReqListener preReqListener : this.m_audience) {
            preReqListener.testStarted(string, string2);
        }
    }

    public static boolean containsWhiteSpace(String string) {
        for (char c : string.toCharArray()) {
            if (!Character.isWhitespace(c)) continue;
            return true;
        }
        return false;
    }
}

