/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.config.WorksheetDndOptionPanel;
import oracle.dbtools.raptor.controls.DefaultRaptorCodeEditorDnDHandler;
import oracle.dbtools.raptor.controls.OracleColumnDnDHandler;
import oracle.dbtools.raptor.controls.RaptorCodeEditorDnDHandler;
import oracle.dbtools.raptor.controls.RaptorCodeEditorDnDHandlerException;
import oracle.dbtools.raptor.controls.RaptorCodeEditorDnDProviderRegistry;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.model.Displayable;
import org.antlr.stringtemplate.StringTemplate;

public class OracleTableDnDHandler
implements RaptorCodeEditorDnDHandler {
    private WorksheetDndOptionPanel m_panel;
    private int m_option = 0;
    private String _worksheetConnectionName;
    private AliasGenerator m_aliasGen;
    private static final int CANCELED = -911;

    @Override
    public String handleDrop(List<Displayable> list) throws RaptorCodeEditorDnDHandlerException {
        return this.getSql(list);
    }

    @Override
    public void setWorksheetConnectionName(String string) {
        this._worksheetConnectionName = string;
    }

    protected boolean isOptionPrompRequired() {
        int n = DBConfig.getInstance().getInt("DRAG_N_DROP_PROMPT");
        return n == 0;
    }

    protected String getSql(List<Displayable> list) throws RaptorCodeEditorDnDHandlerException {
        String string;
        String string2 = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            if (list != null && list.size() > 0) {
                string2 = (String)((ObjectNode)list.get(0)).getProperty("TYPE");
                this.m_option = this.isOptionPrompRequired() ? this.getOption(list, string2) : DBConfig.getInstance().getInt("DRAG_N_DROP_CHOICES");
                if (this.m_option == -911) {
                    return null;
                }
                if (this.m_option == 2 && list.size() > 1) {
                    stringBuilder.append(this.getJoinStatement(list));
                } else {
                    boolean bl = false;
                    for (Displayable displayable : list) {
                        String string3;
                        if (!(displayable instanceof ObjectNode)) continue;
                        ObjectNode objectNode = (ObjectNode)displayable;
                        objectNode.ensureOpen();
                        List<DBChildInstance> list2 = null;
                        String string4 = objectNode.getSchemaName();
                        String string5 = objectNode.getObjectName();
                        String[] stringArray = null;
                        String string6 = (String)objectNode.getProperty("TYPE");
                        list2 = string6.equals("VIEW") ? objectNode.getNodeInstance().listChildren("VIEW_COLUMN") : objectNode.getNodeInstance().listChildren("COLUMN");
                        if (list2 != null && list2.size() > 0) {
                            int n = 0;
                            stringArray = new String[list2.size()];
                            for (DBChildInstance dBChildInstance : list2) {
                                stringArray[n++] = DBUtil.addDoubleQuote((String)((String)dBChildInstance.getProperty("NAME")));
                            }
                        }
                        String string7 = string3 = this.m_option == 6 ? "," : DefaultRaptorCodeEditorDnDHandler.NL + " ";
                        if (bl) {
                            stringBuilder.append(string3);
                        }
                        bl = true;
                        stringBuilder.append(this.getSql(string4, string5, stringArray));
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new RaptorCodeEditorDnDHandlerException(exception);
        }
        if ((string = stringBuilder.toString()) == null) {
            string = "";
        }
        return string;
    }

    protected int getOption(List<Displayable> list, String string) {
        DBConfig dBConfig = DBConfig.getInstance();
        this.m_panel = new WorksheetDndOptionPanel();
        this.m_panel.setPrompt(dBConfig.getInt("DRAG_N_DROP_PROMPT"));
        this.m_panel.setDragType(dBConfig.getInt("DRAG_N_DROP_CHOICES"));
        int n = this.m_panel.getDragType();
        if (list != null && list.size() > 1) {
            this.m_panel.enableJoin();
        } else {
            this.m_panel.disableJoin();
            if (n == 2 || n == 1) {
                this.m_panel.setDragType(1);
            }
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JEWTDialog)actionEvent.getSource()).isCancelled()) {
                    OracleTableDnDHandler.this.m_panel.setCancel(true);
                    return;
                }
                if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                    DBConfig dBConfig = DBConfig.getInstance();
                    OracleTableDnDHandler.this.m_panel.setCancel(false);
                    OracleTableDnDHandler.this.m_option = OracleTableDnDHandler.this.m_panel.getDragType();
                    int n = OracleTableDnDHandler.this.m_panel.getPrompt();
                    dBConfig.putInt("DRAG_N_DROP_PROMPT", n);
                    ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                }
            }
        };
        UIUtils.showPanelAsDialog((JPanel)this.m_panel, (String)PreferencesArb.getString("DND_LABEL"), (ActionListener)actionListener, (boolean)true);
        return this.m_panel.isCanceled() ? -911 : this.m_panel.getDragType();
    }

    protected String getSql(String string, String string2, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = RaptorCodeEditorDnDProviderRegistry.isQualifyObjectName(this._worksheetConnectionName, string);
        if (this.m_option == 0) {
            this.m_option = this.getOption(null, null);
        }
        switch (this.m_option) {
            case 1: {
                return this.buildSelectStatement(string, string2, stringArray, bl);
            }
            case 3: {
                return this.buildInsertStatement(string, string2, stringArray, bl);
            }
            case 5: {
                return this.buildDeleteStatement(string, string2, stringArray, bl);
            }
            case 4: {
                return this.buildUpdateStatement(string, string2, stringArray, bl);
            }
            case 6: {
                if (this instanceof OracleColumnDnDHandler) {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    for (String string3 : stringArray) {
                        stringBuilder2.append(bl ? string + "." + string3 : string3);
                        stringBuilder2.append(", ");
                    }
                    return stringBuilder2.length() > 0 ? stringBuilder2.substring(0, stringBuilder2.length() - 2) : "";
                }
                return bl ? string + "." + string2 : string2;
            }
        }
        return stringBuilder.toString();
    }

    private String buildSelectStatement(String string, String string2, String[] stringArray, boolean bl) {
        String string3 = null;
        StringTemplate stringTemplate = RaptorCodeEditorDnDProviderRegistry.getTemplate("Oracle", "SelectStatement");
        if (stringTemplate != null) {
            if (bl) {
                stringTemplate.setAttribute("objectNames", (Object)(DBUtil.addDoubleQuote((String)string) + "." + DBUtil.addDoubleQuote((String)string2)));
            } else {
                stringTemplate.setAttribute("objectNames", (Object)DBUtil.addDoubleQuote((String)string2));
            }
            stringTemplate.setAttribute("colList", (Object)stringArray);
            string3 = stringTemplate.toString();
        }
        return string3;
    }

    private String buildInsertStatement(String string, String string2, String[] stringArray, boolean bl) {
        String string3 = null;
        StringTemplate stringTemplate = RaptorCodeEditorDnDProviderRegistry.getTemplate("Oracle", "InsertStatement");
        if (stringTemplate != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                arrayList.add(":v" + i);
            }
            if (bl) {
                stringTemplate.setAttribute("tableName", (Object)(DBUtil.addDoubleQuote((String)string) + "." + DBUtil.addDoubleQuote((String)string2)));
            } else {
                stringTemplate.setAttribute("tableName", (Object)DBUtil.addDoubleQuote((String)string2));
            }
            stringTemplate.setAttribute("valList", arrayList);
            stringTemplate.setAttribute("colList", (Object)stringArray);
            string3 = stringTemplate.toString();
        }
        return string3;
    }

    private String buildDeleteStatement(String string, String string2, String[] stringArray, boolean bl) {
        String string3 = null;
        StringTemplate stringTemplate = RaptorCodeEditorDnDProviderRegistry.getTemplate("Oracle", "DeleteStatement");
        if (stringTemplate != null) {
            int n = 0;
            ArrayList<String> arrayList = null;
            if (stringArray != null) {
                arrayList = new ArrayList<String>();
                for (String string4 : stringArray) {
                    arrayList.add(string4 + " = :v" + n++);
                }
            }
            if (bl) {
                stringTemplate.setAttribute("tableName", (Object)(DBUtil.addDoubleQuote((String)string) + "." + DBUtil.addDoubleQuote((String)string2)));
            } else {
                stringTemplate.setAttribute("tableName", (Object)DBUtil.addDoubleQuote((String)string2));
            }
            stringTemplate.setAttribute("colList", arrayList);
            string3 = stringTemplate.toString();
        }
        return string3;
    }

    private String buildUpdateStatement(String string, String string2, String[] stringArray, boolean bl) {
        String string3 = null;
        StringTemplate stringTemplate = RaptorCodeEditorDnDProviderRegistry.getTemplate("Oracle", "UpdateStatement");
        if (stringTemplate != null) {
            int n = 0;
            ArrayList<String> arrayList = null;
            if (stringArray != null) {
                arrayList = new ArrayList<String>();
                for (String string4 : stringArray) {
                    arrayList.add(string4 + " = :v" + n++);
                }
            }
            if (bl) {
                stringTemplate.setAttribute("tableName", (Object)(DBUtil.addDoubleQuote((String)string) + "." + DBUtil.addDoubleQuote((String)string2)));
            } else {
                stringTemplate.setAttribute("tableName", (Object)DBUtil.addDoubleQuote((String)string2));
            }
            stringTemplate.setAttribute("colList", arrayList);
            string3 = stringTemplate.toString();
        }
        return string3;
    }

    private boolean objInDragList(String string, List<ObjectNode> list) {
        if (string != null && list != null) {
            for (ObjectNode objectNode : list) {
                if (!objectNode.getObjectName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private String getAlias(String string, String string2, List<RefPair> list, List<RefPair> list2) {
        if (!(list != null && list.size() != 0 || list2 != null && list2.size() != 0)) {
            return this.getAliasGenerator().getNextAlias();
        }
        String string3 = null;
        ListIterator<RefPair> listIterator = null;
        if (list != null) {
            listIterator = list.listIterator();
        }
        ListIterator<RefPair> listIterator2 = null;
        if (list2 != null) {
            listIterator2 = list2.listIterator();
        }
        RefPair refPair = null;
        while (listIterator != null && listIterator.hasNext()) {
            refPair = listIterator.next();
            if (string.equals(refPair.getPrimTableOwner()) && string2.equals(refPair.getPrimTable())) {
                string3 = refPair.getPrimAlias();
                break;
            }
            if (!string.equals(refPair.getRefTableOwner()) || !string2.equals(refPair.getRefTable())) continue;
            string3 = refPair.getRefAlias();
            break;
        }
        while (string3 == null && listIterator2 != null && listIterator2.hasNext()) {
            refPair = listIterator2.next();
            if (string.equals(refPair.getPrimTableOwner()) && string2.equals(refPair.getPrimTable())) {
                string3 = refPair.getPrimAlias();
                break;
            }
            if (!string.equals(refPair.getRefTableOwner()) || !string2.equals(refPair.getRefTable())) continue;
            string3 = refPair.getRefAlias();
            break;
        }
        if (string3 == null) {
            string3 = this.getAliasGenerator().getNextAlias();
        }
        return string3;
    }

    private AliasGenerator getAliasGenerator() {
        if (this.m_aliasGen == null) {
            this.m_aliasGen = new AliasGenerator();
        }
        return this.m_aliasGen;
    }

    /*
     * Exception decompiling
     */
    private RefPair getRefPairsFromConsName(String var1_1, String var2_2, String var3_3, String var4_4, String var5_5, String var6_6, List<ObjectNode> var7_7, List<RefPair> var8_8, List<RefPair> var9_9) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RefPair> getRefPairsForObjectName(String string, String string2, String string3, List<ObjectNode> list, List<RefPair> list2) throws SQLException {
        String string4 = "select constraint_name, r_constraint_name, r_owner   from all_constraints c where constraint_type = 'R'  and table_name = ?  and owner = ? and r_constraint_name not in (select constraint_name  from all_constraints where table_name = ?  and   owner = ?)";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add(string2);
        ArrayList<RefPair> arrayList2 = null;
        RefPair refPair = null;
        DBUtil dBUtil = DBUtil.getInstance((String)string);
        ResultSet resultSet = dBUtil.executeQuery(string4, arrayList);
        if (resultSet != null) {
            try {
                while (resultSet.next()) {
                    String string5;
                    String string6 = resultSet.getString(1);
                    String string7 = resultSet.getString(2);
                    refPair = this.getRefPairsFromConsName(string, string2, string3, string7, string6, string5 = resultSet.getString(3), list, list2, arrayList2);
                    if (refPair == null) continue;
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<RefPair>();
                    }
                    arrayList2.add(refPair);
                }
            }
            finally {
                DBUtil.closeResultSet((ResultSet)resultSet);
            }
        }
        return arrayList2;
    }

    private boolean isObjectPartOfRefPair(String string, List<RefPair> list) {
        RefPair refPair = null;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                refPair = list.get(i);
                if (!refPair.getQuotedPrimTable().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getTableColumns(String string, String string2, String string3) throws SQLException {
        String string4 = "select column_name from all_tab_columns where table_name=? AND owner = ?";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        arrayList.add(string2);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        DBUtil dBUtil = DBUtil.getInstance((String)string);
        DatabaseMetaData databaseMetaData = null;
        String string5 = null;
        try {
            databaseMetaData = Connections.getInstance().getConnection(this._worksheetConnectionName).getMetaData();
            string5 = databaseMetaData.getUserName();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        String string6 = null;
        string6 = string2 != null && !string2.equals(string5) ? DBUtil.addDoubleQuote((String)string2) + "." + DBUtil.addDoubleQuote((String)string3) + "." : DBUtil.addDoubleQuote((String)string3) + ".";
        ResultSet resultSet = dBUtil.executeQuery(string4, arrayList);
        if (resultSet != null) {
            try {
                while (resultSet.next()) {
                    arrayList2.add(string6 + DBUtil.addDoubleQuote((String)resultSet.getString(1)));
                }
            }
            finally {
                DBUtil.closeResultSet((ResultSet)resultSet);
            }
        }
        return arrayList2;
    }

    private boolean isObjUnique(String string, String string2, List<String> list) {
        if (list == null) {
            return false;
        }
        Iterator<String> iterator = list.iterator();
        String string3 = null;
        String string4 = null;
        while (iterator != null && iterator.hasNext()) {
            string4 = iterator.next();
            int n = string4.indexOf(".");
            if (n >= 0) {
                string3 = string4.substring(0, n);
                string4 = string4.substring(string4.indexOf(".") + 1, string4.indexOf(" "));
            } else {
                string3 = null;
                string4 = string4.substring(0, string4.indexOf(" "));
            }
            if (string3 != null && !string3.equals(string) || !string4.equals(string2)) continue;
            return false;
        }
        return true;
    }

    private List<String> getRefTables(List<RefPair> list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<RefPair> iterator = list.iterator();
        RefPair refPair = null;
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator != null && iterator.hasNext()) {
            refPair = iterator.next();
            stringBuilder.delete(0, stringBuilder.length());
            if (this.isObjUnique(refPair.getQuotedRefTableOwner(), refPair.getQuotedRefTable(), arrayList)) {
                if (string != null && !Connections.getDisplayName(string).equalsIgnoreCase(refPair.getRefTableOwner())) {
                    stringBuilder.append(refPair.getQuotedRefTableOwner());
                    stringBuilder.append(".");
                }
                stringBuilder.append(refPair.getQuotedRefTable());
                stringBuilder.append(" ");
                stringBuilder.append(refPair.getRefAlias());
                arrayList.add(stringBuilder.toString());
            }
            stringBuilder.delete(0, stringBuilder.length());
            if (!this.isObjUnique(refPair.getQuotedPrimTableOwner(), refPair.getQuotedPrimTable(), arrayList)) continue;
            if (string != null && !Connections.getDisplayName(string).equalsIgnoreCase(refPair.getPrimTableOwner())) {
                stringBuilder.append(refPair.getQuotedPrimTableOwner());
                stringBuilder.append(".");
            }
            stringBuilder.append(refPair.getQuotedPrimTable());
            stringBuilder.append(" ");
            stringBuilder.append(refPair.getPrimAlias());
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    private List<CondObj> getConditionList(List<RefPair> list) {
        Iterator<RefPair> iterator = list.iterator();
        ArrayList<String> arrayList = null;
        ArrayList<CondObj> arrayList2 = null;
        CondObj condObj = null;
        RefPair refPair = null;
        while (iterator != null && iterator.hasNext()) {
            refPair = iterator.next();
            ArrayList<String> arrayList3 = refPair.getPrimCols();
            arrayList = refPair.getRefCols();
            if (arrayList3.size() != arrayList.size()) {
                throw new IllegalStateException(MessageFormat.format(Messages.getString("DnDDropGenerator.19"), arrayList3.size(), arrayList.size(), refPair.getRefTableOwner() + "." + refPair.getRefTable()));
            }
            Iterator iterator2 = arrayList3.iterator();
            Iterator iterator3 = arrayList.iterator();
            while (iterator2 != null && iterator3 != null && iterator2.hasNext() && iterator3.hasNext()) {
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<CondObj>();
                }
                condObj = new CondObj();
                condObj.setCol1(refPair.getPrimAlias() + "." + DBUtil.addDoubleQuote((String)((String)iterator2.next())));
                condObj.setCol2(refPair.getRefAlias() + "." + DBUtil.addDoubleQuote((String)((String)iterator3.next())));
                arrayList2.add(condObj);
            }
        }
        return arrayList2;
    }

    private String constructJoinSQL(List<String> list, List<String> list2, List<CondObj> list3) {
        String string = null;
        StringTemplate stringTemplate = null;
        stringTemplate = RaptorCodeEditorDnDProviderRegistry.getTemplate("Oracle", "SelectStatement");
        stringTemplate.setAttribute("colList", list);
        stringTemplate.setAttribute("objectNames", list2);
        stringTemplate.setAttribute("cond", (Object)(list3 != null && list3.size() > 0 ? 1 : 0));
        stringTemplate.setAttribute("condList", list3);
        string = stringTemplate.toString();
        if (string.endsWith(" AND ;")) {
            string = string.substring(0, string.lastIndexOf(" AND ;")) + ";";
        }
        return string;
    }

    private void ensureAliasPrefixForColumns(List<String> list, List<RefPair> list2) {
        if (list == null || list2 == null) {
            return;
        }
        ListIterator<String> listIterator = list.listIterator();
        Iterator<RefPair> iterator = null;
        RefPair refPair = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        int n2 = 0;
        block0: while (listIterator != null && listIterator.hasNext()) {
            string3 = listIterator.next();
            n = string3.indexOf(".");
            if (n != (n2 = string3.lastIndexOf("."))) {
                string = string3.substring(0, n);
                string2 = string3.substring(n + 1, n2);
            } else {
                string = null;
                string2 = string3.substring(0, n);
            }
            string3 = string3.substring(n2 + 1);
            iterator = list2.iterator();
            while (iterator != null && iterator.hasNext()) {
                refPair = iterator.next();
                if ((string == null || string.equals(refPair.getQuotedPrimTableOwner())) && string2.equals(refPair.getQuotedPrimTable())) {
                    listIterator.set(refPair.getPrimAlias() + "." + string3);
                    continue block0;
                }
                if (string != null && !string.equals(refPair.getQuotedRefTableOwner()) || !string2.equals(refPair.getQuotedRefTable())) continue;
                listIterator.set(refPair.getRefAlias() + "." + string3);
                continue block0;
            }
        }
    }

    private String getJoinSql(List<ObjectNode> list) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        ArrayList<RefPair> arrayList = new ArrayList<RefPair>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        List<CondObj> list2 = null;
        List<RefPair> list3 = null;
        Connections connections = Connections.getInstance();
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            object3 = list.get(i);
            string = ((ObjectNode)object3).getSchemaName();
            list3 = this.getRefPairsForObjectName(((ObjectNode)object3).getConnectionName(), string, ((ObjectNode)object3).getObjectName(), list, arrayList);
            if (list3 != null) {
                arrayList.addAll(list3);
            } else if (!this.isObjectPartOfRefPair(((ObjectNode)object3).getObjectName(), arrayList)) {
                object2 = null;
                object = null;
                try {
                    object2 = Connections.getInstance().getConnection(this._worksheetConnectionName).getMetaData();
                    object = object2.getUserName();
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                if (!((String)object).equals(string)) {
                    arrayList2.add(DBUtil.addDoubleQuote((String)string) + "." + DBUtil.addDoubleQuote((String)((ObjectNode)object3).getObjectName()));
                } else {
                    arrayList2.add(DBUtil.addDoubleQuote((String)((ObjectNode)object3).getObjectName()));
                }
            }
            arrayList4.addAll(this.getTableColumns(((ObjectNode)object3).getConnectionName(), string, ((ObjectNode)object3).getObjectName()));
        }
        DatabaseMetaData databaseMetaData = null;
        object3 = null;
        try {
            databaseMetaData = Connections.getInstance().getConnection(this._worksheetConnectionName).getMetaData();
            object3 = databaseMetaData.getUserName();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        object2 = this.getRefTables(arrayList, (String)object3);
        arrayList3.addAll((Collection<String>)object2);
        object = null;
        object = arrayList2.listIterator();
        while (object != null && object.hasNext()) {
            if (this.isUnique(arrayList, (String)object.next())) continue;
            object.remove();
        }
        arrayList3.addAll(arrayList2);
        this.ensureAliasPrefixForColumns(arrayList4, arrayList);
        list2 = this.getConditionList(arrayList);
        return this.constructJoinSQL(arrayList4, arrayList3, list2);
    }

    private boolean isUnique(List<RefPair> list, String string) {
        RefPair refPair = null;
        String string2 = null;
        String string3 = null;
        if (string == null || list == null) {
            return true;
        }
        int n = 0;
        n = string.indexOf(".");
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string3 = string;
        }
        ListIterator<RefPair> listIterator = list.listIterator();
        while (listIterator != null && listIterator.hasNext()) {
            refPair = listIterator.next();
            if ((string2 != null && !string2.equals(refPair.getQuotedPrimTableOwner()) || !string3.equals(refPair.getQuotedPrimTable())) && (string2 != null && !string2.equals(refPair.getQuotedRefTableOwner()) || !string3.equals(refPair.getQuotedRefTable()))) continue;
            return false;
        }
        return true;
    }

    private String getJoinStatement(List<Displayable> list) throws IOException, UnsupportedFlavorException, SQLException {
        String string = null;
        ArrayList<ObjectNode> arrayList = new ArrayList<ObjectNode>();
        for (int i = 0; i < list.size(); ++i) {
            Displayable displayable = list.get(i);
            if (!(displayable instanceof ObjectNode)) continue;
            arrayList.add((ObjectNode)displayable);
        }
        string = this.getJoinSql(arrayList);
        return string;
    }

    private class AliasGenerator {
        private int cloneCount = 0;
        private int pos = 0;
        private String aliasString = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        private StringBuilder sb = new StringBuilder();

        private AliasGenerator() {
        }

        String getNextAlias() {
            String string = null;
            this.sb.delete(0, this.sb.length());
            if (this.pos < this.aliasString.length() - 1) {
                this.sb.append(this.aliasString.substring(this.pos, this.pos + 1));
            } else {
                this.sb.append(this.aliasString.substring(this.pos));
            }
            ++this.pos;
            string = this.sb.toString();
            for (int i = 0; i < this.cloneCount; ++i) {
                this.sb.append(string);
            }
            if (this.pos > this.aliasString.length() - 1) {
                this.pos %= this.aliasString.length();
                ++this.cloneCount;
            }
            return this.sb.toString();
        }
    }

    private static class CondObj {
        private String col1;
        private String col2;

        private CondObj() {
        }

        public String getCol1() {
            return this.col1;
        }

        public String getCol2() {
            return this.col2;
        }

        void setCol1(String string) {
            this.col1 = string;
        }

        void setCol2(String string) {
            this.col2 = string;
        }
    }

    private static class RefPair {
        private String ref_Tab_Owner;
        private String ref_TableName;
        private String ref_Constraint_Name;
        private ArrayList<String> ref_Tab_Col;
        private String ref_Tab_Alias;
        private String prim_Tab_Owner;
        private String prim_TableName;
        private String prim_Constraint_Name;
        private ArrayList<String> prim_Tab_Col;
        private String prim_Tab_Alias;

        private RefPair() {
        }

        String getRefTableOwner() {
            return this.ref_Tab_Owner;
        }

        String getQuotedRefTableOwner() {
            return DBUtil.addDoubleQuote((String)this.ref_Tab_Owner);
        }

        String getRefTable() {
            return this.ref_TableName;
        }

        String getQuotedRefTable() {
            return DBUtil.addDoubleQuote((String)this.ref_TableName);
        }

        String getRefConstName() {
            return this.ref_Constraint_Name;
        }

        ArrayList<String> getRefCols() {
            return this.ref_Tab_Col;
        }

        String getRefAlias() {
            return this.ref_Tab_Alias;
        }

        String getPrimTableOwner() {
            return this.prim_Tab_Owner;
        }

        String getQuotedPrimTableOwner() {
            return DBUtil.addDoubleQuote((String)this.prim_Tab_Owner);
        }

        String getPrimTable() {
            return this.prim_TableName;
        }

        String getQuotedPrimTable() {
            return DBUtil.addDoubleQuote((String)this.prim_TableName);
        }

        ArrayList<String> getPrimCols() {
            return this.prim_Tab_Col;
        }

        String getPrimAlias() {
            return this.prim_Tab_Alias;
        }

        String getPrimConstName() {
            return this.prim_Constraint_Name;
        }

        void setRefTableOwner(String string) {
            this.ref_Tab_Owner = string;
        }

        void setRefTable(String string) {
            this.ref_TableName = string;
        }

        void setRefConstName(String string) {
            this.ref_Constraint_Name = string;
        }

        void setRefCols(ArrayList<String> arrayList) {
            this.ref_Tab_Col = arrayList;
        }

        void addRefCol(String string) {
            this.ref_Tab_Col.add(string);
        }

        void setRefAlias(String string) {
            this.ref_Tab_Alias = string;
        }

        void setPrimTableOwner(String string) {
            this.prim_Tab_Owner = string;
        }

        void setPrimTable(String string) {
            this.prim_TableName = string;
        }

        void addPrimCol(String string) {
            this.prim_Tab_Col.add(string);
        }

        void setPrimCols(ArrayList<String> arrayList) {
            this.prim_Tab_Col = arrayList;
        }

        void setPrimAlias(String string) {
            this.prim_Tab_Alias = string;
        }

        void setPrimConstName(String string) {
            this.prim_Constraint_Name = string;
        }

        String getQualifiedPrimTableCol(String string) {
            return this.prim_Tab_Alias + "." + this.prim_TableName + "." + string;
        }

        String getQualifiedRefTableCol(String string) {
            return this.ref_Tab_Alias + "." + this.ref_TableName + "." + this.ref_Tab_Col;
        }
    }
}

