/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections.impexp;

import java.net.URL;
import java.util.Properties;
import oracle.dbtools.raptor.connections.impexp.Destination;
import oracle.dbtools.raptor.connections.impexp.FilenamePanel;
import oracle.dbtools.raptor.connections.impexp.ImpExpEngine;
import oracle.dbtools.raptor.connections.impexp.ImpExpResources;
import oracle.dbtools.raptor.connections.impexp.ImportDestination;
import oracle.dbtools.raptor.connections.impexp.ImportSource;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversalException;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public final class AutoImport {
    private final ImportSource mSource;

    public static AutoImport createImporter(URL uRL) throws ImportException {
        if (uRL == null) {
            throw new ImportException(ImpExpResources.getString("AUTOIMP_MESSAGE_NO_FILE"));
        }
        if (URLFileSystem.isDirectoryPath((URL)uRL)) {
            throw new ImportException(ImpExpResources.format("AUTOIMP_MESSAGE_DIRECTORY", URLFileSystem.getPlatformPathName((URL)uRL)));
        }
        if (!FilenamePanel.XML_FILTER.accept(uRL) && !FilenamePanel.PROPS_FILTER.accept(uRL)) {
            throw new ImportException(ImpExpResources.format("AUTOIMP_MESSAGE_UNSUPPORTED", URLFileSystem.getPlatformPathName((URL)uRL)));
        }
        if (!URLFileSystem.exists((URL)uRL)) {
            throw new ImportException(ImpExpResources.format("AUTOIMP_MESSAGE_NOT_EXIST", URLFileSystem.getPlatformPathName((URL)uRL)));
        }
        ImportSource importSource = null;
        try {
            importSource = ImportSource.createSource(uRL);
            if (importSource.listAllConnections().size() == 0) {
                throw new ImportException(ImpExpResources.format("AUTOIMP_MESSAGE_NO_CONNECTIONS", URLFileSystem.getPlatformPathName((URL)uRL)));
            }
        }
        catch (ConnectionException connectionException) {
            throw new ImportException(ImpExpResources.format("AUTOIMP_MESSAGE_PROCESSING_ERROR", URLFileSystem.getPlatformPathName((URL)uRL)), connectionException);
        }
        return new AutoImport(importSource);
    }

    private AutoImport(ImportSource importSource) {
        this.mSource = importSource;
    }

    public void setKey(String string) throws ImportException, KeyException {
        if (this.mSource.getMode() != ImpExpEngine.PasswordMode.LEGACY) {
            if (string == null) {
                this.mSource.setMode(ImpExpEngine.PasswordMode.STRIP);
            } else {
                this.mSource.setMode(ImpExpEngine.PasswordMode.KEY);
                this.mSource.setKey(string);
                try {
                    if (!this.mSource.isKeyValid()) {
                        throw new KeyException();
                    }
                }
                catch (ConnectionException connectionException) {
                    throw new ImportException(ImpExpResources.format("AUTOIMP_MESSAGE_PROCESSING_ERROR", URLFileSystem.getPlatformPathName((URL)this.mSource.getURL())), connectionException);
                }
            }
        }
    }

    public void doImport() throws ImportException {
        DatabaseConnections databaseConnections = DatabaseConnections.getInstance();
        ImportDestination importDestination = new ImportDestination(databaseConnections);
        importDestination.setDuplicateMode(Destination.DuplicateMode.RENAME);
        try {
            for (String string : this.mSource.listAllConnections()) {
                Properties properties = this.mSource.getConnectionProperties(string);
                importDestination.addConnectionForCopy(string, properties);
            }
        }
        catch (ConnectionException connectionException) {
            throw new ImportException(ImpExpResources.format("AUTOIMP_MESSAGE_PROCESSING_ERROR", URLFileSystem.getPlatformPathName((URL)this.mSource.getURL())), connectionException);
        }
        try {
            importDestination.commitChanges();
        }
        catch (TraversalException traversalException) {
            throw new ImportException(traversalException.getLocalizedMessage());
        }
    }

    public static class KeyException
    extends ImportException {
        private static final long serialVersionUID = 1L;

        public KeyException() {
            super("Invalid key");
        }
    }

    public static class ImportException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ImportException(String string) {
            super(string);
        }

        ImportException(String string, ConnectionException connectionException) {
            super(string, connectionException);
        }
    }
}

