/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;

public final class TnsnamesDirChooser
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JLabel lblTnsnamesPath = new JLabel();
    private URLTextField tnsnamesDirPath = new URLTextField();
    private JButton btnBrowse = new JButton();
    private GridBagLayout layMain = new GridBagLayout();

    public TnsnamesDirChooser() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        String string = dBConfig.getString("TNS_NAMES_DIR");
        URL uRL = ModelUtil.hasLength((String)string) ? URLFactory.newFileURL((String)string) : null;
        this.tnsnamesDirPath.setURL(uRL);
        String string2 = dBConfig.getString("DEFAULTPATH");
        URL uRL2 = ModelUtil.hasLength((String)string2) ? URLFactory.newFileURL((String)string2) : URLFactory.newFileURL((String)Ide.getTrueUserHomeDirectory());
        this.tnsnamesDirPath.setDefaultChooserURL(uRL2);
    }

    public void onExit(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        URL uRL = this.tnsnamesDirPath.getURL();
        String string = uRL != null ? URLFileSystem.getPlatformPathName((URL)uRL) : "";
        dBConfig.putString("TNS_NAMES_DIR", string);
    }

    public JTextField getPathField() {
        return this.tnsnamesDirPath;
    }

    private void jbInit() throws Exception {
        String string = PreferencesArb.getString("TNS_NAMES_DIR_TEXT");
        ResourceUtils.resLabel((JLabel)this.lblTnsnamesPath, (Component)this.tnsnamesDirPath, (String)string);
        ResourceUtils.resButton((AbstractButton)this.btnBrowse, (String)PreferencesArb.getString("TNS_NAMES_BROWSE"));
        this.btnBrowse.addActionListener((ActionListener)this.tnsnamesDirPath);
        this.tnsnamesDirPath.setDirectoryOnly(true);
        this.tnsnamesDirPath.setDialogType(0);
        this.setLayout(this.layMain);
        this.add(this.btnBrowse, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.tnsnamesDirPath, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.add(this.lblTnsnamesPath, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }
}

