/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.dbtools.raptor.config.NavigationFilterTree;
import oracle.dbtools.raptor.config.NavigationFilterTreeRefresher;
import oracle.dbtools.raptor.config.NavigatorFilterConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.navigator.db.model.BaseElement;
import oracle.dbtools.raptor.navigator.db.model.ObjectCategory;
import oracle.dbtools.raptor.navigator.db.model.ObjectType;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorHook;
import oracle.dbtools.raptor.navigator.db.xml.QueryFactory;
import oracle.dbtools.raptor.navigator.db.xml.XmlFolderImpl;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.ui.checktree.TriStateNode;

public class NavigatorFilterPanel
extends DefaultTraversablePanel {
    private static final Border focusBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("Tree.selectionBorderColor"));
    private static final Border normalBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    boolean featureEnabled = false;
    private static final long serialVersionUID = 1L;
    private final String FOLDER_ROOT = "FOLDER_ROOT";
    JTabbedPane tabbedPane = null;
    private List<String> usedConnections = null;
    private NavigationFilterTree oracleTree = null;
    private DefaultTreeModel oracleTreeModel = null;
    private NavigationFilterTree mysqlTree = null;
    private DefaultTreeModel mysqlTreeModel = null;
    private NavigationFilterTree db2Tree = null;
    private DefaultTreeModel db2TreeModel = null;
    private NavigationFilterTree sybaseTree = null;
    private DefaultTreeModel sybaseTreeModel = null;
    private NavigationFilterTree timesTenTree = null;
    private DefaultTreeModel timesTenTreeModel = null;
    private NavigationFilterTree teradataTree = null;
    private DefaultTreeModel teradataTreeModel = null;
    private NavigationFilterTree sqlServerTree = null;
    private DefaultTreeModel sqlServerTreeModel = null;
    private NavigationFilterTree postgresqlTree = null;
    private DefaultTreeModel postgresqlTreeModel = null;
    private NavigationFilterTree accessTree = null;
    private DefaultTreeModel accessTreeModel = null;
    private String featureEnableCheckboxLabel = PreferencesArb.getString("NAVIGATOR_FILTER_FEATURE_CHOICE");
    private NavigationFilterTreeRefresher refresher = null;

    public NavigatorFilterPanel() {
        this.retriveConnectionTypes();
        this.printUsedConnections();
        this.setRefresher(new NavigationFilterTreeRefresher());
        this.init();
    }

    private void retriveConnectionTypes() {
        Iterator<ConnectionType> iterator = NavigatorHook.getHookInstance("sqldev.nav").getConnectionTypes();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            ConnectionType connectionType = iterator.next();
            String string = connectionType.getImpl().getConnectionPanelLabel();
            if (string == null || string.trim().length() <= 0) continue;
            String string2 = string.toUpperCase();
            if (string2.equals("ORACLE")) {
                arrayList.add("ORACLE");
            }
            if (!string2.equals("TIMESTEN")) continue;
            arrayList.add("TIMESTEN");
        }
        this.setUsedConnections(arrayList);
    }

    private void setUsedConnections(List<String> list) {
        this.usedConnections = list;
    }

    private List<String> getUsedConnections() {
        return this.usedConnections;
    }

    private void printUsedConnections() {
        List<String> list = this.getUsedConnections();
        for (int i = 0; i < list.size(); ++i) {
        }
    }

    private List<CategoryLabel> getOracleFolders() {
        QueryFactory queryFactory = QueryFactory.getFactory("sqldev.nav", "Oracle");
        List<CategoryLabel> list = this.findFolders(queryFactory);
        return list;
    }

    private List<CategoryLabel> getMySQLFolders() {
        QueryFactory queryFactory = QueryFactory.getFactory("sqldev.nav", "MySQL");
        List<CategoryLabel> list = this.findFolders(queryFactory);
        return list;
    }

    private List<CategoryLabel> getDB2Folders() {
        QueryFactory queryFactory = QueryFactory.getFactory("sqldev.nav", "DB2");
        List<CategoryLabel> list = this.findFolders(queryFactory);
        return list;
    }

    private List<CategoryLabel> getTimesTenFolders() {
        QueryFactory queryFactory = QueryFactory.getFactory("sqldev.nav", "TimesTen");
        List<CategoryLabel> list = this.findFolders(queryFactory);
        return list;
    }

    private List<CategoryLabel> getTeradataFolders() {
        QueryFactory queryFactory = QueryFactory.getFactory("sqldev.nav", "Teradata");
        List<CategoryLabel> list = this.findFolders(queryFactory);
        return list;
    }

    private List<CategoryLabel> getSQLServerFolders() {
        QueryFactory queryFactory = QueryFactory.getFactory("sqldev.nav", "SQLServer");
        List<CategoryLabel> list = this.findFolders(queryFactory);
        return list;
    }

    private List<CategoryLabel> getSybaseFolders() {
        QueryFactory queryFactory = QueryFactory.getFactory("sqldev.nav", "Sybase");
        List<CategoryLabel> list = this.findFolders(queryFactory);
        return list;
    }

    private List<CategoryLabel> getPostGreSQLFolders() {
        QueryFactory queryFactory = QueryFactory.getFactory("sqldev.nav", "PostgreSQL");
        List<CategoryLabel> list = this.findFolders(queryFactory);
        return list;
    }

    private List<CategoryLabel> getAccessFolders() {
        QueryFactory queryFactory = QueryFactory.getFactory("sqldev.nav", "Access");
        List<CategoryLabel> list = this.findFolders(queryFactory);
        return list;
    }

    public void onEntry(TraversableContext traversableContext) {
        NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance(traversableContext);
        navigatorFilterConfig.setNavigationPanel(this);
        this.featureEnabled = navigatorFilterConfig.isFeatureEnabled();
        this.oracleTree.setModel(this.mapToModel2(navigatorFilterConfig.getAllOracleElements(), this.oracleTreeModel));
        this.oracleTree.updateUI();
        this.timesTenTree.setModel(this.mapToModel2(navigatorFilterConfig.getAllTimesTenElements(), this.timesTenTreeModel));
        this.timesTenTree.updateUI();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this.oracleTree.getCellEditor() != null) {
            this.oracleTree.getCellEditor().stopCellEditing();
        }
        if (this.timesTenTree.getCellEditor() != null) {
            this.timesTenTree.getCellEditor().stopCellEditing();
        }
        NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance(traversableContext);
        navigatorFilterConfig.setNavigationPanel(this);
        navigatorFilterConfig.setFeatureEnabled(this.featureEnabled);
        navigatorFilterConfig.putAllOracleElements(this.modelToMap2(this.oracleTreeModel));
        navigatorFilterConfig.putAllTimesTenElements(this.modelToMap2(this.timesTenTreeModel));
    }

    public void init() {
        this.setHelpID("f1_idedidesetNavigationFilter_html");
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText(PreferencesArb.getString("NAVIGATION_FILTER_DES"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.add(jPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbedPane = new JTabbedPane();
        this.add(this.tabbedPane, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        String[] stringArray = new String[]{PreferencesArb.getString("NAVIGATOR_FILTER_TAB_LABEL_ORACLE"), PreferencesArb.getString("NAVIGATOR_FILTER_TAB_LABEL_TIMESTEN")};
        this.tabbedPane.add(stringArray[0], this.createOracleDbTypePanel());
        this.tabbedPane.add(stringArray[1], this.createTimesTenDbTypePanel());
        this.setInitialFeatureSettings();
        JCheckBox jCheckBox = new JCheckBox(this.featureEnableCheckboxLabel);
        this.add(jCheckBox, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 25, 0, new Insets(10, 5, 0, 0), 0, 0));
        jCheckBox.setSelected(this.featureEnabled);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance();
                NavigatorFilterPanel.this.featureEnabled = ((JCheckBox)actionEvent.getSource()).isSelected();
                NavigatorFilterPanel.this.enableNavigationFilterPanels(NavigatorFilterPanel.this.featureEnabled);
            }
        });
    }

    private void setInitialFeatureSettings() {
        NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance();
        this.featureEnabled = navigatorFilterConfig.isFeatureEnabled();
        this.enableNavigationFilterPanels(this.featureEnabled);
    }

    protected void enableNavigationFilterPanels(boolean bl) {
        int n = this.tabbedPane.getComponentCount();
        for (int i = 0; i < n; ++i) {
            String string = this.tabbedPane.getTitleAt(i);
            if (string.equals(PreferencesArb.getString("NAVIGATOR_FILTER_TAB_LABEL_ORACLE"))) {
                this.oracleTree.setEnabled(bl);
            } else if (string.equals(PreferencesArb.getString("NAVIGATOR_FILTER_TAB_LABEL_TIMESTEN"))) {
                this.timesTenTree.setEnabled(bl);
            }
            this.tabbedPane.setEnabledAt(i, bl);
        }
        this.tabbedPane.setEnabled(bl);
    }

    private JPanel createOracleDbTypePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.oracleTree = new NavigationFilterTree();
        TreeMap<String, Object> treeMap = this.createTreeMap2(this.getOracleFolders());
        this.oracleTreeModel = this.mapToModel2(treeMap, this.oracleTreeModel);
        this.oracleTree.setModel(this.oracleTreeModel);
        jScrollPane.setViewportView(this.oracleTree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createMySQLDbTypePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.mysqlTree = new NavigationFilterTree();
        TreeMap<String, Object> treeMap = this.createTreeMap2(this.getMySQLFolders());
        this.mysqlTreeModel = this.mapToModel2(treeMap, this.mysqlTreeModel);
        this.mysqlTree.setModel(this.mysqlTreeModel);
        jScrollPane.setViewportView(this.mysqlTree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createDB2DbTypePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.db2Tree = new NavigationFilterTree();
        TreeMap<String, Object> treeMap = this.createTreeMap2(this.getDB2Folders());
        this.db2TreeModel = this.mapToModel2(treeMap, this.db2TreeModel);
        this.mysqlTree.setModel(this.db2TreeModel);
        jScrollPane.setViewportView(this.db2Tree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createSybase2DbTypePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.sybaseTree = new NavigationFilterTree();
        TreeMap<String, Object> treeMap = this.createTreeMap2(this.getSybaseFolders());
        this.sybaseTreeModel = this.mapToModel2(treeMap, this.sybaseTreeModel);
        this.sybaseTree.setModel(this.sybaseTreeModel);
        jScrollPane.setViewportView(this.sybaseTree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createTimesTenDbTypePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.timesTenTree = new NavigationFilterTree();
        TreeMap<String, Object> treeMap = this.createTreeMap2(this.getTimesTenFolders());
        this.timesTenTreeModel = this.mapToModel2(treeMap, this.timesTenTreeModel);
        this.timesTenTree.setModel(this.timesTenTreeModel);
        jScrollPane.setViewportView(this.timesTenTree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createTeradataDbTypePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.teradataTree = new NavigationFilterTree();
        TreeMap<String, Object> treeMap = this.createTreeMap2(this.getTeradataFolders());
        this.teradataTreeModel = this.mapToModel2(treeMap, this.teradataTreeModel);
        this.teradataTree.setModel(this.teradataTreeModel);
        jScrollPane.setViewportView(this.teradataTree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createSQLServerDbTypePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.sqlServerTree = new NavigationFilterTree();
        TreeMap<String, Object> treeMap = this.createTreeMap2(this.getSQLServerFolders());
        this.sqlServerTreeModel = this.mapToModel2(treeMap, this.sqlServerTreeModel);
        this.sqlServerTree.setModel(this.sqlServerTreeModel);
        jScrollPane.setViewportView(this.sqlServerTree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createPostgresqlDbTypePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.postgresqlTree = new NavigationFilterTree();
        TreeMap<String, Object> treeMap = this.createTreeMap2(this.getPostGreSQLFolders());
        this.postgresqlTreeModel = this.mapToModel2(treeMap, this.postgresqlTreeModel);
        this.postgresqlTree.setModel(this.postgresqlTreeModel);
        jScrollPane.setViewportView(this.postgresqlTree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createAccessDbTypePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.accessTree = new NavigationFilterTree();
        TreeMap<String, Object> treeMap = this.createTreeMap2(this.getAccessFolders());
        this.accessTreeModel = this.mapToModel2(treeMap, this.accessTreeModel);
        this.accessTree.setModel(this.accessTreeModel);
        jScrollPane.setViewportView(this.accessTree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private DefaultTreeModel mapToModel2(TreeMap<String, Object> treeMap, DefaultTreeModel defaultTreeModel) {
        if (defaultTreeModel == null) {
            TriStateNode triStateNode = new TriStateNode((Object)PreferencesArb.getString("NAVIGATION_FOLDERS_NAME"));
            defaultTreeModel = new DefaultTreeModel((TreeNode)triStateNode);
            triStateNode.setNodeState(TriStateNode.NodeState.YES);
        }
        if (treeMap != null) {
            for (String string : treeMap.keySet()) {
                Object object = treeMap.get(string);
                this.findAndUpdate2(string, object, defaultTreeModel);
            }
        }
        return defaultTreeModel;
    }

    private void findAndUpdate2(String string, Object object, DefaultTreeModel defaultTreeModel) {
        boolean bl = false;
        TriStateNode triStateNode = (TriStateNode)defaultTreeModel.getRoot();
        for (int i = 0; i < defaultTreeModel.getChildCount(triStateNode); ++i) {
            TriStateNode triStateNode2 = (TriStateNode)defaultTreeModel.getChild(triStateNode, i);
            String string2 = triStateNode2.getLabel();
            if (object == null || !string2.equals(string)) continue;
            bl = true;
            if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    triStateNode2.setNodeState(TriStateNode.NodeState.YES);
                } else {
                    triStateNode2.setNodeState(TriStateNode.NodeState.NO);
                }
                if (bl) {
                    defaultTreeModel.reload((TreeNode)triStateNode2);
                    break;
                }
            }
            if (object instanceof TreeMap) {
                int n = 0;
                for (String string3 : ((TreeMap)object).keySet()) {
                    TriStateNode triStateNode3 = (TriStateNode)triStateNode2.getChildAt(n);
                    String string4 = triStateNode3.getLabel();
                    if (string4.equals(string3)) {
                        boolean bl2 = (Boolean)((TreeMap)object).get(string3);
                        if (bl2) {
                            triStateNode3.setNodeState(TriStateNode.NodeState.YES);
                        } else {
                            triStateNode3.setNodeState(TriStateNode.NodeState.NO);
                        }
                        defaultTreeModel.reload((TreeNode)triStateNode3);
                    }
                    ++n;
                }
            }
            if (bl) break;
        }
        if (!bl) {
            TriStateNode triStateNode4 = new TriStateNode((Object)string);
            if (object != null) {
                if (object instanceof Boolean) {
                    if (!((Boolean)object).booleanValue()) {
                        triStateNode4.setNodeState(TriStateNode.NodeState.NO);
                    } else {
                        triStateNode4.setNodeState(TriStateNode.NodeState.YES);
                    }
                    triStateNode.add((MutableTreeNode)triStateNode4);
                }
                if (object instanceof TreeMap) {
                    triStateNode4.setNodeState(TriStateNode.NodeState.YES);
                    triStateNode.add((MutableTreeNode)triStateNode4);
                    for (String string2 : ((TreeMap)object).keySet()) {
                        if (string2 == null) continue;
                        TriStateNode triStateNode5 = new TriStateNode((Object)string2);
                        Boolean bl3 = (Boolean)((TreeMap)object).get(string2);
                        if (!bl3.booleanValue()) {
                            triStateNode5.setNodeState(TriStateNode.NodeState.NO);
                        } else {
                            triStateNode5.setNodeState(TriStateNode.NodeState.YES);
                        }
                        triStateNode4.add((MutableTreeNode)triStateNode5);
                    }
                }
            }
        }
    }

    private TreeMap<String, Object> modelToMap2(DefaultTreeModel defaultTreeModel) {
        if (defaultTreeModel == null) {
            return null;
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        TriStateNode triStateNode = (TriStateNode)defaultTreeModel.getRoot();
        for (int i = 0; i < defaultTreeModel.getChildCount(triStateNode); ++i) {
            Object object;
            TriStateNode triStateNode2 = (TriStateNode)defaultTreeModel.getChild(triStateNode, i);
            String string = triStateNode2.getLabel();
            int n = triStateNode2.getChildCount();
            if (n == 0) {
                object = triStateNode2.getNodeState();
                String string2 = object.toString();
                if (string2.equals("YES")) {
                    treeMap.put(string, Boolean.TRUE);
                } else {
                    treeMap.put(string, Boolean.FALSE);
                }
            }
            if (n <= 0) continue;
            object = new TreeMap();
            for (int j = 0; j < n; ++j) {
                TriStateNode triStateNode3 = (TriStateNode)triStateNode2.getChildAt(j);
                String string3 = triStateNode3.getLabel();
                TriStateNode.NodeState nodeState = triStateNode3.getNodeState();
                String string4 = nodeState.toString();
                if (string4.equals("YES")) {
                    ((TreeMap)object).put(string3, Boolean.TRUE);
                    continue;
                }
                ((TreeMap)object).put(string3, Boolean.FALSE);
            }
            treeMap.put(string, object);
        }
        return treeMap;
    }

    public Object[][] convertDataIntoArray(Map<String, Boolean> map) {
        Object[][] objectArray = new Object[map.size()][2];
        int n = 0;
        for (String string : map.keySet()) {
            objectArray[n][0] = string;
            objectArray[n][1] = map.get(string);
            ++n;
        }
        return objectArray;
    }

    private TreeMap<String, Boolean> createTreeMap(Object[][] objectArray) {
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i][0];
                Boolean bl = (Boolean)objectArray[i][1];
                if (string == null || bl == null) continue;
                treeMap.put(string, bl);
            }
        }
        return treeMap;
    }

    private TreeMap<String, Object> createTreeMap2(List<CategoryLabel> list) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        List<String> list2 = this.findUniqueParents(list);
        if (list != null) {
            for (CategoryLabel categoryLabel : list) {
                TreeMap treeMap2;
                categoryLabel.getCategory();
                String string = categoryLabel.getLabel();
                String string2 = categoryLabel.getParent();
                if (string != null && string2.equals("FOLDER_ROOT")) {
                    if (list2.contains(string)) {
                        treeMap2 = new TreeMap();
                        treeMap.put(string, treeMap2);
                    } else {
                        treeMap.put(string, Boolean.TRUE);
                    }
                }
                if (string == null || string2.equals("FOLDER_ROOT") || !list2.contains(string2)) continue;
                treeMap2 = (TreeMap)treeMap.get(string2);
                treeMap2.put(string, Boolean.TRUE);
            }
        }
        return treeMap;
    }

    private List<String> findUniqueParents(List<CategoryLabel> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CategoryLabel categoryLabel : list) {
            String string = categoryLabel.getParent();
            if (string == null || string.equals("FOLDER_ROOT") || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private List<CategoryLabel> findFolders(QueryFactory queryFactory) {
        ArrayList<CategoryLabel> arrayList = new ArrayList<CategoryLabel>();
        ArrayList<CategoryLabel> arrayList2 = new ArrayList<CategoryLabel>();
        ArrayList<CategoryLabel> arrayList3 = new ArrayList<CategoryLabel>();
        ObjectCategory[] objectCategoryArray = queryFactory.listCategories();
        if (objectCategoryArray != null) {
            for (ObjectCategory objectCategory : objectCategoryArray) {
                if (objectCategory == null) continue;
                String string = objectCategory.getType();
                String string2 = objectCategory.getLabel();
                arrayList.add(new CategoryLabel("FOLDER_ROOT", string2, string2));
                ObjectType[] objectTypeArray = queryFactory.listTypes(string);
                if (objectTypeArray == null) continue;
                for (ObjectType categoryLabel : objectTypeArray) {
                    if (categoryLabel == null) continue;
                    String string3 = categoryLabel.getType();
                    String string4 = ((XmlFolderImpl[])categoryLabel.getFolders())[0].getLabel();
                    arrayList.add(new CategoryLabel(string2, string3, string4));
                }
            }
        }
        BaseElement[] baseElementArray = queryFactory.listTypes();
        String string = null;
        int n = 0;
        if (baseElementArray != null) {
            for (BaseElement baseElement : baseElementArray) {
                if (baseElement == null) continue;
                ObjectType[] objectTypeArray = baseElement.getType().trim();
                XmlFolderImpl[] xmlFolderImplArray = (XmlFolderImpl[])baseElement.getFolders();
                if (xmlFolderImplArray == null) continue;
                for (XmlFolderImpl xmlFolderImpl : xmlFolderImplArray) {
                    if (xmlFolderImpl == null) continue;
                    string = xmlFolderImpl.getLabel().trim();
                }
                n = 0;
                for (CategoryLabel categoryLabel : arrayList) {
                    if (!categoryLabel.getCategory().trim().equalsIgnoreCase((String)objectTypeArray)) continue;
                    n = 1;
                    break;
                }
                if (n != 0) continue;
                arrayList2.add(new CategoryLabel("FOLDER_ROOT", (String)objectTypeArray, string));
            }
        }
        arrayList3.addAll(arrayList);
        arrayList3.addAll(arrayList2);
        return arrayList3;
    }

    private void printList(List<String> list, String string) {
        System.out.println("**** print list ----------" + string);
        for (int i = 0; i < list.size(); ++i) {
            System.out.println("  <" + i + ">" + list.get(i));
        }
        System.out.println("**** --------------------");
    }

    private void printCategoryLabels(List<CategoryLabel> list) {
        System.out.println("**** CategoryLabels are as follows for ---");
        for (int i = 0; i < list.size(); ++i) {
            System.out.println("  <" + i + ">" + list.get(i));
        }
        System.out.println("**** -------------------------------------");
    }

    private void flushPreferenceCache(NavigatorFilterConfig navigatorFilterConfig) {
        navigatorFilterConfig.putAllOracleElements(this.modelToMap2(null));
        navigatorFilterConfig.putAllMySQLElements(this.modelToMap2(null));
        navigatorFilterConfig.putAllDB2Elements(this.modelToMap2(null));
    }

    private void printTreeMap(TreeMap<String, Object> treeMap, String string) {
        if (treeMap != null) {
            for (String string2 : treeMap.keySet()) {
                Object object = treeMap.get(string2);
                if (object == null) continue;
                if (object instanceof Boolean) {
                    System.out.println("---- ----[" + string2 + "," + object + "]");
                }
                if (!(object instanceof TreeMap)) continue;
                this.printTreeMap((TreeMap)object, string2);
            }
        }
    }

    public void updateOraclePreferences(NavigatorFilterConfig navigatorFilterConfig) {
        navigatorFilterConfig.putAllOracleElements(this.modelToMap2(this.oracleTreeModel));
    }

    public void updateMySQLPreferences(NavigatorFilterConfig navigatorFilterConfig) {
        navigatorFilterConfig.putAllMySQLElements(this.modelToMap2(this.mysqlTreeModel));
    }

    public void updateDB2Preferences(NavigatorFilterConfig navigatorFilterConfig) {
        navigatorFilterConfig.putAllDB2Elements(this.modelToMap2(this.db2TreeModel));
    }

    public void updateSybasePreferences(NavigatorFilterConfig navigatorFilterConfig) {
        navigatorFilterConfig.putAllSybaseElements(this.modelToMap2(this.sybaseTreeModel));
    }

    public void updateAccessPreferences(NavigatorFilterConfig navigatorFilterConfig) {
        navigatorFilterConfig.putAllAccessElements(this.modelToMap2(this.accessTreeModel));
    }

    public void updateTeradataPreferences(NavigatorFilterConfig navigatorFilterConfig) {
        navigatorFilterConfig.putAllTeradataElements(this.modelToMap2(this.teradataTreeModel));
    }

    public void updateSQLServerPreferences(NavigatorFilterConfig navigatorFilterConfig) {
        navigatorFilterConfig.putAllSQLServerElements(this.modelToMap2(this.sqlServerTreeModel));
    }

    public void updateTimesTenPreferences(NavigatorFilterConfig navigatorFilterConfig) {
        navigatorFilterConfig.putAllTimesTenElements(this.modelToMap2(this.timesTenTreeModel));
    }

    public void updatePostGreSQLPreferences(NavigatorFilterConfig navigatorFilterConfig) {
        navigatorFilterConfig.putAllPostGreSQLElements(this.modelToMap2(this.postgresqlTreeModel));
    }

    public void setRefresher(NavigationFilterTreeRefresher navigationFilterTreeRefresher) {
        this.refresher = navigationFilterTreeRefresher;
    }

    public NavigationFilterTreeRefresher getNavigationFilterTreeRefresher() {
        return this.refresher;
    }

    private class CategoryLabel {
        String mType = null;
        String mLabel = null;
        String mParent = "";

        CategoryLabel(String string, String string2, String string3) {
            this.mParent = string;
            this.mType = string2;
            this.mLabel = string3;
        }

        public String getCategory() {
            return this.mType;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String getParent() {
            return this.mParent;
        }

        public String toString() {
            return "Parent = " + this.mParent + " type = " + this.mType + ", label=" + this.mLabel;
        }
    }
}

