/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.navigator;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ide.net.URIFactory;
import oracle.dbtools.plugin.api.json.objects.JSONArray;
import oracle.dbtools.plugin.api.json.objects.JSONNode;
import oracle.dbtools.plugin.api.json.objects.JSONObject;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.connection.CConnection;
import oracle.dbtools.raptor.cloud.connection.CConnectionException;
import oracle.dbtools.raptor.cloud.connection.CloudTask;
import oracle.dbtools.raptor.cloud.connection.JSONNodeHandler;
import oracle.dbtools.raptor.cloud.connection.JSONUtils;
import oracle.dbtools.raptor.cloud.navigator.CloudConnection;
import oracle.dbtools.raptor.cloud.navigator.CloudController;
import oracle.dbtools.raptor.cloud.navigator.CloudFolder;
import oracle.dbtools.raptor.cloud.navigator.CloudObjectType;
import oracle.dbtools.raptor.navigator.model.AsynchronousNavigatorTreeNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.util.Logger;
import oracle.ide.model.Element;

public class ConnectionTreeNode
extends AsynchronousNavigatorTreeNode {
    @Override
    protected RaptorTask<Collection<Element>> getLoadingTask() {
        return new LoadTask((CloudConnection)this.getElement());
    }

    private CloudFolder createFolder(URL uRL, CloudObjectType cloudObjectType) {
        CloudFolder cloudFolder = new CloudFolder(uRL);
        cloudFolder.setObjectType(cloudObjectType);
        return cloudFolder;
    }

    private class LoadTask
    extends CloudTask<Collection<Element>> {
        private CloudConnection m_owner;
        private String m_cName;

        LoadTask(CloudConnection cloudConnection) {
            super(CloudBrowserResources.getString("TASK_CLOUD_CONNECT"), true, IRaptorTaskRunMode.TASKVIEWER);
            ConnectionTreeNode.this.setComparator(null);
            this.m_owner = cloudConnection;
            this.m_cName = this.m_owner.getConnectionName();
        }

        @Override
        protected String getConnectionName() {
            return this.m_cName;
        }

        protected Collection<Element> doWork() throws TaskException {
            List<Object> list = null;
            try {
                CConnection cConnection = this.m_owner.getConnection();
                URI uRI = cConnection.getDefaultServiceURI();
                list = cConnection.executeQuery(uRI, new JSONNodeHandler<List<Element>>(){

                    @Override
                    protected List<Element> build(JSONNode jSONNode) throws IOException {
                        ArrayList<Element> arrayList = new ArrayList<Element>();
                        JSONObject jSONObject = (JSONObject)jSONNode;
                        JSONArray jSONArray = (JSONArray)JSONUtils.getValue(jSONObject, "items");
                        this.checkJSONElement(jSONArray, "items");
                        for (Object t : jSONArray.values()) {
                            JSONObject jSONObject2 = (JSONObject)t;
                            String string = (String)JSONUtils.getValue(jSONObject2, "type");
                            this.checkJSONElement(string, "type");
                            JSONObject jSONObject3 = (JSONObject)JSONUtils.getValue(jSONObject2, "uri");
                            this.checkJSONElement(jSONObject3, "uri");
                            String string2 = (String)JSONUtils.getValue(jSONObject3, "$ref");
                            try {
                                CloudObjectType cloudObjectType = new CloudObjectType(string);
                                URL uRL = DBURLFormatHelper.getURL("sqldev.cloud", LoadTask.this.m_cName, null, null, string);
                                CloudFolder cloudFolder = ConnectionTreeNode.this.createFolder(uRL, cloudObjectType);
                                cloudFolder.setRemoteURI(URIFactory.newURI((String)string2));
                                cloudFolder.setConnectionName(LoadTask.this.m_owner.getConnectionName());
                                arrayList.add((Element)cloudFolder);
                            }
                            catch (Exception exception) {}
                        }
                        return arrayList;
                    }
                });
            }
            catch (CConnectionException cConnectionException) {
                Logger.warn(CloudController.class, (Throwable)cConnectionException);
                throw new TaskException((Throwable)cConnectionException);
            }
            catch (IOException iOException) {
                Logger.warn(CloudController.class, (Throwable)iOException);
                throw new TaskException((Throwable)iOException);
            }
            if (list == null) {
                list = Collections.emptyList();
            }
            return list;
        }
    }
}

