/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection;

import java.io.IOException;
import java.net.ProxySelector;
import oracle.dbtools.raptor.cloud.auth.AuthenticationEngine;
import oracle.dbtools.raptor.cloud.auth.basic.GUIBasicAuthenticationEngine;
import oracle.dbtools.raptor.cloud.auth.basic.HeadlessBasicAuthenticationEngine;
import oracle.dbtools.raptor.cloud.connection.CConnectionType;
import oracle.dbtools.raptor.cloud.connection.Client;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.Version;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.util.GuidGen;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.webupdate.CheckForUpdatesPreferences;
import oracle.ideimpl.webupdate.WebUpdateAddin;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;

final class DefaultClient
extends Client
implements ShutdownHook {
    private HttpClient m_client;
    private AuthenticationEngine m_engine;

    DefaultClient(CConnectionType cConnectionType) {
        super(cConnectionType);
        ExitCommand.addShutdownHook((ShutdownHook)this);
        SyncBasicHttpParams syncBasicHttpParams = new SyncBasicHttpParams();
        DefaultHttpClient.setDefaultHttpParams((HttpParams)syncBasicHttpParams);
        syncBasicHttpParams.setParameter("http.useragent", (Object)this.getUserAgent());
        syncBasicHttpParams.setParameter("http.socket.timeout", (Object)60000);
        this.m_client = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager(), (HttpParams)syncBasicHttpParams);
        ProxyOptions proxyOptions = ProxyOptions.getProxyOptions();
        proxyOptions.applyToCurrentVM();
        ProxySelectorRoutePlanner proxySelectorRoutePlanner = new ProxySelectorRoutePlanner(this.m_client.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
        ((DefaultHttpClient)this.m_client).setRoutePlanner((HttpRoutePlanner)proxySelectorRoutePlanner);
    }

    @Override
    public AuthenticationEngine getAuthenticationEngine() {
        if (this.m_engine == null) {
            this.m_engine = Ide.getIdeArgs().getCreateUI() ? new GUIBasicAuthenticationEngine() : new HeadlessBasicAuthenticationEngine();
            this.m_engine.init(this);
        }
        return this.m_engine;
    }

    @Override
    public HttpResponse executeRequest(HttpUriRequest httpUriRequest) throws ClientProtocolException, IOException {
        return this.m_client.execute(httpUriRequest);
    }

    @Override
    public <T> T executeRequest(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler) throws ClientProtocolException, IOException {
        return (T)this.m_client.execute(httpUriRequest, responseHandler);
    }

    private String getUserAgent() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Ide.getProgramShortName());
        stringBuffer.append("/");
        stringBuffer.append(Version.VER);
        stringBuffer.append(" (");
        stringBuffer.append(System.getProperty("os.name"));
        stringBuffer.append(" ");
        stringBuffer.append(System.getProperty("os.version"));
        stringBuffer.append("; ");
        stringBuffer.append(System.getProperty("os.arch"));
        stringBuffer.append("; Java ");
        stringBuffer.append(System.getProperty("java.version"));
        stringBuffer.append("; ");
        stringBuffer.append(this.getSystemGuid());
        stringBuffer.append("; ");
        stringBuffer.append(ProductInformation.getProductInformation().getUserAgentExtras());
        stringBuffer.append(") ");
        stringBuffer.append(Version.VER_FULL);
        return stringBuffer.toString();
    }

    private String getSystemGuid() {
        CheckForUpdatesPreferences checkForUpdatesPreferences = WebUpdateAddin.getPreferences();
        String string = checkForUpdatesPreferences.getInstanceGuid();
        if (string == null) {
            string = GuidGen.toString((byte[])GuidGen.uuidCreate());
            checkForUpdatesPreferences.setInstanceGuid(string);
        }
        return string;
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
        this.m_client.getConnectionManager().shutdown();
    }
}

