/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.auth.basic;

import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.Iterator;
import oracle.dbtools.plugin.api.json.JSONReader;
import oracle.dbtools.plugin.api.json.JSONToken;
import oracle.dbtools.raptor.cloud.auth.Authentication;
import oracle.dbtools.raptor.cloud.auth.AuthenticationEngine;
import oracle.dbtools.raptor.cloud.auth.AuthenticationFailedException;
import oracle.dbtools.raptor.cloud.auth.CloudProtocolException;
import oracle.dbtools.raptor.cloud.connection.Client;
import oracle.dbtools.raptor.cloud.connection.CloudHander;
import oracle.dbtools.raptor.cloud.connection.JSONUtils;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Pair;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;

public class BasicAuthenticationHandler
extends CloudHander<Authentication> {
    private static final String RESPONSE_ERROR_DESCRIPTION = "error_description";
    private static final String RESPONSE_ERROR = "error";
    private static final String MESSAGE = "Expected token {0}, encountered {1}";
    private static final String MESSAGE2 = "Unexpected token {0} encountered";
    private StringBuilder m_builder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<String, String> parseErrorString(HttpResponse httpResponse) {
        String string = null;
        String string2 = null;
        Reader reader = null;
        JSONReader jSONReader = null;
        try {
            reader = Client.createReader(httpResponse);
            jSONReader = JSONUtils.streams().jsonReader((Readable)reader);
            boolean bl = false;
            block20: while (jSONReader.hasNext()) {
                JSONToken jSONToken = jSONReader.next();
                switch (jSONToken.type()) {
                    case START_OBJECT: {
                        if (bl) break;
                        bl = true;
                        continue block20;
                    }
                    case END_OBJECT: {
                        break;
                    }
                    case PROPERTY_NAME: {
                        if (bl) {
                            String string3 = jSONToken.propertyName();
                            JSONToken jSONToken2 = jSONReader.next();
                            switch (jSONToken2.type()) {
                                case NULL_VALUE: {
                                    break;
                                }
                                case STRING_VALUE: {
                                    String string4 = jSONToken2.stringValue();
                                    if (RESPONSE_ERROR.equals(string3)) {
                                        string = string4;
                                        break;
                                    }
                                    if (!RESPONSE_ERROR_DESCRIPTION.equals(string3)) break;
                                    string2 = string4;
                                    break;
                                }
                            }
                            continue block20;
                        } else {
                            break;
                        }
                    }
                }
                break;
            }
        }
        finally {
            if (jSONReader != null) {
                try {
                    jSONReader.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        Logger.warn(BasicAuthenticationHandler.class, (String)MessageFormat.format("{0}: {1}", string, string2));
        return new Pair(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Authentication parseAuthentication(HttpResponse httpResponse) throws IOException {
        Authentication authentication;
        block18: {
            authentication = new Authentication();
            Reader reader = null;
            JSONReader jSONReader = null;
            try {
                this.startLog();
                this.log("JSON document:");
                reader = Client.createReader(httpResponse);
                jSONReader = JSONUtils.streams().jsonReader((Readable)reader);
                boolean bl = false;
                while (jSONReader.hasNext()) {
                    JSONToken jSONToken = jSONReader.next();
                    switch (jSONToken.type()) {
                        case START_OBJECT: {
                            if (bl) {
                                throw new JSONFormatException(jSONToken.type());
                            }
                            bl = true;
                            this.log("{\n");
                            break;
                        }
                        case END_OBJECT: {
                            if (!bl) {
                                throw new JSONFormatException(jSONToken.type());
                            }
                            this.log("\n}");
                            break block18;
                        }
                        case PROPERTY_NAME: {
                            if (bl) {
                                Pair<String, String> pair = this.readProperty((Iterator<JSONToken>)jSONReader, jSONToken);
                                authentication.putValue((String)pair.first(), (String)pair.second());
                                break;
                            }
                        }
                        default: {
                            throw new JSONFormatException(jSONToken.type());
                        }
                    }
                }
            }
            finally {
                this.closeLog();
                if (jSONReader != null) {
                    try {
                        jSONReader.close();
                    }
                    catch (Exception exception) {}
                }
                if (reader != null) {
                    reader.close();
                }
            }
        }
        return authentication;
    }

    private Pair<String, String> readProperty(Iterator<JSONToken> iterator, JSONToken jSONToken) throws CloudProtocolException {
        String string;
        String string2 = jSONToken.propertyName();
        JSONToken jSONToken2 = iterator.next();
        switch (jSONToken2.type()) {
            case NULL_VALUE: {
                string = null;
                break;
            }
            case STRING_VALUE: {
                string = jSONToken2.stringValue();
                break;
            }
            case NUMERIC_VALUE: {
                string = jSONToken2.numberValue().toString();
                break;
            }
            case BOOLEAN_VALUE: {
                string = Boolean.toString(jSONToken2.booleanValue());
                break;
            }
            default: {
                throw new JSONFormatException(jSONToken2.type());
            }
        }
        if (RESPONSE_ERROR.equals(string2)) {
            throw new AuthenticationFailedException(string);
        }
        this.log("\n  <" + string2 + "=" + string + ">");
        return Pair.pair((Object)string2, (Object)string);
    }

    @Override
    protected Authentication handleSuccess(HttpResponse httpResponse) throws ClientProtocolException, IOException {
        return this.parseAuthentication(httpResponse);
    }

    @Override
    protected IOException createInternalServerError(String string, String string2, String string3) {
        return new AuthenticationFailedException(string, string2, string3);
    }

    @Override
    protected Authentication handleError(HttpResponse httpResponse) throws ClientProtocolException, IOException {
        StatusLine statusLine = httpResponse.getStatusLine();
        int n = statusLine.getStatusCode();
        switch (n) {
            case 400: {
                Pair<String, String> pair = BasicAuthenticationHandler.parseErrorString(httpResponse);
                if (pair == null) break;
                throw new AuthenticationFailedException((String)pair.first(), (String)pair.second());
            }
        }
        throw new IOException(statusLine.toString());
    }

    private void startLog() {
        this.m_builder = new StringBuilder();
    }

    private void log(String string) {
        if (this.m_builder != null) {
            this.m_builder.append(string);
        }
    }

    private void closeLog() {
        Logger.fine(AuthenticationEngine.class, (String)this.m_builder.toString());
        this.m_builder = null;
    }

    private static class JSONFormatException
    extends AuthenticationFailedException {
        private static final long serialVersionUID = 1L;

        JSONFormatException(JSONToken.Type type, JSONToken jSONToken) {
            super(MessageFormat.format(BasicAuthenticationHandler.MESSAGE, type, jSONToken));
        }

        JSONFormatException(JSONToken.Type type) {
            super(MessageFormat.format(BasicAuthenticationHandler.MESSAGE2, type));
        }

        JSONFormatException(String string) {
            super(string);
        }
    }
}

