/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.filenav.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.app.Obfuscator;
import oracle.dbtools.app.Rewrite;
import oracle.dbtools.app.SqlId;
import oracle.dbtools.raptor.filenav.FileNavigatorContextMenuListener;
import oracle.dbtools.raptor.filenav.Messages;
import oracle.dbtools.raptor.filenav.dialogs.SerializedData;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Log;

public class FileSelectionPanel
extends JPanel
implements ActionListener {
    JLabel prefixLabel = new JLabel(Messages.getString("Prefix"));
    JTextField prefixField = new JTextField("SQL", 12);
    JCheckBox star = new JCheckBox("*.*", false);
    JCheckBox[] extensions = new JCheckBox[]{new JCheckBox("*.plb", false), new JCheckBox("*.pkb", false), new JCheckBox("*.pls", false), new JCheckBox("*.sql", false)};
    JPanel upper = new JPanel();
    JPanel lower = new JPanel();
    private File dir;
    private int type;

    public FileSelectionPanel(File file, int n) {
        this.prefixField.setText(SerializedData.getInstance().prefix);
        this.dir = file;
        this.type = n;
        if (!file.isDirectory()) {
            this.lower.setEnabled(false);
            this.star.setEnabled(false);
            for (JCheckBox jCheckBox : this.extensions) {
                jCheckBox.setEnabled(false);
            }
            this.star.setSelected(true);
            for (JCheckBox jCheckBox : this.extensions) {
                jCheckBox.setSelected(false);
            }
        }
        this.setLayout(new BoxLayout(this, 1));
        if (n == FileNavigatorContextMenuListener.STAMP_SQL_ID) {
            this.upper.setBorder(BorderFactory.createTitledBorder(""));
            this.upper.add(this.prefixLabel);
            this.upper.add(this.prefixField);
            this.add(this.upper);
        }
        this.lower.setBorder(BorderFactory.createTitledBorder(Messages.getString("File.Extensions")));
        this.lower.setLayout(new GridLayout(0, 2, 0, 0));
        this.star.addActionListener(this);
        for (JCheckBox jCheckBox : this.extensions) {
            jCheckBox.addActionListener(this);
            if (!SerializedData.getInstance().checkboxes.contains(jCheckBox.getText())) continue;
            jCheckBox.setSelected(true);
        }
        this.lower.add(this.star);
        this.lower.add(this.extensions[0]);
        for (int i = 1; i < this.extensions.length; ++i) {
            JCheckBox jCheckBox = this.extensions[i];
            this.lower.add(new JLabel());
            this.lower.add(jCheckBox);
        }
        this.add(this.lower);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.star) {
            for (JCheckBox jCheckBox : this.extensions) {
                jCheckBox.setSelected(false);
            }
        } else {
            for (JCheckBox jCheckBox : this.extensions) {
                if (object != jCheckBox) continue;
                this.star.setSelected(false);
            }
        }
    }

    public void showDialog() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_sqlidinfo_html");
        int n = 8;
        final JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this, null, (String)Messages.getString("File.Filter.Dialog"), (int)(4 | n | 2));
        jEWTDialog.setDefaultButton(n);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SerializedData serializedData;
                if (FileSelectionPanel.this.dir.isDirectory()) {
                    serializedData = SerializedData.getInstance();
                    serializedData.prefix = FileSelectionPanel.this.prefixField.getText();
                    serializedData.checkboxes = FileSelectionPanel.this.getFileExtensions();
                    SerializedData.write();
                }
                jEWTDialog.setVisible(false);
                jEWTDialog.dispose();
                serializedData = null;
                if (FileSelectionPanel.this.type == FileNavigatorContextMenuListener.STAMP_SQL_ID) {
                    serializedData = new SqlId(FileSelectionPanel.this.prefixField.getText(), FileSelectionPanel.this.getFileExtensions());
                } else if (FileSelectionPanel.this.type == FileNavigatorContextMenuListener.OBFUSCATE_ID) {
                    serializedData = new Obfuscator(FileSelectionPanel.this.getFileExtensions());
                }
                FileSelectionPanel.this.walkDirWithProgress((Rewrite)serializedData, FileSelectionPanel.this.dir);
            }
        };
        jEWTDialog.addActionListener(actionListener);
        jEWTDialog.setSize(this.upper.getPreferredSize().width * 150 / 100, this.lower.getPreferredSize().height * 250 / 100);
        if (jEWTDialog.getSize().width < 400) {
            jEWTDialog.setSize(400, jEWTDialog.getSize().height);
        }
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
    }

    public Set<String> getFileExtensions() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.star.isSelected()) {
            hashSet.add(this.star.getText());
        }
        for (JCheckBox jCheckBox : this.extensions) {
            if (!jCheckBox.isSelected()) continue;
            hashSet.add(jCheckBox.getText());
        }
        return hashSet;
    }

    private String dlgAction() {
        if (this.type == FileNavigatorContextMenuListener.STAMP_SQL_ID) {
            return Messages.getString("Tagging");
        }
        if (this.type == FileNavigatorContextMenuListener.OBFUSCATE_ID) {
            return Messages.getString("Obfuscating");
        }
        return "???";
    }

    public void walkDirWithProgress(final Rewrite rewrite, final File file) {
        class MyRunnable
        implements Runnable {
            ProgressBar _progressBar;

            public MyRunnable() {
                this._progressBar = new ProgressBar((Component)Ide.getMainWindow(), FileSelectionPanel.this.dlgAction() + " files...", (Runnable)this, false);
            }

            public void start() {
                this._progressBar.start(FileSelectionPanel.this.dlgAction() + " SQL in " + file.getName(), file.getPath());
            }

            @Override
            public void run() {
                this.walkDir(file);
                this._progressBar.setDoneStatus();
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)rewrite.log(), (String)"Task finished", null);
            }

            private void walkDir(File file3) {
                block4: {
                    block3: {
                        this._progressBar.updateProgress(rewrite.fileCnt, "Processing ", file3.getName());
                        if (!file3.isDirectory()) break block3;
                        File[] fileArray = file3.listFiles();
                        if (fileArray == null) break block4;
                        for (File file2 : fileArray) {
                            this.walkDir(file2);
                        }
                        break block4;
                    }
                    try {
                        rewrite.rewrite(file3);
                    }
                    catch (Exception exception) {
                        Log.error((String)exception.getMessage());
                    }
                }
            }
        }
        new MyRunnable().start();
    }
}

