/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security;

import java.util.ArrayList;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.SecurityContextMap;

public class UserRoleEvaluator
extends SecurityContextMap {
    private SecurityContext mSecurityContext;
    private boolean checkAllRoles = false;
    private static final String DELIMITER = "[;,]";

    public UserRoleEvaluator(SecurityContext secCtx, boolean inAllRoles) {
        this.mSecurityContext = secCtx;
        this.checkAllRoles = inAllRoles;
    }

    @Override
    protected Object internalGet(String key) {
        ArrayList<String> roles = new ArrayList<String>(1);
        UserRoleEvaluator.tokenize(key, roles);
        boolean isInRole = false;
        for (int i = 0; i < roles.size(); ++i) {
            isInRole = this.mSecurityContext.isUserInRole(roles.get(i));
            if (!isInRole && this.checkAllRoles) {
                return Boolean.FALSE;
            }
            if (!isInRole || this.checkAllRoles) continue;
            return Boolean.TRUE;
        }
        return new Boolean(isInRole);
    }

    static void tokenize(String key, ArrayList<String> roles) {
        String[] tokens = key.split(DELIMITER);
        for (int i = 0; i < tokens.length; ++i) {
            String value = tokens[i];
            if (value != null) {
                value = value.trim();
            }
            if (value == null || value.length() == 0) continue;
            roles.add(value);
        }
    }
}

