/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security;

import java.beans.Beans;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.adf.share.ADFContext;
import oracle.adf.share.common.util.AdfPlatformFactoryResolver;
import oracle.adf.share.config.ADFConfigCallback;
import oracle.adf.share.config.ADFConfigParsingContext;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.platform.AdfServerPlatformSupport;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.SecurityEnv;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADFSecurityConfig
implements ADFConfigCallback {
    public static final String namespaceURI = "http://xmlns.oracle.com/adf/security/config";
    public static final String JAAS_SECURITY_CONTEXT = "JaasSecurityContext";
    public static final String CREDENTIALSTORE_CONTEXT = "CredentialStoreContext";
    public static final String SECURITY_METADATA = "SecurityMetadata";
    public static final String MULTI_LEVEL_AUTH = "MultiLevelAuth";
    private static final ADFLogger _adfSecLogger = ADFSecurityUtil.getADFLogger();

    @Override
    public Map parseADFConfiguration(Element el, Map storedResult, ADFConfigParsingContext currentCtx) {
        NamedNodeMap nodeMap;
        Node node;
        int i;
        NodeList nl0;
        if (storedResult != null) {
            return storedResult;
        }
        ConcurrentHashMap<String, String> securityContextEnv = new ConcurrentHashMap<String, String>(12);
        Element elem = null;
        NodeList nl = el.getElementsByTagName(JAAS_SECURITY_CONTEXT);
        if (nl.getLength() > 0) {
            elem = (Element)nl.item(0);
            for (int i2 = 0; i2 < SecurityEnv.SECURITY_CONFIG.length; ++i2) {
                this.setConfigAttribute(securityContextEnv, elem, SecurityEnv.SECURITY_CONFIG[i2][0], SecurityEnv.SECURITY_CONFIG[i2][1]);
            }
        }
        if ((nl0 = el.getElementsByTagName("contextEnv")).getLength() > 0) {
            for (int i3 = 0; i3 < nl0.getLength(); ++i3) {
                Element elem1 = (Element)nl0.item(i3);
                securityContextEnv.put(elem1.getAttribute("name"), elem1.getAttribute("value"));
            }
        }
        NodeList nl1 = el.getElementsByTagName(MULTI_LEVEL_AUTH);
        for (i = 0; i < nl1.getLength(); ++i) {
            node = nl1.item(i);
            if (!node.hasAttributes()) continue;
            nodeMap = node.getAttributes();
            this.retrieveMultiLevelAuthAttributes(securityContextEnv, nodeMap);
        }
        nl1 = el.getElementsByTagName(SECURITY_METADATA);
        for (i = 0; i < nl1.getLength(); ++i) {
            node = nl1.item(i);
            if (!node.hasAttributes()) continue;
            nodeMap = node.getAttributes();
            this.retrieveSecurityMetadataAttributes(securityContextEnv, nodeMap);
        }
        nl = el.getElementsByTagName(CREDENTIALSTORE_CONTEXT);
        if (nl.getLength() <= 0) {
            return securityContextEnv;
        }
        elem = (Element)nl.item(0);
        for (i = 0; i < SecurityEnv.CREDENTIALSTORE_CONFIG.length; ++i) {
            this.setConfigAttribute(securityContextEnv, elem, SecurityEnv.CREDENTIALSTORE_CONFIG[i][0], SecurityEnv.CREDENTIALSTORE_CONFIG[i][1]);
        }
        ADFSecurityConfig.resetSecurityEnvForNonJps(securityContextEnv);
        return securityContextEnv;
    }

    void setConfigAttribute(Map securityContextEnv, Element elem, String attr, String prop) {
        String value = elem.getAttribute(attr);
        if (value != null & value.length() > 0) {
            securityContextEnv.put(prop, value);
        }
    }

    void retrieveMultiLevelAuthAttributes(Map securityContextEnv, NamedNodeMap nodeMap) {
        Hashtable<String, String> env = new Hashtable<String, String>(3);
        String key = null;
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            Node node = nodeMap.item(i);
            String name = node.getNodeName();
            String value = node.getNodeValue();
            if (name != null && name.equals("authLevel") && value != null) {
                key = name.concat(value);
            }
            env.put(name, value);
        }
        if (key != null) {
            securityContextEnv.put(key, env);
        }
    }

    void retrieveSecurityMetadataAttributes(Map securityContextEnv, NamedNodeMap nodeMap) {
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            Node node = nodeMap.item(i);
            String name = node.getNodeName();
            String value = node.getNodeValue();
            if (name == null || value == null) continue;
            securityContextEnv.put(name, value);
        }
    }

    static void resetSecurityEnvForNonJps(Map env) {
        block6: {
            if (!ADFContext.hasCurrent() || !ADFContext.getCurrent().isJEE()) {
                return;
            }
            try {
                AdfServerPlatformSupport platformSupport = AdfPlatformFactoryResolver.getAdfServerPlatformSupport();
                if (!platformSupport.isWebLogic()) {
                    if (!platformSupport.isWebSphere()) {
                        String contextName;
                        String string = contextName = env != null ? (String)env.get("oracle.adf.security.context") : null;
                        if (contextName == null || contextName.equals("oracle.adf.share.security.providers.jps.JpsSecurityContext")) {
                            _adfSecLogger.finest("Platform default is security disable.");
                            env.put("oracle.adf.security.context", "oracle.adf.share.security.SecurityContextImpl");
                            env.put("oracle.adf.security.authentication.require", Boolean.FALSE.toString());
                            env.put("oracle.adf.security.authorization.enforce", Boolean.FALSE.toString());
                        }
                    }
                }
            }
            catch (Throwable t) {
                if (!_adfSecLogger.isFine() || Beans.isDesignTime()) break block6;
                _adfSecLogger.fine(t);
            }
        }
    }
}

