/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.util.Hashtable;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.adf.share.jndi.DOMBackingStoreListener;
import oracle.adf.share.jndi.DocumentBackingStore;
import oracle.adf.share.logging.ADFLogger;
import org.w3c.dom.Document;

public class DOMBackingStore
extends DocumentBackingStore {
    private ADFLogger mLogger = null;
    private Document mDocument = null;
    private boolean readOnly = false;
    private DOMBackingStoreListener listener = null;

    @Override
    public void initialize(Hashtable contextEnv, String url) throws Exception {
        Object providerURL;
        Object backingStoreListener;
        Object readOnlyStore;
        super.initialize(contextEnv, url);
        if (this.getLogger().isFinest()) {
            this.getLogger().log(Level.FINEST, "DOMBackingStore is being initialized");
        }
        if ((readOnlyStore = contextEnv.get("oracle.adf.share.jndi.DocumentBackingStore.isReadOnly")) instanceof String) {
            this.readOnly = Boolean.parseBoolean((String)readOnlyStore);
        }
        if ((backingStoreListener = contextEnv.get("oracle.adf.share.jndi.DOMBackingStore.listener")) instanceof DOMBackingStoreListener) {
            this.listener = (DOMBackingStoreListener)backingStoreListener;
        }
        if ((providerURL = contextEnv.get("java.naming.provider.url")) instanceof Document) {
            this.mDocument = (Document)providerURL;
        }
    }

    @Override
    public boolean documentExists(String url) {
        return this.mDocument != null;
    }

    @Override
    public Document readDocument(String url) {
        return this.mDocument;
    }

    @Override
    public Document createDocument(String url) throws Exception {
        if (this.readOnly) {
            throw new UnsupportedOperationException("ReadOnly");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    @Override
    public void writeDocument(Document doc, String url) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("ReadOnly");
        }
        this.mDocument = doc;
        if (this.listener != null) {
            this.listener.save(this.mDocument);
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    private ADFLogger getLogger() {
        if (this.mLogger == null) {
            this.mLogger = ADFLogger.createADFLogger(this.getClass());
        }
        return this.mLogger;
    }
}

