/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.patch;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNStatusUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatch;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchFileStream;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchHunk;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchHunkInfo;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPatchTarget {
    private static final int MAX_FUZZ = 2;
    private SVNPatch patch;
    private List lines = new ArrayList();
    private List hunks = new ArrayList();
    private boolean localMods;
    private boolean executable;
    private boolean skipped;
    private String eolStr;
    private Map keywords;
    private String eolStyle;
    private SVNNodeKind kind;
    private int currentLine;
    private boolean modified;
    private boolean hadRejects;
    private boolean deleted;
    private boolean eof;
    private boolean added;
    private File absPath;
    private File relPath;
    private File canonPathFromPatchfile;
    private RandomAccessFile file;
    private SVNPatchFileStream stream;
    private File patchedPath;
    private OutputStream patchedRaw;
    private OutputStream patched;
    private File rejectPath;
    private SVNPatchFileStream reject;
    private boolean parentDirExists;

    private SVNPatchTarget() {
    }

    public boolean isLocalMods() {
        return this.localMods;
    }

    public String getEolStr() {
        return this.eolStr;
    }

    public Map getKeywords() {
        return this.keywords;
    }

    public String getEolStyle() {
        return this.eolStyle;
    }

    public RandomAccessFile getFile() {
        return this.file;
    }

    public OutputStream getPatchedRaw() {
        return this.patchedRaw;
    }

    public File getCanonPathFromPatchfile() {
        return this.canonPathFromPatchfile;
    }

    public SVNPatch getPatch() {
        return this.patch;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isEof() {
        return this.eof;
    }

    public List getLines() {
        return this.lines;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public List getHunks() {
        return this.hunks;
    }

    public SVNNodeKind getKind() {
        return this.kind;
    }

    public SVNPatchFileStream getStream() {
        return this.stream;
    }

    public OutputStream getPatched() {
        return this.patched;
    }

    public SVNPatchFileStream getReject() {
        return this.reject;
    }

    public File getPatchedPath() {
        return this.patchedPath;
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public File getRejectPath() {
        return this.rejectPath;
    }

    public File getAbsPath() {
        return this.absPath;
    }

    public File getRelPath() {
        return this.relPath;
    }

    public boolean isHadRejects() {
        return this.hadRejects;
    }

    public boolean isParentDirExists() {
        return this.parentDirExists;
    }

    public static SVNPatchTarget initPatchTarget(SVNPatch patch, File baseDir, int stripCount, SVNAdminArea wc) throws SVNException, IOException {
        SVNPatchTarget new_target = new SVNPatchTarget();
        new_target.resolveTargetPath(patch.getNewFilename(), baseDir, stripCount, wc);
        new_target.localMods = false;
        new_target.executable = false;
        if (!new_target.skipped) {
            String nativeEOLMarker;
            new_target.eolStr = nativeEOLMarker = SVNFileUtil.getNativeEOLMarker(wc.getWCAccess().getOptions());
            new_target.keywords = null;
            new_target.eolStyle = null;
            if (new_target.kind == SVNNodeKind.FILE) {
                String eol_style_val;
                new_target.file = SVNFileUtil.openRAFileForReading(new_target.absPath);
                new_target.stream = SVNPatchFileStream.openReadOnly(new_target.absPath);
                SVNVersionedProperties props = wc.getProperties(new_target.absPath.getAbsolutePath());
                String keywords_val = props.getStringPropertyValue("svn:keywords");
                if (null != keywords_val) {
                    SVNEntry entry = wc.getEntry(new_target.absPath.getAbsolutePath(), false);
                    long changed_rev = entry.getRevision();
                    String author = entry.getAuthor();
                    String changed_date = entry.getCommittedDate();
                    String url = entry.getURL();
                    String rev_str = Long.toString(changed_rev);
                    new_target.keywords = SVNTranslator.computeKeywords(keywords_val, url, author, changed_date, rev_str, wc.getWCAccess().getOptions());
                }
                if (null != (eol_style_val = props.getStringPropertyValue("svn:eol-style"))) {
                    new_target.eolStyle = new String(SVNTranslator.getEOL(eol_style_val, wc.getWCAccess().getOptions()));
                } else {
                    new_target.eolStr = SVNPatchTarget.detectFileEOL(new_target.file);
                    new_target.eolStyle = null;
                }
                if (new_target.eolStyle == null) {
                    new_target.eolStr = nativeEOLMarker;
                    new_target.eolStyle = "native";
                }
                new_target.localMods = wc.hasTextModifications(new_target.absPath.getAbsolutePath(), false);
                new_target.executable = SVNFileUtil.isExecutable(new_target.absPath);
            }
            new_target.patchedPath = SVNFileUtil.createTempFile("", null);
            new_target.patchedRaw = SVNFileUtil.openFileForWriting(new_target.patchedPath);
            new_target.patched = SVNTranslator.getTranslatingOutputStream(new_target.patchedRaw, null, new_target.eolStr.getBytes(), new_target.eolStyle != null, new_target.keywords, true);
            new_target.rejectPath = SVNFileUtil.createTempFile("", null);
            new_target.reject = SVNPatchFileStream.openForWrite(new_target.rejectPath);
            String diff_header = "--- " + new_target.canonPathFromPatchfile + nativeEOLMarker + "+++ " + new_target.canonPathFromPatchfile + nativeEOLMarker;
            new_target.reject.write(diff_header);
        }
        new_target.patch = patch;
        new_target.currentLine = 1;
        new_target.modified = false;
        new_target.hadRejects = false;
        new_target.deleted = false;
        new_target.eof = false;
        new_target.lines = new ArrayList();
        new_target.hunks = new ArrayList();
        return new_target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String detectFileEOL(RandomAccessFile file) throws IOException {
        long pos;
        block5: {
            String string;
            block4: {
                pos = file.getFilePointer();
                try {
                    int b1;
                    BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file.getFD()));
                    StringBuffer buf = new StringBuffer();
                    while ((b1 = stream.read()) > 0) {
                        char c2;
                        int b2;
                        char c1 = (char)b1;
                        if (c1 != '\n' && c1 != '\r') continue;
                        buf.append(c1);
                        if (c1 == '\r' && (b2 = stream.read()) > 0 && (c2 = (char)b2) == '\n') {
                            buf.append(c2);
                        }
                        string = buf.toString();
                        Object var10_9 = null;
                        break block4;
                    }
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    file.seek(pos);
                    throw throwable;
                }
            }
            file.seek(pos);
            return string;
        }
        Object var10_10 = null;
        file.seek(pos);
        return null;
    }

    private void resolveTargetPath(File pathFromPatchfile, File absWCPath, int stripCount, SVNAdminArea wc) throws SVNException, IOException {
        SVNPatchTarget target = this;
        target.canonPathFromPatchfile = pathFromPatchfile;
        if ("".equals(target.canonPathFromPatchfile.getPath())) {
            target.skipped = true;
            target.kind = SVNNodeKind.FILE;
            target.absPath = null;
            target.relPath = null;
            return;
        }
        File stripped_path = stripCount > 0 ? this.stripPath(target.canonPathFromPatchfile, stripCount) : target.canonPathFromPatchfile;
        if (stripped_path.isAbsolute()) {
            target.relPath = this.getChildPath(absWCPath, stripped_path);
            if (null == target.relPath) {
                target.skipped = true;
                target.kind = SVNNodeKind.FILE;
                target.absPath = null;
                target.relPath = stripped_path;
                return;
            }
        } else {
            target.relPath = stripped_path;
        }
        if (!this.isChildPath(absWCPath, target.relPath)) {
            target.skipped = true;
            target.kind = SVNNodeKind.FILE;
            target.absPath = null;
            return;
        }
        target.absPath = new File(absWCPath, target.relPath.getPath());
        SVNStatus status = SVNStatusUtil.getStatus(target.absPath, wc.getWCAccess());
        SVNStatusType contentsStatus = status.getContentsStatus();
        if (contentsStatus == SVNStatusType.STATUS_UNVERSIONED || contentsStatus == SVNStatusType.STATUS_IGNORED || contentsStatus == SVNStatusType.STATUS_OBSTRUCTED) {
            target.skipped = true;
            target.kind = SVNFileType.getNodeKind(SVNFileType.getType(target.absPath));
            return;
        }
        target.kind = status.getKind();
        if (SVNNodeKind.FILE.equals(target.kind)) {
            target.added = false;
            target.parentDirExists = true;
        } else if (SVNNodeKind.NONE.equals(target.kind) || SVNNodeKind.UNKNOWN.equals(target.kind)) {
            target.added = true;
            File absDirname = target.absPath.getParentFile();
            SVNStatus status2 = SVNStatusUtil.getStatus(absDirname, wc.getWCAccess());
            SVNStatusType contentsStatus2 = status2.getContentsStatus();
            SVNNodeKind kind = status2.getKind();
            target.parentDirExists = kind == SVNNodeKind.DIR && contentsStatus2 != SVNStatusType.STATUS_DELETED && contentsStatus2 != SVNStatusType.STATUS_MISSING;
        } else {
            target.skipped = true;
        }
    }

    private boolean isChildPath(File baseFile, File file) throws IOException {
        if (null != file && baseFile != null) {
            String basePath = baseFile.getCanonicalPath();
            File childFile = new File(basePath, file.getPath());
            String childPath = childFile.getCanonicalPath();
            return childPath.startsWith(basePath) && childPath.length() > basePath.length();
        }
        return false;
    }

    private File getChildPath(File basePath, File childPath) throws IOException {
        if (null != childPath && basePath != null) {
            String base = basePath.getCanonicalPath();
            String child = childPath.getCanonicalPath();
            if (child.startsWith(base) && child.length() > base.length()) {
                String substr = child.substring(base.length());
                File subPath = new File(substr);
                if (!subPath.isAbsolute()) {
                    return subPath;
                }
                if (substr.length() > 1 && !(subPath = new File(substr = substr.substring(1))).isAbsolute()) {
                    return subPath;
                }
            }
        }
        return null;
    }

    private File stripPath(File path, int stripCount) {
        if (path != null && stripCount > 0) {
            String[] components = SVNPatchTarget.decomposePath(path);
            StringBuffer buf = new StringBuffer();
            if (stripCount > components.length) {
                for (int i = stripCount; i < components.length; ++i) {
                    if (i > stripCount) {
                        buf.append(File.pathSeparator);
                    }
                    buf.append(components[i]);
                }
                return new File(buf.toString());
            }
        }
        return path;
    }

    public void rejectHunk(SVNPatchHunkInfo hi) throws SVNException, IOException {
        boolean eof;
        SVNPatchTarget target = this;
        SVNPatchHunk hunk = hi.getHunk();
        StringBuffer hunk_header = new StringBuffer();
        hunk_header.append("@@");
        hunk_header.append(" -").append(hunk.getOriginal().getStart()).append(",").append(hunk.getOriginal().getLength());
        hunk_header.append(" +").append(hunk.getModified().getStart()).append(",").append(hunk.getModified().getLength());
        hunk_header.append(" ").append(target.eolStr);
        target.reject.write(hunk_header);
        StringBuffer hunk_line = new StringBuffer();
        StringBuffer eol_str = new StringBuffer();
        do {
            hunk_line.setLength(0);
            eol_str.setLength(0);
            eof = hunk.getDiffText().readLineWithEol(hunk_line, eol_str);
            if (eof) continue;
            if (hunk_line.length() > 0) {
                target.reject.tryWrite(hunk_line);
            }
            if (eol_str.length() <= 0) continue;
            target.reject.tryWrite(eol_str);
        } while (!eof);
        target.hadRejects = true;
    }

    public void applyHunk(SVNPatchHunkInfo hi) throws SVNException, IOException {
        SVNPatchTarget target = this;
        SVNPatchHunk hunk = hi.getHunk();
        if (target.kind == SVNNodeKind.FILE) {
            target.copyLinesToTarget(hi.getMatchedLine() + hi.getFuzz());
            target.seekToLine(target.getCurrentLine() + hunk.getOriginal().getLength() - 2 * hi.getFuzz());
        }
        long lines_read = 0L;
        boolean eof = false;
        StringBuffer hunk_line = new StringBuffer();
        StringBuffer eol_str = new StringBuffer();
        do {
            if ((eof = hunk.getModifiedText().readLineWithEol(hunk_line, eol_str)) || ++lines_read <= (long)hi.getFuzz() || lines_read > (long)(hunk.getModified().getLength() - hi.getFuzz())) continue;
            if (hunk_line.length() > 0) {
                this.tryWrite(target.getPatched(), hunk_line);
            }
            if (eol_str.length() <= 0) continue;
            this.tryWrite(target.getPatched(), eol_str);
        } while (!eof);
    }

    public void seekToLine(int line) throws SVNException, IOException {
        if (line <= 0) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ASSERTION_FAIL, "Line to seek must be more than zero");
            SVNErrorManager.error(err, Level.FINE, SVNLogType.WC);
        }
        SVNPatchTarget target = this;
        if (line == target.currentLine) {
            return;
        }
        if (line <= target.lines.size()) {
            Long mark = (Long)target.lines.get(line - 1);
            target.stream.setSeekPosition(mark);
            target.currentLine = line;
        } else {
            StringBuffer dummy = new StringBuffer();
            while (target.currentLine < line) {
                target.readLine(dummy);
            }
        }
    }

    public void readLine(StringBuffer line) throws SVNException, IOException {
        SVNPatchTarget target = this;
        if (target.eof) {
            return;
        }
        if (target.currentLine > target.lines.size() + 1) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ASSERTION_FAIL, "Lines reading isn't sequenced");
            SVNErrorManager.error(err, Level.FINE, SVNLogType.WC);
        }
        if (target.currentLine == target.lines.size() + 1) {
            Long mark = new Long(target.stream.getSeekPosition());
            target.lines.add(mark);
        }
        StringBuffer line_raw = new StringBuffer();
        target.eof = target.stream.readLine(line_raw, target.eolStr);
        byte[] eol = target.eolStr.getBytes();
        line.append(SVNTranslator.translateString(line_raw.toString(), eol, target.keywords, false, false));
        ++target.currentLine;
    }

    public void copyLinesToTarget(int line) throws SVNException, IOException {
        SVNPatchTarget target = this;
        while (!(target.currentLine >= line && line != 0 || target.eof)) {
            StringBuffer target_line = new StringBuffer();
            target.readLine(target_line);
            if (!target.eof) {
                target_line.append(target.eolStr);
            }
            this.tryWrite(target.patched, target_line);
        }
    }

    public void installPatchedTarget(File absWCPath, boolean dryRun, SVNAdminArea wc) throws SVNException {
        SVNPatchTarget target = this;
        if (target.deleted) {
            if (!dryRun) {
                SVNWCManager.delete(wc.getWCAccess(), wc, target.getAbsPath(), false, false);
            }
        } else {
            if (target.isAdded() && !target.isParentDirExists()) {
                String component;
                int i;
                File absPath = absWCPath;
                String[] components = SVNPatchTarget.decomposePath(target.getRelPath());
                int present_components = 0;
                for (i = 0; i < components.length - 1; ++i) {
                    SVNNodeKind kind;
                    component = components[i];
                    absPath = new File(absPath, component);
                    SVNEntry entry = wc.getWCAccess().getEntry(absPath, false);
                    SVNNodeKind sVNNodeKind = kind = entry != null ? entry.getKind() : null;
                    if (kind == SVNNodeKind.FILE) {
                        target.skipped = true;
                        break;
                    }
                    if (kind == SVNNodeKind.DIR) {
                        if (entry.isDeleted()) {
                            target.skipped = true;
                            break;
                        }
                        ++present_components;
                        continue;
                    }
                    SVNFileType disk_kind = SVNFileType.getType(absPath);
                    if (disk_kind == SVNFileType.NONE) continue;
                    target.skipped = true;
                    break;
                }
                if (!target.isSkipped()) {
                    absPath = absWCPath;
                    for (i = 0; i < present_components; ++i) {
                        component = components[i];
                        absPath = new File(absPath, component);
                        if (dryRun) {
                            SVNEvent mergeCompletedEvent = SVNEventFactory.createSVNEvent(absPath, SVNNodeKind.NONE, null, -1L, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE, SVNStatusType.LOCK_INAPPLICABLE, SVNEventAction.ADD, null, null, null);
                            wc.getWCAccess().handleEvent(mergeCompletedEvent);
                            continue;
                        }
                        if (!absPath.mkdirs()) continue;
                        SVNWCManager.add(absPath, wc, null, -1L, SVNDepth.INFINITY);
                    }
                }
            }
            if (!dryRun && !target.isSkipped()) {
                SVNFileUtil.copyFile(target.getPatchedPath(), target.getAbsPath(), false);
                if (target.isAdded()) {
                    SVNWCManager.add(target.getAbsPath(), wc, null, -1L, SVNDepth.INFINITY);
                }
                SVNFileUtil.setExecutable(target.getAbsPath(), target.isExecutable());
            }
        }
        if (!dryRun && !target.skipped && target.hadRejects) {
            String rej_path = target.getAbsPath().getPath() + ".svnpatch.rej";
            SVNFileUtil.copyFile(target.getRejectPath(), new File(rej_path), true);
        }
    }

    public static String[] decomposePath(File path) {
        return SVNAdminArea.fromString(path.getPath(), File.pathSeparator);
    }

    public static SVNPatchTarget applyPatch(SVNPatch patch, File absWCPath, int stripCount, SVNAdminArea wc) throws SVNException, IOException {
        SVNPatchTarget target = SVNPatchTarget.initPatchTarget(patch, absWCPath, stripCount, wc);
        if (target.skipped) {
            return target;
        }
        for (SVNPatchHunk hunk : patch.getHunks()) {
            SVNPatchHunkInfo hi;
            int fuzz = 0;
            while ((hi = target.getHunkInfo(hunk, fuzz)).isRejected() && ++fuzz <= 2) {
            }
            target.hunks.add(hi);
        }
        for (SVNPatchHunkInfo hi : target.hunks) {
            if (hi.isRejected()) {
                target.rejectHunk(hi);
                continue;
            }
            target.applyHunk(hi);
        }
        if (target.kind == SVNNodeKind.FILE) {
            target.copyLinesToTarget(0);
            if (!target.eof) {
                target.skipped = true;
            }
        }
        if (target.getKind() == SVNNodeKind.FILE) {
            target.stream.close();
        }
        target.patched.close();
        target.reject.close();
        if (!target.skipped) {
            long workingFileSize;
            long patchedFileSize = target.patchedPath.length();
            long l = workingFileSize = target.kind == SVNNodeKind.FILE ? target.absPath.length() : 0L;
            if (patchedFileSize == 0L && workingFileSize > 0L) {
                target.deleted = target.kind != SVNNodeKind.NONE;
            } else if (workingFileSize == 0L && patchedFileSize == 0L) {
                if (target.kind != SVNNodeKind.FILE) {
                    target.skipped = true;
                }
            } else if (target.kind != SVNNodeKind.FILE && patchedFileSize > 0L) {
                target.added = true;
            }
        }
        return target;
    }

    public SVNPatchHunkInfo getHunkInfo(SVNPatchHunk hunk, int fuzz) throws SVNException, IOException {
        int matchedLine;
        SVNPatchTarget target = this;
        if (hunk.getOriginal().getStart() == 0) {
            matchedLine = target.getKind() == SVNNodeKind.FILE ? 0 : 1;
        } else if (hunk.getOriginal().getStart() > 0 && target.getKind() == SVNNodeKind.FILE) {
            int savedLine = target.getCurrentLine();
            boolean savedEof = target.isEof();
            target.seekToLine(hunk.getOriginal().getStart());
            matchedLine = target.scanForMatch(hunk, true, hunk.getOriginal().getStart() + 1, fuzz);
            if (matchedLine != hunk.getOriginal().getStart()) {
                target.seekToLine(1);
                matchedLine = target.scanForMatch(hunk, false, hunk.getOriginal().getStart(), fuzz);
                if (matchedLine == 0) {
                    matchedLine = target.scanForMatch(hunk, true, 0, fuzz);
                }
            }
            target.seekToLine(savedLine);
            target.eof = savedEof;
        } else {
            matchedLine = 0;
        }
        return new SVNPatchHunkInfo(hunk, matchedLine, matchedLine == 0, fuzz);
    }

    public int scanForMatch(SVNPatchHunk hunk, boolean matchFirst, int upperLine, int fuzz) throws SVNException, IOException {
        SVNPatchTarget target = this;
        int matched_line = 0;
        while (!(target.currentLine >= upperLine && upperLine != 0 || target.eof)) {
            boolean matched = target.matchHunk(hunk, fuzz);
            if (matched) {
                SVNPatchHunkInfo hi;
                boolean taken = false;
                Iterator i = target.hunks.iterator();
                while (i.hasNext() && !(taken = !(hi = (SVNPatchHunkInfo)i.next()).isRejected() && target.currentLine >= hi.getMatchedLine() && target.currentLine < hi.getMatchedLine() + hi.getHunk().getOriginal().getLength())) {
                }
                if (!taken) {
                    matched_line = target.currentLine;
                    if (matchFirst) break;
                }
            }
            target.seekToLine(target.currentLine + 1);
        }
        return matched_line;
    }

    private boolean matchHunk(SVNPatchHunk hunk, int fuzz) throws SVNException, IOException {
        boolean hunkEof;
        SVNPatchTarget target = this;
        StringBuffer hunkLine = new StringBuffer();
        StringBuffer targetLine = new StringBuffer();
        StringBuffer eol_str = new StringBuffer();
        boolean matched = false;
        if (target.eof) {
            return matched;
        }
        int savedLine = target.currentLine;
        int linesRead = 0;
        boolean linesMatched = false;
        hunk.getOriginalText().reset();
        do {
            hunkLine.setLength(0);
            eol_str.setLength(0);
            hunkEof = hunk.getOriginalText().readLineWithEol(hunkLine, eol_str);
            byte[] eol = eol_str.toString().getBytes();
            String hunk_line_translated = SVNTranslator.translateString(hunkLine.toString(), eol, target.keywords, false, false);
            ++linesRead;
            targetLine.setLength(0);
            target.readLine(targetLine);
            if (hunkEof) continue;
            linesMatched = linesRead <= fuzz && hunk.getLeadingContext() > (long)fuzz ? true : (linesRead > hunk.getOriginal().getLength() - fuzz && hunk.getTrailingContext() > (long)fuzz ? true : hunk_line_translated.equals(targetLine.toString()));
        } while (linesMatched && !hunkEof && !target.eof);
        if (hunkEof) {
            matched = linesMatched;
        } else if (target.eof) {
            hunkEof = hunk.getOriginalText().readLineWithEol(hunkLine, null);
            matched = hunkLine.length() == 0 && hunkEof ? linesMatched : false;
        }
        target.seekToLine(savedLine);
        target.eof = false;
        return matched;
    }

    private void tryWrite(OutputStream stream, StringBuffer buffer) throws IOException {
        stream.write(buffer.toString().getBytes());
    }

    public void sendPatchNotification(SVNAdminArea wc) throws SVNException {
        SVNPatchTarget target = this;
        ISVNEventHandler eventHandler = wc.getWCAccess().getEventHandler();
        if (eventHandler == null) {
            return;
        }
        SVNEventAction action = target.skipped ? SVNEventAction.SKIP : (target.deleted ? SVNEventAction.DELETE : (target.added ? SVNEventAction.ADD : SVNEventAction.PATCH));
        SVNStatusType contentState = SVNStatusType.INAPPLICABLE;
        contentState = action == SVNEventAction.SKIP ? (target.parentDirExists && (target.kind == SVNNodeKind.NONE || target.kind == SVNNodeKind.UNKNOWN) ? SVNStatusType.MISSING : (target.kind == SVNNodeKind.DIR ? SVNStatusType.OBSTRUCTED : SVNStatusType.UNKNOWN)) : (target.hadRejects ? SVNStatusType.CONFLICTED : (target.localMods ? SVNStatusType.MERGED : SVNStatusType.CHANGED));
        SVNEvent notify = SVNEventFactory.createSVNEvent(target.absPath != null ? target.absPath : target.relPath, target.kind, null, 0L, contentState, SVNStatusType.INAPPLICABLE, SVNStatusType.LOCK_INAPPLICABLE, action, null, null, null);
        eventHandler.handleEvent(notify, -1.0);
        if (action == SVNEventAction.PATCH) {
            for (SVNPatchHunkInfo hi : target.hunks) {
                action = hi.isRejected() ? SVNEventAction.PATCH_REJECTED_HUNK : SVNEventAction.PATCH_APPLIED_HUNK;
                SVNEvent notify2 = SVNEventFactory.createSVNEvent(target.absPath != null ? target.absPath : target.relPath, target.kind, null, 0L, action, null, null, null);
                notify2.setInfo(hi);
                eventHandler.handleEvent(notify2, -1.0);
            }
        }
    }
}

