/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import org.tmatesoft.sqljet.core.table.SqlJetDb;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSWriteLock;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class FSHotCopier {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runHotCopy(FSFS srcOwner, File dstPath) throws SVNException {
        FSWriteLock dbLogsLock = FSWriteLock.getDBLogsLock(srcOwner, false);
        File srcPath = srcOwner.getRepositoryRoot();
        FSWriteLock fSWriteLock = dbLogsLock;
        synchronized (fSWriteLock) {
            try {
                dbLogsLock.lock();
                this.createRepositoryLayout(srcPath, dstPath);
                File dstReposLocksDir = new File(dstPath, "locks");
                try {
                    this.createReposDir(dstReposLocksDir);
                }
                catch (SVNException svne) {
                    SVNErrorMessage err = svne.getErrorMessage().wrap("Creating lock dir");
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                }
                this.createDBLock(dstReposLocksDir);
                this.createDBLogsLock(dstReposLocksDir);
                File dstDBDir = new File(dstPath, "db");
                dstDBDir.mkdirs();
                SVNFileUtil.setSGID(dstDBDir);
                FSFS dstOwner = new FSFS(dstPath);
                String fsType = srcOwner.getFSType();
                this.hotCopy(srcOwner, dstOwner);
                this.writeFSType(dstOwner, fsType);
                SVNFileUtil.writeVersionFile(new File(dstPath, "format"), srcOwner.getReposFormat());
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                dbLogsLock.unlock();
                FSWriteLock.release(dbLogsLock);
                throw throwable;
            }
            dbLogsLock.unlock();
            FSWriteLock.release(dbLogsLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeFSType(FSFS dstOwner, String fsType) throws SVNException {
        OutputStream fsTypeStream = null;
        try {
            try {
                fsTypeStream = SVNFileUtil.openFileForWriting(dstOwner.getFSTypeFile());
                fsType = fsType + '\n';
                fsTypeStream.write(fsType.getBytes("US-ASCII"));
            }
            catch (IOException ioe) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                SVNErrorManager.error(err, SVNLogType.FSFS);
                Object var7_5 = null;
                SVNFileUtil.closeFile(fsTypeStream);
                return;
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            SVNFileUtil.closeFile(fsTypeStream);
            throw throwable;
        }
        SVNFileUtil.closeFile(fsTypeStream);
    }

    private void createRepositoryLayout(File srcPath, File dstPath) throws SVNException {
        File[] children = srcPath.listFiles();
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            String childName = child.getName();
            if (childName.equals("db") || childName.equals("locks") || childName.equals("format")) continue;
            File dstChildPath = new File(dstPath, childName);
            if (child.isDirectory()) {
                this.createReposDir(dstChildPath);
                this.createRepositoryLayout(child, dstChildPath);
                continue;
            }
            if (!child.isFile()) continue;
            SVNFileUtil.copyFile(child, dstChildPath, true);
        }
    }

    private void createReposDir(File dir) throws SVNException {
        if (dir.exists()) {
            File[] dstChildren = dir.listFiles();
            if (dstChildren.length > 0) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.DIR_NOT_EMPTY, "''{0}'' exists and is non-empty", (Object)dir);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
        } else {
            dir.mkdirs();
        }
    }

    private void createDBLock(File dstPath) throws SVNException {
        try {
            SVNFileUtil.createFile(new File(dstPath, "db.lock"), "This file is not used by Subversion 1.3.x or later.However, its existence is required for compatibility withSubversion 1.2.x or earlier.", "US-ASCII");
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Creating db lock file");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
    }

    private void createDBLogsLock(File dstPath) throws SVNException {
        try {
            SVNFileUtil.createFile(new File(dstPath, "db-logs.lock"), "This file is not used by Subversion 1.3.x or later.However, its existence is required for compatibility withSubversion 1.2.x or earlier.", "US-ASCII");
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Creating db logs lock file");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void hotCopy(FSFS srcOwner, FSFS dstOwner) throws SVNException {
        File srcNodeOriginsDir;
        File srcLocksDir;
        long rev;
        long maxFilesPerDirectory;
        long youngestRev;
        int format;
        block17: {
            format = srcOwner.readDBFormat();
            FSRepositoryUtil.checkReposDBFormat(format);
            SVNFileUtil.copyFile(srcOwner.getCurrentFile(), dstOwner.getCurrentFile(), true);
            SVNFileUtil.copyFile(srcOwner.getUUIDFile(), dstOwner.getUUIDFile(), true);
            long minUnpackedRevision = 0L;
            if (format >= 4) {
                SVNFileUtil.copyFile(srcOwner.getMinUnpackedRevFile(), dstOwner.getMinUnpackedRevFile(), true);
                minUnpackedRevision = srcOwner.getMinUnpackedRev();
            }
            youngestRev = dstOwner.getYoungestRevision();
            File dstRevsDir = dstOwner.getDBRevsDir();
            dstRevsDir.mkdirs();
            maxFilesPerDirectory = srcOwner.getMaxFilesPerDirectory();
            for (rev = 0L; rev < minUnpackedRevision; rev += srcOwner.getMaxFilesPerDirectory()) {
                long packedShard = rev / maxFilesPerDirectory;
                SVNFileUtil.copyDirectory(srcOwner.getPackDir(packedShard), dstOwner.getPackDir(packedShard), false, null);
            }
            SVNErrorManager.assertionFailure(rev == minUnpackedRevision, "expected minimal unpacked revision " + String.valueOf(minUnpackedRevision) + ", but real revision is " + String.valueOf(rev), SVNLogType.FSFS);
            while (rev <= youngestRev) {
                File dstDir = dstRevsDir;
                if (maxFilesPerDirectory > 0L) {
                    String shard = String.valueOf(rev / maxFilesPerDirectory);
                    dstDir = new File(dstRevsDir, shard);
                }
                SVNFileUtil.copyFile(srcOwner.getRevisionFile(rev), new File(dstDir, String.valueOf(rev)), true);
                ++rev;
            }
            long min_unpacked_revprop = 0L;
            if (format >= 6) {
                SVNSqlJetDb revPropDb;
                block16: {
                    min_unpacked_revprop = srcOwner.getMinUnpackedRevProp();
                    SVNFileUtil.copyFile(srcOwner.getMinUnpackedRevPropPath(), dstOwner.getMinUnpackedRevPropPath(), true);
                    final File srcRevPropDb = srcOwner.getRevisionPropertiesDbPath();
                    final File dstRevPropDb = dstOwner.getRevisionPropertiesDbPath();
                    revPropDb = SVNSqlJetDb.open(srcOwner.getRevisionPropertiesDbPath(), SVNSqlJetDb.Mode.ReadWrite);
                    try {
                        Object var21_18;
                        try {
                            SVNException e = (SVNException)revPropDb.getDb().runReadTransaction(new ISqlJetTransaction(){

                                public Object run(SqlJetDb db) throws SqlJetException {
                                    try {
                                        SVNFileUtil.copyFile(srcRevPropDb, dstRevPropDb, true);
                                    }
                                    catch (SVNException e) {
                                        return e;
                                    }
                                    return null;
                                }
                            });
                            if (e != null) {
                                throw e;
                            }
                            var21_18 = null;
                            break block16;
                        }
                        catch (SqlJetException e) {
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
                            SVNErrorManager.error(err, SVNLogType.FSFS);
                            var21_18 = null;
                            revPropDb.close();
                        }
                        break block17;
                    }
                    catch (Throwable throwable) {
                        Object var21_19 = null;
                        revPropDb.close();
                        throw throwable;
                    }
                }
                revPropDb.close();
            }
        }
        File dstRevPropsDir = dstOwner.getRevisionPropertiesRoot();
        for (rev = min_unpacked_revprop; rev <= youngestRev; ++rev) {
            File dstDir = dstRevPropsDir;
            if (maxFilesPerDirectory > 0L) {
                String shard = String.valueOf(rev / maxFilesPerDirectory);
                dstDir = new File(dstRevPropsDir, shard);
            }
            SVNFileUtil.copyFile(srcOwner.getRevisionPropertiesFile(rev, false), new File(dstDir, String.valueOf(rev)), true);
        }
        dstOwner.getTransactionsParentDir().mkdirs();
        if (format >= 3) {
            dstOwner.getTransactionProtoRevsDir().mkdirs();
        }
        if ((srcLocksDir = srcOwner.getDBLocksDir()).exists()) {
            SVNFileUtil.copyDirectory(srcLocksDir, dstOwner.getDBLocksDir(), false, null);
        }
        if ((srcNodeOriginsDir = srcOwner.getNodeOriginsDir()).exists()) {
            SVNFileUtil.copyDirectory(srcNodeOriginsDir, dstOwner.getNodeOriginsDir(), false, null);
        }
        if (format >= 3) {
            SVNFileUtil.copyFile(srcOwner.getTransactionCurrentFile(), dstOwner.getTransactionCurrentFile(), true);
        }
        dstOwner.writeDBFormat(format, maxFilesPerDirectory, false);
    }
}

