/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.svg;

import java.awt.Color;
import java.awt.Shape;
import java.util.HashMap;
import oracle.dss.util.shapes.Fill;
import oracle.dss.util.shapes.FillColor;
import oracle.dss.util.shapes.FillGradient;
import oracle.dss.util.shapes.Path;
import oracle.dss.util.shapes.Stroke;
import oracle.dss.util.svg.CustomShapeUtils;

public class CustomShape
extends Path {
    private int m_zOrder;

    public CustomShape(Shape shape, Color fillColor, Color borderColor, HashMap sfxMap, int strokeWidth, int zOrder) {
        super(shape);
        this.setFill(fillColor, sfxMap);
        this.setStroke(borderColor, strokeWidth);
        this.m_zOrder = zOrder;
    }

    private void setFill(Color fillColor, HashMap sfxMap) {
        Fill fill = null;
        if (sfxMap != null) {
            fill = new FillGradient(CustomShapeUtils.convertSFXMapToGradientObj(sfxMap, super.getShape()));
        } else if (fillColor != null) {
            fill = new FillColor();
            fill.setColor(fillColor);
        }
        this.setFill(fill);
    }

    private void setStroke(Color borderColor, int strokeWidth) {
        Stroke s = this.getStroke() == null ? new Stroke() : this.getStroke();
        this.setStroke(s);
        s.setColor(borderColor);
        s.setWidth(strokeWidth);
    }
}

