/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.shapes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.shapes.CommonRenderer;
import oracle.dss.util.shapes.Container;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Fill;
import oracle.dss.util.shapes.FillColor;
import oracle.dss.util.shapes.FillGradient;
import oracle.dss.util.shapes.FillTexture;
import oracle.dss.util.shapes.Filter;
import oracle.dss.util.shapes.Image;
import oracle.dss.util.shapes.Label;
import oracle.dss.util.shapes.Stroke;

public class Graphics2DRenderer
implements CommonRenderer {
    private Graphics2D m_graphics;
    private AffineTransform m_origAT = null;
    private ErrorHandler m_errorHandler;
    private BasicStroke m_defaultStroke;

    public Graphics2DRenderer(Graphics2D g, ErrorHandler eh) {
        this.m_graphics = g;
        this.m_errorHandler = eh;
        this.m_defaultStroke = new BasicStroke();
    }

    private void _handleFillNone() {
        this.m_graphics.setColor(null);
    }

    private void drawContainer(Container container) {
        if (container == null) {
            return;
        }
        if (container.getShape() != null) {
            this.drawShape(container);
        }
        for (DrawableObject drawable : container.getDrawables()) {
            this.drawShape(drawable);
        }
    }

    @Override
    public void drawShape(DrawableObject obj) {
        if (obj instanceof Container) {
            this.drawContainer((Container)obj);
            return;
        }
        Shape origClip = this.m_graphics.getClip();
        this.m_origAT = this.m_graphics.getTransform();
        AffineTransform at = null;
        Shape s = obj.getShape();
        Shape clip = obj.getClipPath();
        at = obj.getTransform();
        if (at != null) {
            if (s != null) {
                s = at.createTransformedShape(s);
            }
            if (clip != null) {
                clip = at.createTransformedShape(clip);
            }
        }
        this.m_graphics.setClip(clip);
        this.m_graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (obj.hasFill()) {
            Fill f = obj.getFill();
            this.renderFill(f, s);
            this.m_graphics.fill(s);
        }
        if (obj.hasStroke()) {
            Stroke stroke = obj.getStroke();
            this.renderStroke(stroke, at);
            this.m_graphics.draw(s);
        }
        if (obj.hasFilter()) {
            Filter filter = obj.getFilter();
            this.renderFilter(filter);
        }
        if (obj instanceof Image) {
            Image img = (Image)obj;
            at = AffineTransform.getTranslateInstance(s.getBounds2D().getX(), s.getBounds2D().getY());
            this.m_graphics.drawImage(img.getImage(), at, null);
        } else if (obj instanceof Label) {
            Label l = (Label)obj;
            this.m_graphics.setColor(l.getFontColor());
            Font f = l.getFont();
            this.m_graphics.setFont(f);
            FontMetrics fm = this.m_graphics.getFontMetrics();
            int ascent = fm.getMaxAscent();
            int descent = fm.getMaxDescent();
            String text = l.toString();
            float x = (float)s.getBounds2D().getX();
            float y = (float)(s.getBounds2D().getY() + s.getBounds2D().getHeight() / 2.0 - (double)(descent / 2) + (double)(ascent / 2));
            if (at != null) {
                this.m_graphics.setTransform(at);
            }
            this.m_graphics.drawString(text, x, y);
        }
        this.m_graphics.setTransform(this.m_origAT);
        this.m_graphics.setClip(origClip);
    }

    @Override
    public void renderFill(Fill fill, Shape shape) {
        if (fill instanceof FillColor) {
            FillColor fillColor = (FillColor)fill;
            Color c = fillColor.getColor();
            if (c == null) {
                this._handleFillNone();
            } else {
                this.m_graphics.setColor(fillColor.getColor());
            }
        } else if (fill instanceof FillGradient && ((FillGradient)fill).getGradientObj() != null) {
            Paint paint = ((FillGradient)fill).getGradientObj().getPaint(shape);
            this.m_graphics.setPaint(paint);
        } else if (fill instanceof FillTexture) {
            FillTexture texture = (FillTexture)fill;
            java.awt.Image img = texture.getImage();
            int height = img.getHeight(null);
            int width = img.getWidth(null);
            BufferedImage bufferedImage = new BufferedImage(width, height, 2);
            Graphics2D textureContext = bufferedImage.createGraphics();
            textureContext.drawImage(img, 0, 0, null);
            textureContext.dispose();
            Rectangle r = shape.getBounds();
            if (r.width <= 0 || r.height <= 0) {
                return;
            }
            TexturePaint texturePaint = new TexturePaint(bufferedImage, new Rectangle(0, 0, width, height));
            this.m_graphics.setPaint(texturePaint);
        }
    }

    @Override
    public void renderStroke(Stroke stroke, AffineTransform transform) {
        String style;
        float width = stroke.getWidth();
        if (transform != null) {
            width = (float)((double)width * transform.getScaleX());
        }
        if ((style = stroke.getStyle()) != null) {
            if (style.equals("none") || style.equals("hidden")) {
                width = 0.0f;
            } else if (style.equals("dashed")) {
                float[] dash = new float[]{10.0f};
                this.m_graphics.setStroke(new BasicStroke(width, 0, 0, 10.0f, dash, 0.0f));
            } else if (style.equals("dotted")) {
                float[] dots = new float[]{width, 2.0f * width};
                this.m_graphics.setStroke(new BasicStroke(width, 1, 1, 10.0f, dots, 0.0f));
            } else {
                this.m_graphics.setStroke(new BasicStroke(width));
            }
        } else {
            if (stroke == null) {
                return;
            }
            int cap = stroke.getCap();
            float miter = stroke.getMiterLimit();
            int join = stroke.getJoin();
            float[] dash = stroke.getDash();
            float phase = stroke.getDashPhase();
            this.m_graphics.setStroke(new BasicStroke(width, cap, join, miter, dash, phase));
        }
        Color c = stroke.getColor();
        if (c != null) {
            this.m_graphics.setColor(stroke.getColor());
        } else {
            this._handleFillNone();
        }
    }

    @Override
    public void renderFilter(Filter filter) {
    }
}

